/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.client;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.egit.github.core.IResourceProvider;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubResponse;
import org.eclipse.egit.github.core.client.NoSuchPageException;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.util.UrlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageIterator<V>
implements Iterator<Collection<V>>,
Iterable<Collection<V>> {
    protected final PagedRequest<V> request;
    protected final GitHubClient client;
    protected int nextPage;
    protected int lastPage;
    protected String next;
    protected String last;

    public PageIterator(PagedRequest<V> request, GitHubClient client) {
        this.request = request;
        this.client = client;
        this.next = request.getUri();
        this.nextPage = this.parsePageNumber(this.next);
    }

    protected int parsePageNumber(String uri) {
        URI parsed;
        if (uri == null || uri.length() == 0) {
            return -1;
        }
        try {
            parsed = new URI(uri);
        }
        catch (URISyntaxException e) {
            return -1;
        }
        String param = UrlUtils.getParam(parsed, "page");
        if (param == null || param.length() == 0) {
            return -1;
        }
        try {
            return Integer.parseInt(param);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public int getNextPage() {
        return this.nextPage;
    }

    public int getLastPage() {
        return this.lastPage;
    }

    public String getNextUri() {
        return this.next;
    }

    public String getLastUri() {
        return this.last;
    }

    @Override
    public boolean hasNext() {
        return this.nextPage == 0 || this.next != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not supported");
    }

    @Override
    public Collection<V> next() {
        GitHubResponse response;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.next != null) {
            if (this.nextPage < 1) {
                this.request.setUri(this.next);
            } else {
                try {
                    this.request.setUri(new URL(this.next).getFile());
                }
                catch (MalformedURLException e) {
                    this.request.setUri(this.next);
                }
            }
        }
        try {
            response = this.client.get(this.request);
        }
        catch (IOException e) {
            throw new NoSuchPageException(e);
        }
        Collection<Object> resources = null;
        Object body = response.getBody();
        if (body != null) {
            resources = body instanceof Collection ? (Collection)body : (body instanceof IResourceProvider ? ((IResourceProvider)body).getResources() : Collections.singletonList(body));
        }
        if (resources == null) {
            resources = Collections.emptyList();
        }
        ++this.nextPage;
        this.next = response.getNext();
        this.nextPage = this.parsePageNumber(this.next);
        this.last = response.getLast();
        this.lastPage = this.parsePageNumber(this.last);
        return resources;
    }

    public PagedRequest<V> getRequest() {
        return this.request;
    }

    @Override
    public Iterator<Collection<V>> iterator() {
        return this;
    }
}

