/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.set.aphrodite.common.Utils;
import org.jboss.set.aphrodite.config.AphroditeConfig;
import org.jboss.set.aphrodite.domain.Codebase;
import org.jboss.set.aphrodite.domain.Comment;
import org.jboss.set.aphrodite.domain.CommitStatus;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.domain.Label;
import org.jboss.set.aphrodite.domain.Patch;
import org.jboss.set.aphrodite.domain.PatchState;
import org.jboss.set.aphrodite.domain.Repository;
import org.jboss.set.aphrodite.domain.SearchCriteria;
import org.jboss.set.aphrodite.domain.Stream;
import org.jboss.set.aphrodite.domain.StreamComponent;
import org.jboss.set.aphrodite.spi.AphroditeException;
import org.jboss.set.aphrodite.spi.IssueTrackerService;
import org.jboss.set.aphrodite.spi.NotFoundException;
import org.jboss.set.aphrodite.spi.RepositoryService;
import org.jboss.set.aphrodite.spi.StreamService;

public class Aphrodite
implements AutoCloseable {
    public static final String FILE_PROPERTY = "aphrodite.config";
    private static final Log LOG = LogFactory.getLog(Aphrodite.class);
    private static Aphrodite instance;
    private final List<IssueTrackerService> issueTrackers = new ArrayList<IssueTrackerService>();
    private final List<RepositoryService> repositories = new ArrayList<RepositoryService>();
    private final List<StreamService> streamServices = new ArrayList<StreamService>();
    private ExecutorService executorService;
    private AphroditeConfig config;

    public static synchronized Aphrodite instance() throws AphroditeException {
        if (instance == null) {
            instance = new Aphrodite();
        }
        return instance;
    }

    public static synchronized Aphrodite instance(AphroditeConfig config) throws AphroditeException {
        if (instance != null) {
            if (Aphrodite.instance.config.equals(config)) {
                return instance;
            }
            throw new IllegalStateException("Cannot create a new instance of " + Aphrodite.class.getName() + " as it is a singleton which has already been initialised.");
        }
        instance = new Aphrodite(config);
        return Aphrodite.instance();
    }

    @Override
    public void close() throws Exception {
        this.executorService.shutdown();
        this.issueTrackers.forEach(IssueTrackerService::destroy);
        this.issueTrackers.clear();
        this.repositories.forEach(RepositoryService::destroy);
        this.repositories.clear();
    }

    private Aphrodite() throws AphroditeException {
        String propFileLocation = System.getProperty(FILE_PROPERTY);
        if (propFileLocation == null) {
            throw new IllegalArgumentException("Property 'aphrodite.config' must be set");
        }
        try (JsonReader jr = Json.createReader(new FileInputStream(propFileLocation));){
            this.init(AphroditeConfig.fromJson(jr.readObject()));
        }
        catch (IOException e) {
            Utils.logException(LOG, "Unable to load file: " + propFileLocation, e);
            throw new AphroditeException(e);
        }
    }

    private Aphrodite(AphroditeConfig config) throws AphroditeException {
        this.init(config);
    }

    private void init(AphroditeConfig config) throws AphroditeException {
        boolean initialised;
        if (LOG.isInfoEnabled()) {
            LOG.info("Initiating Aphrodite ...");
        }
        this.config = config;
        this.executorService = config.getExecutorService();
        AphroditeConfig mutableConfig = new AphroditeConfig(config);
        for (IssueTrackerService is : ServiceLoader.load(IssueTrackerService.class)) {
            initialised = is.init(mutableConfig);
            if (!initialised) continue;
            this.issueTrackers.add(is);
        }
        for (RepositoryService rs : ServiceLoader.load(RepositoryService.class)) {
            initialised = rs.init(mutableConfig);
            if (!initialised) continue;
            this.repositories.add(rs);
        }
        if (this.issueTrackers.isEmpty() && this.repositories.isEmpty()) {
            throw new AphroditeException("Unable to initiatilise Aphrodite, as a valid " + IssueTrackerService.class.getName() + " or " + RepositoryService.class.getName() + " does not exist.");
        }
        this.initialiseStreams(mutableConfig);
        if (LOG.isInfoEnabled()) {
            LOG.info("Aphrodite Initialisation Complete");
        }
    }

    private void initialiseStreams(AphroditeConfig mutableConfig) throws AphroditeException {
        if (!mutableConfig.getStreamConfigs().isEmpty() && this.repositories.isEmpty()) {
            throw new AphroditeException("Unable to initialise any Stream Services as no " + RepositoryService.class.getName() + " have been created.");
        }
        for (StreamService ss : ServiceLoader.load(StreamService.class)) {
            try {
                boolean initialised = ss.init(this, mutableConfig);
                if (!initialised) continue;
                this.streamServices.add(ss);
            }
            catch (NotFoundException e) {
                throw new AphroditeException("Unable to initiatilise Aphrodite as an error was thrown when initiating " + ss.getClass().getName() + ": " + e);
            }
        }
    }

    public Issue getIssue(URL url) throws NotFoundException {
        Objects.requireNonNull(url, "url cannot be null");
        this.checkIssueTrackerExists();
        for (IssueTrackerService trackerService : this.issueTrackers) {
            if (!trackerService.urlExists(url)) continue;
            return trackerService.getIssue(url);
        }
        throw new NotFoundException("No issues found which correspond to url: " + url);
    }

    public List<Issue> getIssues(Collection<URL> urls) {
        Objects.requireNonNull(urls, "the collection of urls cannot be null");
        if (urls.isEmpty()) {
            return new ArrayList<Issue>();
        }
        List requests = this.issueTrackers.stream().map(tracker -> CompletableFuture.supplyAsync(() -> tracker.getIssues(urls), this.executorService)).collect(Collectors.toList());
        return requests.stream().map(CompletableFuture::join).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Issue> searchIssues(SearchCriteria searchCriteria) {
        Objects.requireNonNull(searchCriteria, "searchCriteria cannot be null");
        this.checkIssueTrackerExists();
        if (searchCriteria.isEmpty()) {
            return new ArrayList<Issue>();
        }
        List searchRequests = this.issueTrackers.stream().map(tracker -> CompletableFuture.supplyAsync(() -> tracker.searchIssues(searchCriteria), this.executorService)).collect(Collectors.toList());
        return searchRequests.stream().map(CompletableFuture::join).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Issue> searchIssuesByFilter(URL filterUrl) throws NotFoundException {
        Objects.requireNonNull(filterUrl, "filterUrl cannot be null");
        this.checkIssueTrackerExists();
        for (IssueTrackerService trackerService : this.issueTrackers) {
            if (!trackerService.urlExists(filterUrl)) continue;
            return trackerService.searchIssuesByFilter(filterUrl);
        }
        throw new NotFoundException("No filter found which correspond to url: " + filterUrl);
    }

    public boolean updateIssue(Issue issue) throws NotFoundException, AphroditeException {
        Objects.requireNonNull(issue, "issue cannot be null");
        this.checkIssueTrackerExists();
        for (IssueTrackerService trackerService : this.issueTrackers) {
            if (!trackerService.urlExists(issue.getURL())) continue;
            return trackerService.updateIssue(issue);
        }
        throw new NotFoundException("No issues found which correspond to url: " + issue.getURL());
    }

    public void addCommentToIssue(Issue issue, Comment comment) throws NotFoundException {
        Objects.requireNonNull(issue, "issue cannot be null");
        Objects.requireNonNull(comment, "comment cannot be null");
        this.checkIssueTrackerExists();
        for (IssueTrackerService trackerService : this.issueTrackers) {
            if (!trackerService.urlExists(issue.getURL())) continue;
            trackerService.addCommentToIssue(issue, comment);
            return;
        }
        throw new NotFoundException("No issues found which correspond to url: " + issue.getURL());
    }

    public boolean addCommentToIssue(Map<Issue, Comment> commentMap) {
        this.checkIssueTrackerExists();
        Objects.requireNonNull(commentMap, "commentMap cannot be null");
        boolean isSuccess = true;
        for (IssueTrackerService trackerService : this.issueTrackers) {
            if (trackerService.addCommentToIssue(commentMap)) continue;
            isSuccess = false;
        }
        return isSuccess;
    }

    public boolean addCommentToIssue(Collection<Issue> issues, Comment comment) {
        this.checkIssueTrackerExists();
        Objects.requireNonNull(issues, "issues collection cannot be null");
        Objects.requireNonNull(comment, "comment cannot be null");
        boolean isSuccess = true;
        for (IssueTrackerService trackerService : this.issueTrackers) {
            if (trackerService.addCommentToIssue(issues, comment)) continue;
            isSuccess = false;
        }
        return isSuccess;
    }

    public List<Issue> getIssuesAssociatedWith(Patch patch) {
        this.checkIssueTrackerExists();
        Objects.requireNonNull(patch, "patch cannot be null");
        return this.issueTrackers.stream().map(service -> service.getIssuesAssociatedWith(patch)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Repository getRepository(URL url) throws NotFoundException {
        this.checkRepositoryServiceExists();
        Objects.requireNonNull(url, "url cannot be null");
        for (RepositoryService repositoryService : this.repositories) {
            if (!repositoryService.repositoryAccessable(url) || !repositoryService.urlExists(url)) continue;
            return repositoryService.getRepository(url);
        }
        throw new NotFoundException("No repositories found which correspond to url: " + url);
    }

    public List<Patch> getPatchesAssociatedWith(Issue issue) throws NotFoundException {
        this.checkRepositoryServiceExists();
        Objects.requireNonNull(issue, "issue cannot be null");
        ArrayList<Patch> patches = new ArrayList<Patch>();
        for (RepositoryService repositoryService : this.repositories) {
            patches.addAll(repositoryService.getPatchesAssociatedWith(issue));
        }
        return patches;
    }

    public List<Patch> getPatchesByState(Repository repository, PatchState state) throws NotFoundException {
        this.checkRepositoryServiceExists();
        Objects.requireNonNull(repository, "repository cannot be null");
        Objects.requireNonNull(state, "state cannot be null");
        for (RepositoryService repositoryService : this.repositories) {
            if (!repositoryService.urlExists(repository.getURL())) continue;
            return repositoryService.getPatchesByState(repository, state);
        }
        return new ArrayList<Patch>();
    }

    public Patch getPatch(URL url) throws NotFoundException {
        this.checkRepositoryServiceExists();
        Objects.requireNonNull(url, "url cannot be null");
        for (RepositoryService repositoryService : this.repositories) {
            if (!repositoryService.repositoryAccessable(url) || !repositoryService.urlExists(url)) continue;
            return repositoryService.getPatch(url);
        }
        throw new NotFoundException("No patch found which corresponds to url: " + url);
    }

    public List<Label> getLabelsFromRepository(Repository repository) throws NotFoundException {
        this.checkRepositoryServiceExists();
        Objects.requireNonNull(repository, "repository cannot be null");
        for (RepositoryService repositoryService : this.repositories) {
            if (!repositoryService.urlExists(repository.getURL())) continue;
            return repositoryService.getLabelsFromRepository(repository);
        }
        return new ArrayList<Label>();
    }

    public List<Label> getLabelsFromPatch(Patch patch) throws NotFoundException {
        this.checkRepositoryServiceExists();
        Objects.requireNonNull(patch, "patch cannot be null");
        for (RepositoryService repositoryService : this.repositories) {
            if (!repositoryService.urlExists(patch.getURL())) continue;
            return repositoryService.getLabelsFromPatch(patch);
        }
        return new ArrayList<Label>();
    }

    public boolean isRepositoryLabelsModifiable(Repository repository) throws NotFoundException {
        this.checkRepositoryServiceExists();
        Objects.requireNonNull(repository, "repository cannot be null");
        for (RepositoryService repositoryService : this.repositories) {
            if (!repositoryService.urlExists(repository.getURL())) continue;
            return repositoryService.hasModifiableLabels(repository);
        }
        throw new NotFoundException("No repository found which corresponds to url: " + repository.getURL());
    }

    public void setLabelsToPatch(Patch patch, List<Label> labels) throws NotFoundException, AphroditeException {
        this.checkRepositoryServiceExists();
        Objects.requireNonNull(patch, "patch cannot be null");
        Objects.requireNonNull(labels, "labels cannot be null");
        for (RepositoryService repositoryService : this.repositories) {
            if (!repositoryService.urlExists(patch.getURL())) continue;
            repositoryService.setLabelsToPatch(patch, labels);
        }
    }

    public void removeLabelFromPatch(Patch patch, String name) throws NotFoundException {
        this.checkRepositoryServiceExists();
        Objects.requireNonNull(patch, "patch cannot be null");
        Objects.requireNonNull(name, "labelname cannot be null");
        for (RepositoryService repositoryService : this.repositories) {
            if (!repositoryService.urlExists(patch.getURL())) continue;
            repositoryService.removeLabelFromPatch(patch, name);
        }
    }

    public void addCommentToPatch(Patch patch, String comment) throws NotFoundException {
        this.checkRepositoryServiceExists();
        Objects.requireNonNull(patch, "patch cannot be null");
        Objects.requireNonNull(comment, "comment cannot be null");
        for (RepositoryService repositoryService : this.repositories) {
            if (!repositoryService.urlExists(patch.getURL())) continue;
            repositoryService.addCommentToPatch(patch, comment);
            return;
        }
        throw new NotFoundException("No patch found which corresponds to patch.");
    }

    public void addLabelToPatch(Patch patch, String labelName) throws NotFoundException {
        this.checkRepositoryServiceExists();
        Objects.requireNonNull(patch, "patch cannot be null");
        Objects.requireNonNull(labelName, "labelName cannot be null");
        for (RepositoryService repositoryService : this.repositories) {
            if (!repositoryService.urlExists(patch.getURL())) continue;
            repositoryService.addLabelToPatch(patch, labelName);
        }
    }

    public List<Patch> findPatchesRelatedTo(Patch patch) {
        this.checkRepositoryServiceExists();
        Objects.requireNonNull(patch, "patch cannot be null");
        return this.repositories.stream().filter(service -> service.urlExists(patch.getURL())).flatMap(service -> service.findPatchesRelatedTo(patch).stream()).collect(Collectors.toList());
    }

    public CommitStatus getCommitStatusFromPatch(Patch patch) throws NotFoundException {
        this.checkRepositoryServiceExists();
        Objects.requireNonNull(patch, "patch cannot be null");
        for (RepositoryService repositoryService : this.repositories) {
            if (!repositoryService.urlExists(patch.getURL())) continue;
            return repositoryService.getCommitStatusFromPatch(patch);
        }
        throw new NotFoundException("No commit status found for patch:" + patch.getURL());
    }

    public List<Stream> getAllStreams() {
        this.checkStreamServiceExists();
        return this.streamServices.stream().flatMap(streamService -> streamService.getStreams().stream()).collect(Collectors.toList());
    }

    public Stream getStream(String streamName) throws NotFoundException {
        this.checkStreamServiceExists();
        Objects.requireNonNull(streamName, "stream name can not be null");
        for (StreamService ss : this.streamServices) {
            Stream stream = ss.getStream(streamName);
            if (stream == null) continue;
            return stream;
        }
        throw new NotFoundException("No Stream exists with the name '" + streamName + "'");
    }

    public List<Repository> getDistinctURLRepositoriesFromStreams() {
        this.checkStreamServiceExists();
        return this.streamServices.stream().flatMap(streamService -> streamService.getDistinctURLRepositories().stream()).distinct().collect(Collectors.toList());
    }

    public List<Repository> getDistinctURLRepositoriesByStream(String streamName) {
        this.checkStreamServiceExists();
        Objects.requireNonNull(streamName, "streamName can not be null");
        return this.streamServices.stream().flatMap(streamService -> streamService.getDistinctURLRepositoriesByStream(streamName).stream()).distinct().collect(Collectors.toList());
    }

    public List<Stream> getStreamsBy(Repository repository, Codebase codebase) {
        this.checkStreamServiceExists();
        Objects.requireNonNull(repository, "repository cannot be null");
        Objects.requireNonNull(codebase, "codebase cannot be null");
        return this.streamServices.stream().flatMap(streamService -> streamService.getStreamsBy(repository, codebase).stream()).collect(Collectors.toList());
    }

    public StreamComponent getComponentBy(Repository repository, Codebase codebase) throws NotFoundException {
        this.checkStreamServiceExists();
        Objects.requireNonNull(repository, "repository cannot be null");
        Objects.requireNonNull(codebase, "codebase cannot be null");
        for (StreamService streamService : this.streamServices) {
            StreamComponent streamComponent = streamService.getComponentBy(repository, codebase);
            if (streamComponent == null) continue;
            return streamComponent;
        }
        throw new NotFoundException("No StreamComponent is associated with '" + repository + "' and '" + codebase + "'");
    }

    private void checkIssueTrackerExists() {
        if (this.issueTrackers.isEmpty()) {
            throw new IllegalStateException("Unable to retrieve issues as a valid " + IssueTrackerService.class.getName() + " has not been created.");
        }
    }

    private void checkRepositoryServiceExists() {
        if (this.repositories.isEmpty()) {
            throw new IllegalStateException("Unable to find any repository data as a valid " + RepositoryService.class.getName() + " has not been created.");
        }
    }

    private void checkStreamServiceExists() {
        if (this.streamServices.isEmpty()) {
            throw new IllegalStateException("Unable to retrieve streamas a valid " + StreamService.class.getName() + " has not been created.");
        }
    }
}

