/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.issue.trackers.bugzilla;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.set.aphrodite.common.Utils;
import org.jboss.set.aphrodite.config.IssueTrackerConfig;
import org.jboss.set.aphrodite.config.TrackerType;
import org.jboss.set.aphrodite.domain.Comment;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.domain.SearchCriteria;
import org.jboss.set.aphrodite.issue.trackers.bugzilla.BugzillaClient;
import org.jboss.set.aphrodite.issue.trackers.common.AbstractIssueTracker;
import org.jboss.set.aphrodite.spi.AphroditeException;
import org.jboss.set.aphrodite.spi.NotFoundException;

public class BugzillaIssueTracker
extends AbstractIssueTracker {
    private static final Log LOG = LogFactory.getLog(BugzillaIssueTracker.class);
    private BugzillaClient bzClient;

    public BugzillaIssueTracker() {
        super(TrackerType.BUGZILLA);
    }

    @Override
    public boolean init(IssueTrackerConfig config) {
        boolean parentInitiated = super.init(config);
        if (!parentInitiated) {
            return false;
        }
        try {
            this.bzClient = new BugzillaClient(this.baseUrl, config.getUsername(), config.getPassword(), this.executorService);
        }
        catch (IllegalStateException e) {
            Utils.logException(LOG, e);
            return false;
        }
        return true;
    }

    @Override
    public Issue getIssue(URL url) throws NotFoundException {
        this.checkHost(url);
        return this.bzClient.getIssueWithComments(url);
    }

    @Override
    public List<Issue> getIssues(Collection<URL> urls) {
        if ((urls = this.filterUrlsByHost(urls)).isEmpty()) {
            return new ArrayList<Issue>();
        }
        return this.bzClient.getIssues(urls);
    }

    @Override
    public List<Issue> searchIssues(SearchCriteria searchCriteria) {
        return this.bzClient.searchIssues(searchCriteria, this.config.getDefaultIssueLimit());
    }

    @Override
    public List<Issue> searchIssuesByFilter(URL filterUrl) throws NotFoundException {
        this.checkHost(filterUrl);
        return this.bzClient.searchIssuesByFilter(filterUrl);
    }

    @Override
    public boolean updateIssue(Issue issue) throws NotFoundException, AphroditeException {
        this.checkHost(issue.getURL());
        return this.bzClient.updateIssue(issue);
    }

    @Override
    public void addCommentToIssue(Issue issue, Comment comment) throws NotFoundException {
        super.addCommentToIssue(issue, comment);
        this.bzClient.postComment(issue, comment);
    }

    @Override
    public boolean addCommentToIssue(Map<Issue, Comment> commentMap) {
        return (commentMap = this.filterIssuesByHost(commentMap)).isEmpty() || this.bzClient.postComment(commentMap);
    }

    @Override
    public boolean addCommentToIssue(Collection<Issue> issues, Comment comment) {
        return (issues = this.filterIssuesByHost(issues)).isEmpty() || this.bzClient.postComment(issues, comment);
    }

    public BugzillaClient getBzClient() {
        return this.bzClient;
    }

    @Override
    protected Log getLog() {
        return LOG;
    }
}

