/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.issue.trackers.bugzilla;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.set.aphrodite.common.Utils;
import org.jboss.set.aphrodite.domain.Flag;
import org.jboss.set.aphrodite.domain.FlagStatus;
import org.jboss.set.aphrodite.domain.IssueStatus;
import org.jboss.set.aphrodite.domain.SearchCriteria;
import org.jboss.set.aphrodite.domain.Stream;
import org.jboss.set.aphrodite.issue.trackers.bugzilla.BugzillaFields;

class BugzillaQueryBuilder {
    private static final Log LOG = LogFactory.getLog(BugzillaQueryBuilder.class);
    private final SearchCriteria criteria;
    private final Map<String, Object> loginDetails;
    private final int defaultIssueLimit;
    private Map<String, Object> queryMap;

    BugzillaQueryBuilder(SearchCriteria criteria, Map<String, Object> loginDetails, int defaultIssueLimit) {
        this.criteria = criteria;
        this.loginDetails = loginDetails;
        this.defaultIssueLimit = defaultIssueLimit;
    }

    Map<String, Object> getQueryMap() {
        if (this.queryMap != null) {
            return this.queryMap;
        }
        this.queryMap = new HashMap<String, Object>();
        this.criteria.getAssignee().ifPresent(assignee -> this.queryMap.put("assigned_to", assignee));
        this.criteria.getReporter().ifPresent(reporter -> this.queryMap.put("creator", reporter));
        this.criteria.getLastUpdated().ifPresent(date -> this.queryMap.put("last_change_time", date.atStartOfDay().toString()));
        this.criteria.getProduct().ifPresent(product -> this.queryMap.put("product", product));
        this.criteria.getComponent().ifPresent(component -> this.queryMap.put("component", component));
        this.criteria.getRelease().ifPresent(release -> {
            release.getMilestone().ifPresent(milestone -> this.queryMap.put("target_milestone", milestone));
            release.getVersion().ifPresent(version -> this.queryMap.put("version", version));
        });
        this.addStreamsAndStageToQueryMap();
        this.addIssueStatusToMap();
        if (this.queryMap.isEmpty()) {
            this.queryMap = null;
            return null;
        }
        this.queryMap.putAll(this.loginDetails);
        this.queryMap.put("include_fields", BugzillaFields.RESULT_FIELDS);
        this.queryMap.put("permissive", true);
        int limit = this.criteria.getMaxResults().orElse(this.defaultIssueLimit);
        if (limit > 0) {
            this.queryMap.put("limit", limit);
        }
        return this.queryMap;
    }

    private void addStreamsAndStageToQueryMap() {
        Map streams = this.criteria.getStreams().orElse(Collections.emptyMap());
        if (streams.isEmpty()) {
            return;
        }
        this.queryMap.put("j_top", "AND");
        int index = 1;
        for (Map.Entry entry : streams.entrySet()) {
            if (entry.getValue() == FlagStatus.NO_SET) continue;
            this.addFlagSearchToMap(index, ((Stream)entry.getKey()).getName() + ((FlagStatus)((Object)entry.getValue())).getSymbol());
            ++index;
        }
        if (!this.criteria.getStage().isPresent()) {
            return;
        }
        Map<Flag, FlagStatus> stageMap = this.criteria.getStage().get().getStateMap();
        if (stageMap.isEmpty()) {
            return;
        }
        for (Map.Entry<Flag, FlagStatus> entry : stageMap.entrySet()) {
            Optional<String> flag;
            if (entry.getValue() == FlagStatus.NO_SET || !(flag = BugzillaFields.getBugzillaFlag(entry.getKey())).isPresent()) continue;
            this.addFlagSearchToMap(index, flag.get() + entry.getValue().getSymbol());
            ++index;
        }
    }

    private void addFlagSearchToMap(int index, String value) {
        this.queryMap.put("f" + index, "flagtypes.name");
        this.queryMap.put("o" + index, "equals");
        this.queryMap.put("v" + index, value);
    }

    private void addIssueStatusToMap() {
        if (this.criteria.getStatus().isPresent()) {
            IssueStatus issueStatus = this.criteria.getStatus().get();
            if (issueStatus != IssueStatus.CREATED) {
                this.queryMap.put("status", issueStatus.toString());
            } else {
                Utils.logWarnMessage(LOG, "Bugzilla issues do not support the IssueStatus CREATED, so this field is ignored when searching for issues");
            }
        }
    }
}

