/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.spi;

import java.net.URL;
import java.util.List;
import org.jboss.set.aphrodite.config.AphroditeConfig;
import org.jboss.set.aphrodite.config.RepositoryConfig;
import org.jboss.set.aphrodite.domain.CommitStatus;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.domain.Label;
import org.jboss.set.aphrodite.domain.Patch;
import org.jboss.set.aphrodite.domain.PatchState;
import org.jboss.set.aphrodite.domain.Repository;
import org.jboss.set.aphrodite.spi.AphroditeException;
import org.jboss.set.aphrodite.spi.NotFoundException;

public interface RepositoryService {
    public boolean init(AphroditeConfig var1);

    public boolean init(RepositoryConfig var1);

    public boolean urlExists(URL var1);

    public boolean repositoryAccessable(URL var1);

    public Repository getRepository(URL var1) throws NotFoundException;

    public Patch getPatch(URL var1) throws NotFoundException;

    public List<Patch> getPatchesAssociatedWith(Issue var1) throws NotFoundException;

    public List<Patch> getPatchesByState(Repository var1, PatchState var2) throws NotFoundException;

    public List<Label> getLabelsFromRepository(Repository var1) throws NotFoundException;

    public List<Label> getLabelsFromPatch(Patch var1) throws NotFoundException;

    public boolean hasModifiableLabels(Repository var1) throws NotFoundException;

    public void setLabelsToPatch(Patch var1, List<Label> var2) throws NotFoundException, AphroditeException;

    public void removeLabelFromPatch(Patch var1, String var2) throws NotFoundException;

    public void addCommentToPatch(Patch var1, String var2) throws NotFoundException;

    public void addLabelToPatch(Patch var1, String var2) throws NotFoundException;

    public List<Patch> findPatchesRelatedTo(Patch var1);

    public CommitStatus getCommitStatusFromPatch(Patch var1) throws NotFoundException;

    default public void destroy() {
    }
}

