/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.assistant.evaluator.impl.payload;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.jboss.set.aphrodite.Aphrodite;
import org.jboss.set.aphrodite.config.TrackerType;
import org.jboss.set.aphrodite.domain.Codebase;
import org.jboss.set.aphrodite.domain.Comment;
import org.jboss.set.aphrodite.domain.CommitStatus;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.domain.Patch;
import org.jboss.set.aphrodite.domain.Repository;
import org.jboss.set.aphrodite.domain.Stream;
import org.jboss.set.aphrodite.issue.trackers.jira.JiraIssue;
import org.jboss.set.aphrodite.spi.NotFoundException;
import org.jboss.set.assistant.Constants;
import org.jboss.set.assistant.data.payload.AssociatedPullRequest;
import org.jboss.set.assistant.evaluator.PayloadEvaluator;
import org.jboss.set.assistant.evaluator.PayloadEvaluatorContext;

public class AssociatedPullRequestEvaluator
implements PayloadEvaluator {
    private static final Logger logger = Logger.getLogger(AssociatedPullRequestEvaluator.class.getCanonicalName());
    public static final String KEY = "associatedPullRequest";
    public static final String KEY_UNRELATED = "associatedUnrelatedPullRequest";

    @Override
    public String name() {
        return "Associate PullRequest Evaluator";
    }

    @Override
    public void eval(PayloadEvaluatorContext context, Map<String, Object> data) {
        Optional<CommitStatus> commitStatus;
        boolean isNoUpstreamRequired;
        Issue dependencyIssue = context.getIssue();
        Aphrodite aphrodite = context.getAphrodite();
        TrackerType trackerType = context.getTrackerType();
        Stream stream = context.getStream();
        ArrayList relatedPullRequests = new ArrayList();
        ArrayList unrelatedPullRequests = new ArrayList();
        if (trackerType.equals((Object)TrackerType.BUGZILLA)) {
            List<Comment> comments = dependencyIssue.getComments();
            comments.stream().forEach(e -> this.extractPullRequest(aphrodite, stream, relatedPullRequests, unrelatedPullRequests, e.getBody()));
        } else if (dependencyIssue instanceof JiraIssue) {
            ((JiraIssue)dependencyIssue).getPullRequests().stream().forEach(e -> this.extractPullRequest(aphrodite, stream, relatedPullRequests, unrelatedPullRequests, e.toString()));
        } else {
            logger.log(Level.SEVERE, "Error! Type of " + dependencyIssue.getURL() + "  is not JiraIssue");
        }
        ArrayList<AssociatedPullRequest> relatedDataList = new ArrayList<AssociatedPullRequest>();
        ArrayList<AssociatedPullRequest> unrelatedDataList = new ArrayList<AssociatedPullRequest>();
        for (Patch p : relatedPullRequests) {
            isNoUpstreamRequired = false;
            isNoUpstreamRequired = this.isNoUpstreamRequired(p);
            commitStatus = Optional.of(CommitStatus.UNKNOWN);
            try {
                commitStatus = Optional.of(aphrodite.getCommitStatusFromPatch(p));
            }
            catch (NotFoundException e2) {
                logger.log(Level.FINE, "Unable to find build result for pull request : " + p.getURL(), e2);
            }
            relatedDataList.add(new AssociatedPullRequest(p.getId(), p.getURL(), p.getCodebase().getName(), p.getState().toString(), commitStatus.orElse(CommitStatus.UNKNOWN).toString(), isNoUpstreamRequired));
        }
        data.put(KEY, relatedDataList);
        for (Patch p : unrelatedPullRequests) {
            isNoUpstreamRequired = false;
            isNoUpstreamRequired = this.isNoUpstreamRequired(p);
            commitStatus = Optional.of(CommitStatus.UNKNOWN);
            try {
                commitStatus = Optional.of(aphrodite.getCommitStatusFromPatch(p));
            }
            catch (NotFoundException e3) {
                logger.log(Level.FINE, "Unable to find build result for pull request : " + p.getURL(), e3);
            }
            unrelatedDataList.add(new AssociatedPullRequest(p.getId(), p.getURL(), p.getCodebase().getName(), p.getState().toString(), commitStatus.orElse(CommitStatus.UNKNOWN).toString(), isNoUpstreamRequired));
        }
        data.put(KEY_UNRELATED, unrelatedDataList);
    }

    private void extractPullRequest(Aphrodite aphrodite, Stream stream, List<Patch> relatedPullRequestsURL, List<Patch> unrelatedPullRequestsURL, String url) {
        Matcher matcher = Constants.RELATED_PR_PATTERN.matcher(url);
        while (matcher.find()) {
            if (matcher.groupCount() != 3) continue;
            try {
                URL relatedPullRequestURL = new URL("https://github.com/" + matcher.group(1) + "/" + matcher.group(2) + "/pull/" + matcher.group(3));
                try {
                    Patch patch = aphrodite.getPatch(relatedPullRequestURL);
                    if (this.checkSameStream(patch, stream)) {
                        relatedPullRequestsURL.add(patch);
                        continue;
                    }
                    unrelatedPullRequestsURL.add(patch);
                }
                catch (NotFoundException e) {
                    logger.log(Level.WARNING, "Unable to find related Pull Request for issue: " + relatedPullRequestURL, e);
                }
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid URL:" + url, e);
            }
        }
    }

    private boolean checkSameStream(Patch patch, Stream stream) {
        Codebase codebase = patch.getCodebase();
        Repository repository = patch.getRepository();
        return stream.getAllComponents().stream().anyMatch(e -> e.getCodebase().equals(codebase) && e.getRepository().equals(repository));
    }

    private boolean isNoUpstreamRequired(Patch p) {
        Optional<String> pullRequestBoday = Optional.ofNullable(p.getBody());
        Matcher matcher = Constants.UPSTREAM_NOT_REQUIRED.matcher(pullRequestBoday.orElse("N/A"));
        return matcher.find();
    }
}

