/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.assistant.evaluator.impl.pullrequest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.set.aphrodite.Aphrodite;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.domain.Patch;
import org.jboss.set.aphrodite.domain.Stream;
import org.jboss.set.assistant.data.IssueData;
import org.jboss.set.assistant.evaluator.Evaluator;
import org.jboss.set.assistant.evaluator.EvaluatorContext;
import org.jboss.set.assistant.evaluator.Util;

public class IssuesRelatedEvaluator
implements Evaluator {
    @Override
    public String name() {
        return "Issues Related evaluator";
    }

    @Override
    public void eval(EvaluatorContext context, Map<String, Object> data) {
        List<Issue> issues = context.getIssues();
        HashMap<String, List<String>> issueStream = new HashMap<String, List<String>>();
        for (Issue issue : issues) {
            List<String> streams = Util.getStreams(issue);
            issueStream.put(issue.getTrackerId().get(), streams);
        }
        Stream currentStream = context.getStream();
        Aphrodite aphrodite = context.getAphrodite();
        Patch patch = context.getPatch();
        List streams = aphrodite.getStreamsBy(patch.getRepository(), patch.getCodebase()).stream().map(e -> e.getName()).collect(Collectors.toList());
        if (currentStream.getName().contains("eap-6")) {
            data.put("issuesRelated", issues.stream().filter(e -> {
                ArrayList intersect = new ArrayList(streams);
                intersect.retainAll((Collection)issueStream.get(e.getTrackerId().get()));
                return !intersect.isEmpty();
            }).map(e -> new IssueData(e.getTrackerId().get(), (List)issueStream.get(e.getTrackerId().get()), e.getURL(), e.getStatus(), e.getType(), e.getStage().getStateMap().entrySet().stream().collect(Collectors.toMap(e1 -> String.valueOf(e1.getKey()), e1 -> String.valueOf(e1.getValue()))))).collect(Collectors.toList()));
            data.put("issuesOtherStreams", issues.stream().filter(e -> {
                ArrayList intersect = new ArrayList(streams);
                intersect.retainAll((Collection)issueStream.get(e.getTrackerId().get()));
                return intersect.isEmpty();
            }).map(e -> new IssueData(e.getTrackerId().get(), (List)issueStream.get(e.getTrackerId().get()), e.getURL(), e.getStatus(), e.getType(), e.getStage().getStateMap().entrySet().stream().collect(Collectors.toMap(e1 -> String.valueOf(e1.getKey()), e1 -> String.valueOf(e1.getValue()))))).collect(Collectors.toList()));
        } else if (currentStream.getName().contains("eap-7")) {
            data.put("issuesRelated", issues.stream().filter(e -> e.getStreamStatus().keySet().stream().filter(e1 -> e1.equals("7.0.z.GA")).findAny().isPresent()).map(e -> new IssueData(e.getTrackerId().get(), (List)issueStream.get(e.getTrackerId().get()), e.getURL(), e.getStatus(), e.getType(), e.getStage().getStateMap().entrySet().stream().collect(Collectors.toMap(e1 -> String.valueOf(e1.getKey()), e1 -> String.valueOf(e1.getValue()))))).collect(Collectors.toList()));
            data.put("issuesOtherStreams", issues.stream().filter(e -> e.getStreamStatus().keySet().stream().filter(e1 -> !e1.equals("7.0.z.GA")).findAny().isPresent()).map(e -> new IssueData(e.getTrackerId().get(), (List)issueStream.get(e.getTrackerId().get()), e.getURL(), e.getStatus(), e.getType(), e.getStage().getStateMap().entrySet().stream().collect(Collectors.toMap(e1 -> String.valueOf(e1.getKey()), e1 -> String.valueOf(e1.getValue()))))).collect(Collectors.toList()));
        } else {
            data.put("issuesRelated", issues.stream().map(e -> new IssueData(e.getTrackerId().get(), (List)issueStream.get(e.getTrackerId().get()), e.getURL(), e.getStatus(), e.getType(), e.getStage().getStateMap().entrySet().stream().collect(Collectors.toMap(e1 -> String.valueOf(e1.getKey()), e1 -> String.valueOf(e1.getValue()))))).collect(Collectors.toList()));
            data.put("issuesOtherStreams", Collections.emptyList());
        }
    }
}

