/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.io;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.commonjava.maven.ext.io.resolver.GalleyInfrastructure;

@Named
@Singleton
public class FileIO {
    private GalleyInfrastructure infra;

    @Inject
    public FileIO(@Named(value="galley") GalleyInfrastructure infra) {
        this.infra = infra;
    }

    public File resolveURL(URL ref) throws IOException {
        File cache = this.infra.getCacheDir();
        File result = new File(cache, UUID.randomUUID().toString());
        FileUtils.copyURLToFile(ref, result);
        return result;
    }
}

