/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.io.rest;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.ObjectMapper;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.lang.StringUtils;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.common.util.ListUtils;
import org.commonjava.maven.ext.io.rest.Translator;
import org.commonjava.maven.ext.io.rest.exception.RestException;
import org.commonjava.maven.ext.io.rest.mapper.ListingBlacklistMapper;
import org.commonjava.maven.ext.io.rest.mapper.ReportGAVMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class DefaultTranslator
implements Translator {
    private static final String REPORTS_LOOKUP_GAVS = "reports/lookup/gavs";
    private static final String LISTING_BLACKLIST_GA = "listings/blacklist/ga";
    private static final Random RANDOM = new Random();
    private static final Base32 CODEC = new Base32();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String endpointUrl;
    private final ReportGAVMapper rgm;
    private final int initialRestMaxSize;
    private final int initialRestMinSize;
    private final ListingBlacklistMapper lbm;
    private int retryDuration = 30;

    public DefaultTranslator(String endpointUrl, Translator.RestProtocol protocol, int restMaxSize, int restMinSize, String repositoryGroup, String incrementalSerialSuffix) {
        this.rgm = new ReportGAVMapper(protocol, repositoryGroup, incrementalSerialSuffix);
        this.lbm = new ListingBlacklistMapper(protocol);
        this.endpointUrl = endpointUrl + (StringUtils.isNotBlank(endpointUrl) ? (endpointUrl.endsWith("/") ? "" : "/") : "");
        this.initialRestMaxSize = restMaxSize;
        this.initialRestMinSize = restMinSize;
    }

    private void init(ObjectMapper objectMapper) {
        Unirest.setTimeouts(30000L, 600000L);
        Unirest.setObjectMapper(objectMapper);
    }

    public void partition(List<ProjectVersionRef> projects, Queue<Task> queue) {
        if (this.initialRestMaxSize != 0) {
            if (this.initialRestMaxSize == -1) {
                this.autoPartition(projects, queue);
            } else {
                this.userDefinedPartition(projects, queue);
            }
        } else {
            this.noOpPartition(projects, queue);
        }
    }

    private void noOpPartition(List<ProjectVersionRef> projects, Queue<Task> queue) {
        this.logger.info("Using NO-OP partition strategy");
        queue.add(new Task(this.rgm, projects, this.endpointUrl + REPORTS_LOOKUP_GAVS));
    }

    private void userDefinedPartition(List<ProjectVersionRef> projects, Queue<Task> queue) {
        this.logger.info("Using user defined partition strategy");
        List<List<ProjectVersionRef>> partition = ListUtils.partition(projects, this.initialRestMaxSize);
        for (List<ProjectVersionRef> p : partition) {
            queue.add(new Task(this.rgm, p, this.endpointUrl + REPORTS_LOOKUP_GAVS));
        }
        this.logger.debug("For initial sizing of {} have split the queue into {} ", (Object)this.initialRestMaxSize, (Object)queue.size());
    }

    private void autoPartition(List<ProjectVersionRef> projects, Queue<Task> queue) {
        List<List<ProjectVersionRef>> partition;
        if (projects.size() < 600) {
            this.logger.info("Using auto partition strategy: {} projects divided in chunks with {} each", (Object)projects.size(), (Object)128);
            partition = ListUtils.partition(projects, 128);
        } else if (projects.size() > 600 && projects.size() < 1200) {
            this.logger.info("Using auto partition strategy: {} projects divided in chunks with {} each", (Object)projects.size(), (Object)64);
            partition = ListUtils.partition(projects, 64);
        } else {
            this.logger.info("Using auto partition strategy: {} projects divided in chunks with {} each", (Object)projects.size(), (Object)32);
            partition = ListUtils.partition(projects, 32);
        }
        for (List<ProjectVersionRef> p : partition) {
            queue.add(new Task(this.rgm, p, this.endpointUrl + REPORTS_LOOKUP_GAVS));
        }
    }

    @Override
    public List<ProjectVersionRef> findBlacklisted(ProjectRef ga) {
        List result;
        this.init(this.lbm);
        String blacklistEndpointUrl = this.endpointUrl + LISTING_BLACKLIST_GA;
        this.logger.trace("Called findBlacklisted to {} with {}", (Object)blacklistEndpointUrl, (Object)ga);
        try {
            HttpResponse<List> r = Unirest.get(blacklistEndpointUrl).header("accept", "application/json").header("Content-Type", "application/json").header("Log-Context", this.getHeaderContext()).queryString("groupid", ga.getGroupId()).queryString("artifactid", ga.getArtifactId()).asObject(List.class);
            int status = r.getStatus();
            if (status != 200) {
                throw new RestException(String.format("Failed to establish blacklist calling %s with error %s", this.endpointUrl, this.lbm.getErrorString()));
            }
            result = r.getBody();
        }
        catch (UnirestException e) {
            throw new RestException("Unable to contact DA", e);
        }
        return result;
    }

    @Override
    public Map<ProjectVersionRef, String> translateVersions(List<ProjectVersionRef> projects) {
        this.init(this.rgm);
        HashMap<ProjectVersionRef, String> result = new HashMap<ProjectVersionRef, String>();
        ArrayDeque<Task> queue = new ArrayDeque<Task>();
        this.partition(projects, queue);
        while (!queue.isEmpty()) {
            Task task = (Task)queue.remove();
            task.executeTranslate();
            if (task.isSuccess()) {
                result.putAll(task.getResult());
                continue;
            }
            if (task.canSplit() && this.isRecoverable(task.getStatus())) {
                if (task.getStatus() == 503) {
                    this.logger.info("The DA server is unavailable. Waiting {} before splitting the tasks and retrying", (Object)this.retryDuration);
                    this.waitBeforeRetry(this.retryDuration);
                }
                List<Task> tasks = task.split();
                this.logger.warn("Failed to translate versions for task @{} due to {}, splitting and retrying. Chunk size was: {} and new chunk size {} in {} segments.", task.hashCode(), task.getStatus(), task.getChunkSize(), tasks.get(0).getChunkSize(), tasks.size());
                queue.addAll(tasks);
                continue;
            }
            if (task.getStatus() < 0) {
                this.logger.debug("Caught exception calling server with message {}", (Object)task.getErrorMessage());
            } else {
                this.logger.debug("Did not get status {} but received {}", (Object)200, (Object)task.getStatus());
            }
            if (task.getStatus() > 0) {
                throw new RestException("Received response status " + task.getStatus() + " with message: " + task.getErrorMessage());
            }
            throw new RestException("Received response status " + task.getStatus() + " with message " + task.getErrorMessage());
        }
        return result;
    }

    private boolean isRecoverable(int httpErrorCode) {
        return httpErrorCode == 504 || httpErrorCode == 503;
    }

    private void waitBeforeRetry(int seconds) {
        try {
            Thread.sleep(TimeUnit.SECONDS.toMillis(seconds));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected String getHeaderContext() {
        String headerContext;
        if (StringUtils.isNotEmpty(MDC.get("LOG-CONTEXT"))) {
            headerContext = MDC.get("LOG-CONTEXT");
        } else {
            byte[] randomBytes = new byte[20];
            RANDOM.nextBytes(randomBytes);
            headerContext = "pme-" + CODEC.encodeAsString(randomBytes);
        }
        return headerContext;
    }

    public int getRetryDuration() {
        return this.retryDuration;
    }

    public void setRetryDuration(int retryDuration) {
        this.retryDuration = retryDuration;
    }

    private class Task {
        private List<ProjectVersionRef> chunk;
        private Map<ProjectVersionRef, String> result = null;
        private int status = -1;
        private Exception exception;
        private String errorString;
        private String endpointUrl;
        private ReportGAVMapper pvrm;

        Task(ReportGAVMapper pvrm, List<ProjectVersionRef> chunk, String endpointUrl) {
            this.pvrm = pvrm;
            this.chunk = chunk;
            this.endpointUrl = endpointUrl;
        }

        void executeTranslate() {
            try {
                HttpResponse<Map> r = Unirest.post(this.endpointUrl).header("accept", "application/json").header("Content-Type", "application/json").header("Log-Context", DefaultTranslator.this.getHeaderContext()).body(this.chunk).asObject(Map.class);
                this.status = r.getStatus();
                if (this.status == 200) {
                    this.result = r.getBody();
                } else {
                    this.errorString = this.pvrm.getErrorString();
                }
            }
            catch (UnirestException e) {
                this.exception = e;
                this.status = -1;
            }
        }

        public List<Task> split() {
            ArrayList<Task> res = new ArrayList<Task>(4);
            if (this.chunk.size() >= 4) {
                int chunkSize = this.chunk.size() / 4;
                for (int i = 0; i < 3; ++i) {
                    res.add(new Task(this.pvrm, this.chunk.subList(i * chunkSize, (i + 1) * chunkSize), this.endpointUrl));
                }
                res.add(new Task(this.pvrm, this.chunk.subList(3 * chunkSize, this.chunk.size()), this.endpointUrl));
            } else {
                for (int i = 0; i < this.chunk.size() - DefaultTranslator.this.initialRestMinSize + 1; ++i) {
                    res.add(new Task(this.pvrm, this.chunk.subList(i * DefaultTranslator.this.initialRestMinSize, (i + 1) * DefaultTranslator.this.initialRestMinSize), this.endpointUrl));
                }
            }
            return res;
        }

        boolean canSplit() {
            return this.chunk.size() / DefaultTranslator.this.initialRestMinSize > 0 && this.chunk.size() != 1;
        }

        int getStatus() {
            return this.status;
        }

        boolean isSuccess() {
            return this.status == 200;
        }

        public Map<ProjectVersionRef, String> getResult() {
            return this.result;
        }

        public String getErrorMessage() {
            return (this.exception != null ? this.exception.getMessage() + ' ' : "") + (this.errorString != null ? this.errorString : "");
        }

        int getChunkSize() {
            return this.chunk.size();
        }
    }
}

