/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.util.jhttpc.INTERNAL.util;

import java.io.IOException;
import java.io.StringReader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.bc.BcPEMDecryptorProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEInputDecryptorProviderBuilder;
import org.commonjava.util.jhttpc.INTERNAL.util.SSLUtils;
import org.commonjava.util.jhttpc.JHttpCException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BouncyCastleUtils {
    private static final String KEY_TYPE_PATTERN = "BEGIN (.+) PRIVATE KEY";

    public static KeyStore readKeyAndCertFromPem(String pemContent, String keyPass) throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException, JHttpCException {
        Logger logger = LoggerFactory.getLogger(BouncyCastleUtils.class);
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null);
        int certIdx = 0;
        BouncyCastleProvider bcProvider = new BouncyCastleProvider();
        InputDecryptorProvider provider = new JcePKCSPBEInputDecryptorProviderBuilder().setProvider(bcProvider).build(keyPass.toCharArray());
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        PrivateKey key = null;
        PEMParser pemParser = new PEMParser(new StringReader(pemContent));
        Object pemObj = null;
        while ((pemObj = pemParser.readObject()) != null) {
            logger.trace("Got PEM object: {}", pemObj);
            if (pemObj instanceof X509CertificateHolder) {
                X509CertificateHolder holder = (X509CertificateHolder)pemObj;
                X509Certificate certificate = new JcaX509CertificateConverter().setProvider(bcProvider).getCertificate(holder);
                certs.add(certificate);
                HashSet<String> aliases = new HashSet<String>();
                aliases.add("certificate" + certIdx);
                SSLUtils.extractAliases(certificate, aliases);
                KeyStore.TrustedCertificateEntry ksEntry = new KeyStore.TrustedCertificateEntry(certificate);
                for (String alias : aliases) {
                    ks.setEntry(alias, ksEntry, null);
                    logger.trace("Storing trusted cert under alias: {}\n  with DN: {}", (Object)alias, (Object)certificate.getSubjectDN().getName());
                }
                ++certIdx;
            } else if (pemObj instanceof PKCS8EncryptedPrivateKeyInfo) {
                PKCS8EncryptedPrivateKeyInfo keyInfo = (PKCS8EncryptedPrivateKeyInfo)pemObj;
                PrivateKeyInfo privateKeyInfo = null;
                try {
                    privateKeyInfo = keyInfo.decryptPrivateKeyInfo(provider);
                }
                catch (PKCSException e) {
                    throw new JHttpCException("Failed to decrypt key/certificate: %s", (Throwable)e, e.getMessage());
                }
                key = new JcaPEMKeyConverter().getPrivateKey(privateKeyInfo);
            } else if (pemObj instanceof PEMEncryptedKeyPair) {
                PEMEncryptedKeyPair keyPair = (PEMEncryptedKeyPair)pemObj;
                PEMKeyPair decryptedKeyPair = keyPair.decryptKeyPair(new BcPEMDecryptorProvider(keyPass.toCharArray()));
                PrivateKeyInfo privateKeyInfo = decryptedKeyPair.getPrivateKeyInfo();
                key = new JcaPEMKeyConverter().getPrivateKey(privateKeyInfo);
            } else {
                logger.trace("Got unrecognized PEM object: {} (class: {})", pemObj, (Object)(pemObj == null ? "NULL" : pemObj.getClass().getName()));
            }
            logger.trace("Got private key:\n{}\n", (Object)key);
        }
        if (key != null && !certs.isEmpty()) {
            logger.trace("Setting key entry: {}", (Object)key);
            ks.setKeyEntry("key", key, keyPass.toCharArray(), certs.toArray(new Certificate[certs.size()]));
        } else {
            logger.warn("No private key found in PEM!");
        }
        return ks;
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }
}

