/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.util.jhttpc.INTERNAL.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.commonjava.util.jhttpc.INTERNAL.util.BouncyCastleUtils;
import org.commonjava.util.jhttpc.JHttpCException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SSLUtils {
    private static final String[] BC_TEST_NAMES = new String[]{"org.bouncycastle.jce.provider.BouncyCastleProvider", "org.bouncycastle.openssl.PEMParser"};
    private static final Integer DNSNAME_TYPE = 2;

    private SSLUtils() {
    }

    public static KeyStore readKeyAndCert(String pemContent, String keyPass) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, InvalidKeySpecException, JHttpCException {
        Logger logger = LoggerFactory.getLogger(SSLUtils.class);
        boolean bcEnabled = true;
        for (String bctestName : BC_TEST_NAMES) {
            try {
                Class.forName(bctestName);
            }
            catch (ClassNotFoundException e) {
                logger.warn("One or more BouncyCastle jars (bcprov-jdk15on, bcpkix-jdk15on) are missing from the classpath! PEM SSL client keys are not supported!");
                bcEnabled = false;
                break;
            }
        }
        if (!bcEnabled) {
            return null;
        }
        KeyStore ks = BouncyCastleUtils.readKeyAndCertFromPem(pemContent, keyPass);
        Enumeration<String> aliases = ks.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            logger.trace("Got alias: {}. Is Cert? {} Is Private key? {}", alias, ks.isCertificateEntry(alias), ks.isKeyEntry(alias));
        }
        return ks;
    }

    public static KeyStore decodePEMTrustStore(String pemContent, String aliasPrefix) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Logger logger = LoggerFactory.getLogger(SSLUtils.class);
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null);
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        List<String> lines = SSLUtils.readLines(pemContent);
        StringBuilder current = new StringBuilder();
        ArrayList<String> entries = new ArrayList<String>();
        for (String line : lines) {
            if (line == null) continue;
            if (line.startsWith("-----BEGIN")) {
                current.setLength(0);
                continue;
            }
            if (line.startsWith("-----END")) {
                entries.add(current.toString());
                continue;
            }
            current.append(line);
        }
        logger.trace("Found {} entries to decode.", (Object)entries.size());
        int i = 0;
        for (String entry : entries) {
            logger.trace("Decoding certificate info from:\n\n{}\n\n", (Object)entry);
            byte[] data = Base64.decodeBase64(entry);
            Certificate c = certFactory.generateCertificate(new ByteArrayInputStream(data));
            X509Certificate cert = (X509Certificate)c;
            HashSet<String> aliases = new HashSet<String>();
            if (i < 1) {
                aliases.add(aliasPrefix);
            } else {
                aliases.add(aliasPrefix + i);
            }
            SSLUtils.extractAliases(cert, aliases);
            KeyStore.TrustedCertificateEntry ksEntry = new KeyStore.TrustedCertificateEntry(cert);
            for (String alias : aliases) {
                ks.setEntry(alias, ksEntry, null);
                logger.trace("Storing trusted cert under alias: {}\n  with DN: {}", (Object)alias, (Object)cert.getSubjectDN().getName());
            }
            logger.trace("Certificate added.");
            ++i;
        }
        return ks;
    }

    public static void extractAliases(Certificate certificate, Set<String> aliases) throws CertificateParsingException {
        Collection<List<?>> subjectAlternativeNames;
        RDN cn;
        AttributeTypeAndValue typeAndValue;
        Logger logger = LoggerFactory.getLogger(SSLUtils.class);
        X509Certificate cert = (X509Certificate)certificate;
        X500Principal x500Principal = cert.getSubjectX500Principal();
        X500Name x500Name = new X500Name(x500Principal.getName("RFC1779"));
        logger.trace("Certificate X.500 name: '{}'", (Object)x500Name.toString());
        RDN[] matchingRDNs = x500Name.getRDNs(BCStyle.CN);
        if (matchingRDNs != null && matchingRDNs.length > 0 && (typeAndValue = (cn = matchingRDNs[0]).getFirst()) != null) {
            String alias = IETFUtils.valueToString(typeAndValue.getValue());
            logger.trace("Found certificate alias: '{}'", (Object)alias);
            aliases.add(alias);
        }
        if ((subjectAlternativeNames = cert.getSubjectAlternativeNames()) != null) {
            for (List<?> names : subjectAlternativeNames) {
                if (names.size() <= 1 || !DNSNAME_TYPE.equals(names.get(0))) continue;
                String alias = (String)names.get(1);
                logger.trace("Found subjectAlternativeName: '{}'", (Object)alias);
                aliases.add(alias);
            }
        } else {
            logger.debug("NO SubjectAlternativeNames available!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(String content) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(content.getBytes(Charset.forName("UTF-8")))));
            String line = null;
            while ((line = reader.readLine()) != null) {
                lines.add(line.trim());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly(reader);
        return lines;
    }
}

