/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.util.jhttpc.auth;

import org.commonjava.util.jhttpc.auth.PasswordKey;
import org.commonjava.util.jhttpc.auth.PasswordManager;
import org.commonjava.util.jhttpc.auth.PasswordType;
import org.commonjava.util.jhttpc.model.SiteConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributePasswordManager
implements PasswordManager {
    public static final String PASSWORD_PREFIX = "password_";
    private SiteConfigLookup lookupManager;

    public AttributePasswordManager(SiteConfigLookup lookupManager) {
        this.lookupManager = lookupManager;
    }

    @Override
    public String lookup(PasswordKey id) {
        SiteConfig config = this.lookupManager.lookup(id.getSiteId());
        if (config == null) {
            return null;
        }
        return config.getAttribute(PASSWORD_PREFIX + id.getPasswordType().name(), String.class);
    }

    @Override
    public void bind(String password, SiteConfig loc, PasswordType type) {
        if (password == null) {
            return;
        }
        this.set(loc, type, password);
    }

    @Override
    public void bind(String password, String siteId, PasswordType type) {
        if (password == null) {
            return;
        }
        SiteConfig config = this.getConfig(siteId);
        if (config != null) {
            this.set(config, type, password);
        }
    }

    @Override
    public void bind(String password, PasswordKey pwid) {
        if (password == null) {
            return;
        }
        SiteConfig config = this.getConfig(pwid.getSiteId());
        if (config != null) {
            this.set(config, pwid.getPasswordType(), password);
        }
    }

    @Override
    public void unbind(SiteConfig config, PasswordType type) {
        this.clear(config, type);
    }

    @Override
    public void unbind(String siteId, PasswordType type) {
        SiteConfig config = this.getConfig(siteId);
        if (config != null) {
            this.clear(config, type);
        }
    }

    @Override
    public void unbind(PasswordKey id) {
        SiteConfig config = this.getConfig(id.getSiteId());
        if (config != null) {
            this.clear(config, id.getPasswordType());
        }
    }

    private SiteConfig getConfig(String siteId) {
        SiteConfig config = this.lookupManager.lookup(siteId);
        if (config == null) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.warn("Site config not found for: {}", (Object)siteId);
        }
        return config;
    }

    private void set(SiteConfig loc, PasswordType type, String password) {
        loc.setAttribute(PASSWORD_PREFIX + type.name(), password);
    }

    private void clear(SiteConfig loc, PasswordType type) {
        loc.removeAttribute(PASSWORD_PREFIX + type.name());
    }

    public static interface SiteConfigLookup {
        public SiteConfig lookup(String var1);
    }
}

