/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.mavendependencyupdater.core.processingstrategies;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.jboss.logging.Logger;
import org.jboss.set.mavendependencyupdater.DependencyEvaluator;
import org.jboss.set.mavendependencyupdater.LocatedDependency;
import org.jboss.set.mavendependencyupdater.PomDependencyUpdater;
import org.jboss.set.mavendependencyupdater.configuration.Configuration;
import org.jboss.set.mavendependencyupdater.core.processingstrategies.UpgradeProcessingStrategy;

public class TextReportProcessingStrategy
implements UpgradeProcessingStrategy {
    private static final Logger LOG = Logger.getLogger(TextReportProcessingStrategy.class);
    private static final String PROJECT_URL = "https://github.com/jboss-set/maven-dependency-updater";
    private File pomFile;
    private Configuration configuration;
    private Set<ModifiedProperty> recordedUpdates = new HashSet<ModifiedProperty>();
    private PrintStream outputStream;
    private File outputFile;

    TextReportProcessingStrategy(Configuration configuration, File pomFile) {
        this.configuration = configuration;
        this.pomFile = pomFile;
    }

    public TextReportProcessingStrategy(Configuration configuration, File pomFile, String outputFileName) {
        this(configuration, pomFile);
        this.outputFile = new File(outputFileName);
    }

    public TextReportProcessingStrategy(Configuration configuration, File pomFile, PrintStream outputStream) {
        this(configuration, pomFile);
        this.outputStream = outputStream;
    }

    private void initOutputStream() {
        try {
            if (this.outputStream == null) {
                this.outputStream = this.outputFile == null ? System.out : new PrintStream(this.outputFile);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Can't create output stream", e);
        }
    }

    @Override
    public boolean process(List<DependencyEvaluator.ComponentUpgrade> upgrades) {
        try {
            if (upgrades.size() == 0) {
                LOG.info("No components to upgrade.");
                boolean bl = true;
                return bl;
            }
            this.initOutputStream();
            List sortedUpgrades = upgrades.stream().sorted(Comparator.comparing(DependencyEvaluator.ComponentUpgrade::getArtifact)).collect(Collectors.toList());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss z yyyy-MM-dd");
            this.outputStream.println("Generated at " + formatter.format(ZonedDateTime.now()));
            this.outputStream.println();
            this.outputStream.println("Searched in following repositories:\n");
            for (Map.Entry<String, String> entry : this.configuration.getRepositories().entrySet()) {
                this.outputStream.println("* " + entry.getKey() + ": " + entry.getValue());
            }
            this.outputStream.println();
            this.outputStream.println("Possible upgrades:\n");
            int counter = 0;
            URI uri = this.pomFile.toURI();
            for (DependencyEvaluator.ComponentUpgrade upgrade : sortedUpgrades) {
                LocatedDependency locatedDependency;
                boolean added;
                Optional<LocatedDependency> locatedDependencyOpt = PomDependencyUpdater.locateDependency(this.pomFile, upgrade.getArtifact());
                ArtifactRef artifact = upgrade.getArtifact();
                String newVersion = upgrade.getNewVersion();
                String repoId = upgrade.getRepository();
                if (!locatedDependencyOpt.isPresent() || !(added = this.recordedUpdates.add(new ModifiedProperty(uri, (locatedDependency = locatedDependencyOpt.get()).getProfile(), locatedDependency.getVersionProperty(), newVersion)))) continue;
                ++counter;
                this.outputStream.println(String.format("%s:%s:%s -> %s (%s)", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersionString(), newVersion, repoId));
            }
            this.outputStream.println("\n" + counter + " items");
            this.outputStream.println("\nReport generated by Maven Dependency Updater");
            this.outputStream.println(PROJECT_URL);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new RuntimeException("Report generation failed", e);
        }
        finally {
            if (this.outputStream != null && this.outputStream != System.out) {
                this.outputStream.close();
            }
        }
    }

    private static class ModifiedProperty {
        private URI pomUri;
        private String profile;
        private String propertyName;
        private String newValue;

        ModifiedProperty(URI pomUri, String profile, String propertyName, String newValue) {
            this.pomUri = pomUri;
            this.profile = profile;
            this.propertyName = propertyName;
            this.newValue = newValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModifiedProperty that = (ModifiedProperty)o;
            return new EqualsBuilder().append(this.pomUri, that.pomUri).append(this.profile, that.profile).append(this.propertyName, that.propertyName).append(this.newValue, that.newValue).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append(this.pomUri).append(this.profile).append(this.propertyName).append(this.newValue).toHashCode();
        }
    }
}

