/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.common.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Profile;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.ManipulationUncheckedException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.session.MavenSessionHandler;
import org.commonjava.maven.ext.common.util.ProfileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectComparator {
    private static final String REPORT_NON_ALIGNED = "reportNonAligned";
    private static final Logger logger = LoggerFactory.getLogger(ProjectComparator.class);

    public static void compareProjects(MavenSessionHandler session, List<Project> originalProjects, List<Project> newProjects) throws ManipulationException {
        boolean reportNonAligned = Boolean.parseBoolean(session.getUserProperties().getProperty(REPORT_NON_ALIGNED, "false"));
        try {
            newProjects.forEach(newProject -> originalProjects.stream().filter(originalProject -> newProject.getArtifactId().equals(originalProject.getArtifactId()) && newProject.getGroupId().equals(originalProject.getGroupId())).forEach(originalProject -> {
                logger.info("------------------- project {} ", (Object)newProject.getKey().asProjectRef());
                if (!originalProject.getVersion().equals(newProject.getVersion())) {
                    logger.info("\tProject version : {} ---> {}\n", (Object)originalProject.getVersion(), (Object)newProject.getVersion());
                }
                newProject.getModel().getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(nKey, nValue) -> originalProject.getModel().getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(oKey, oValue) -> {
                    if (oKey != null && oKey.equals(nKey) && oValue != null && !oValue.equals(nValue)) {
                        logger.info("\tProperty : key {} ; value {} ---> {}", oKey, oValue, nValue);
                    }
                }))));
                logger.info("");
                ProjectComparator.compareDependencies(Type.DEPENDENCIES, reportNonAligned, ProjectComparator.handleDependencies(session, originalProject, null, Type.DEPENDENCIES), ProjectComparator.handleDependencies(session, newProject, null, Type.DEPENDENCIES));
                ProjectComparator.compareDependencies(Type.MANAGED_DEPENDENCIES, reportNonAligned, ProjectComparator.handleDependencies(session, originalProject, null, Type.MANAGED_DEPENDENCIES), ProjectComparator.handleDependencies(session, newProject, null, Type.MANAGED_DEPENDENCIES));
                logger.info("");
                ProjectComparator.comparePlugins(Type.PLUGINS, reportNonAligned, ProjectComparator.handlePlugins(session, originalProject, null, Type.PLUGINS), ProjectComparator.handlePlugins(session, newProject, null, Type.PLUGINS));
                ProjectComparator.comparePlugins(Type.MANAGED_PLUGINS, reportNonAligned, ProjectComparator.handlePlugins(session, originalProject, null, Type.MANAGED_PLUGINS), ProjectComparator.handlePlugins(session, newProject, null, Type.MANAGED_PLUGINS));
                logger.info("");
                List<Profile> oldProfiles = ProfileUtils.getProfiles(session, originalProject.getModel());
                List<Profile> newProfiles = ProfileUtils.getProfiles(session, newProject.getModel());
                newProfiles.forEach(newProfile -> oldProfiles.stream().filter(oldProfile -> newProfile.getId().equals(oldProfile.getId())).forEach(oldProfile -> {
                    newProfile.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(nKey, nValue) -> oldProfile.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(oKey, oValue) -> {
                        if (oKey != null && oKey.equals(nKey) && oValue != null && !oValue.equals(nValue)) {
                            logger.info("\tProfile property : key {} ; value {} ---> {}\n", oKey, oValue, nValue);
                        }
                    }))));
                    logger.info("");
                    ProjectComparator.compareDependencies(Type.PROFILE_DEPENDENCIES, reportNonAligned, ProjectComparator.handleDependencies(session, originalProject, oldProfile, Type.PROFILE_DEPENDENCIES), ProjectComparator.handleDependencies(session, newProject, newProfile, Type.PROFILE_DEPENDENCIES));
                    ProjectComparator.compareDependencies(Type.PROFILE_MANAGED_DEPENDENCIES, reportNonAligned, ProjectComparator.handleDependencies(session, originalProject, oldProfile, Type.PROFILE_MANAGED_DEPENDENCIES), ProjectComparator.handleDependencies(session, newProject, newProfile, Type.PROFILE_MANAGED_DEPENDENCIES));
                    logger.info("");
                    ProjectComparator.comparePlugins(Type.PROFILE_PLUGINS, reportNonAligned, ProjectComparator.handlePlugins(session, originalProject, oldProfile, Type.PROFILE_PLUGINS), ProjectComparator.handlePlugins(session, newProject, newProfile, Type.PROFILE_PLUGINS));
                    ProjectComparator.comparePlugins(Type.PROFILE_MANAGED_PLUGINS, reportNonAligned, ProjectComparator.handlePlugins(session, originalProject, oldProfile, Type.PROFILE_MANAGED_PLUGINS), ProjectComparator.handlePlugins(session, newProject, newProfile, Type.PROFILE_MANAGED_PLUGINS));
                }));
            }));
        }
        catch (ManipulationUncheckedException e) {
            throw (ManipulationException)e.getCause();
        }
    }

    private static void compareDependencies(Type type, boolean reportNonAligned, Set<ArtifactRef> originalDeps, Set<ArtifactRef> newDeps) {
        HashSet nonAligned = new HashSet();
        originalDeps.forEach(originalArtifact -> newDeps.stream().filter(newArtifact -> newArtifact.getGroupId().equals(originalArtifact.getGroupId()) && newArtifact.getArtifactId().equals(originalArtifact.getArtifactId()) && newArtifact.getType().equals(originalArtifact.getType()) && StringUtils.equals(newArtifact.getClassifier(), originalArtifact.getClassifier())).forEach(newArtifact -> {
            if (!newArtifact.getVersionString().equals(originalArtifact.getVersionString())) {
                logger.info("\t{} : {} --> {} ", new Object[]{type, originalArtifact, newArtifact});
            } else if (reportNonAligned) {
                nonAligned.add(originalArtifact);
            }
        }));
        if (nonAligned.size() > 0) {
            logger.info("");
            nonAligned.forEach(na -> logger.info("\tNon-Aligned {} : {} ", (Object)type, na));
        }
    }

    private static void comparePlugins(Type type, boolean reportNonAligned, Set<ProjectVersionRef> originalPlugins, Set<ProjectVersionRef> newPlugins) {
        HashSet nonAligned = new HashSet();
        originalPlugins.forEach(originalPVR -> newPlugins.stream().filter(newPVR -> newPVR.getGroupId().equals(originalPVR.getGroupId()) && newPVR.getArtifactId().equals(originalPVR.getArtifactId())).forEach(newArtifact -> {
            if (!newArtifact.getVersionString().equals(originalPVR.getVersionString())) {
                logger.info("\t{} : {} --> {} ", new Object[]{type, originalPVR, newArtifact});
            } else if (reportNonAligned) {
                nonAligned.add(originalPVR);
            }
        }));
        if (nonAligned.size() > 0) {
            logger.info("");
            nonAligned.forEach(pv -> logger.info("\tNon-Aligned {} : {} ", (Object)type, pv));
        }
    }

    private static Set<ArtifactRef> handleDependencies(MavenSessionHandler session, Project project, Profile profile, Type type) throws ManipulationUncheckedException {
        try {
            switch (type) {
                case DEPENDENCIES: {
                    return project.getResolvedDependencies(session).keySet();
                }
                case MANAGED_DEPENDENCIES: {
                    return project.getResolvedManagedDependencies(session).keySet();
                }
                case PROFILE_DEPENDENCIES: {
                    return project.getResolvedProfileDependencies(session).getOrDefault(profile, Collections.emptyMap()).keySet();
                }
                case PROFILE_MANAGED_DEPENDENCIES: {
                    return project.getResolvedProfileManagedDependencies(session).getOrDefault(profile, Collections.emptyMap()).keySet();
                }
            }
            throw new ManipulationException("Invalid type " + type.toString(), new String[0]);
        }
        catch (ManipulationException e) {
            throw new ManipulationUncheckedException(e);
        }
    }

    private static Set<ProjectVersionRef> handlePlugins(MavenSessionHandler session, Project project, Profile profile, Type type) throws ManipulationUncheckedException {
        try {
            switch (type) {
                case PLUGINS: {
                    return project.getResolvedPlugins(session).keySet();
                }
                case MANAGED_PLUGINS: {
                    return project.getResolvedManagedPlugins(session).keySet();
                }
                case PROFILE_PLUGINS: {
                    return project.getResolvedProfilePlugins(session).getOrDefault(profile, Collections.emptyMap()).keySet();
                }
                case PROFILE_MANAGED_PLUGINS: {
                    return project.getResolvedProfileManagedPlugins(session).getOrDefault(profile, Collections.emptyMap()).keySet();
                }
            }
            throw new ManipulationException("Invalid type " + type.toString(), new String[0]);
        }
        catch (ManipulationException e) {
            throw new ManipulationUncheckedException(e);
        }
    }

    static enum Type {
        DEPENDENCIES,
        MANAGED_DEPENDENCIES,
        PROFILE_DEPENDENCIES,
        PROFILE_MANAGED_DEPENDENCIES,
        PLUGINS,
        MANAGED_PLUGINS,
        PROFILE_PLUGINS,
        PROFILE_MANAGED_PLUGINS;


        public String toString() {
            switch (this) {
                case DEPENDENCIES: {
                    return "Dependencies";
                }
                case MANAGED_DEPENDENCIES: {
                    return "Managed dependencies";
                }
                case PROFILE_DEPENDENCIES: {
                    return "Profile dependencies";
                }
                case PROFILE_MANAGED_DEPENDENCIES: {
                    return "Profile managed dependencies";
                }
                case PLUGINS: {
                    return "Plugins";
                }
                case MANAGED_PLUGINS: {
                    return "Managed plugins";
                }
                case PROFILE_PLUGINS: {
                    return "Profile plugins";
                }
                case PROFILE_MANAGED_PLUGINS: {
                    return "Profile managed plugins";
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

