/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.groovy;

import groovy.lang.Script;
import java.io.File;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Dependency;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.ManipulationUncheckedException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.session.MavenSessionHandler;
import org.commonjava.maven.ext.common.util.PropertyResolver;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.groovy.InvocationStage;
import org.commonjava.maven.ext.io.ModelIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseScript
extends Script {
    private final Logger logger = LoggerFactory.getLogger(BaseScript.class);
    private List<Project> projects;
    private Project project;
    private ProjectVersionRef gav;
    private File basedir;
    private Properties userProperties;
    private ModelIO modelIO;
    private MavenSessionHandler sessionHandler;
    private InvocationStage stage;

    public Project getProject() {
        return this.project;
    }

    public List<Project> getProjects() {
        return this.projects;
    }

    public ProjectVersionRef getGAV() {
        return this.gav;
    }

    public File getBaseDir() {
        return this.basedir;
    }

    public Properties getUserProperties() {
        return this.userProperties;
    }

    public ModelIO getModelIO() {
        return this.modelIO;
    }

    public MavenSessionHandler getSession() {
        return this.sessionHandler;
    }

    public InvocationStage getInvocationStage() {
        return this.stage;
    }

    public void setValues(ModelIO modelIO, ManipulationSession session, List<Project> projects, Project project, InvocationStage stage) {
        this.modelIO = modelIO;
        this.sessionHandler = session;
        this.projects = projects;
        this.project = project;
        this.gav = project.getKey();
        this.basedir = project.getPom().getParentFile();
        this.userProperties = session.getUserProperties();
        this.stage = stage;
        this.logger.info("Injecting values. Project is " + project + " with basedir " + this.basedir + " and properties " + this.userProperties);
    }

    public void inlineProperty(Project currentProject, String groupArtifact) throws ManipulationException {
        ProjectRef target = SimpleProjectRef.parse(groupArtifact);
        try {
            currentProject.getResolvedManagedDependencies(this.sessionHandler).entrySet().stream().filter(a -> ((ArtifactRef)a.getKey()).asProjectRef().equals(target) && ((Dependency)a.getValue()).getVersion().contains("$")).forEach(a -> {
                this.logger.info("Found managed artifact {} (original dependency {})", a.getKey(), a.getValue());
                ((Dependency)a.getValue()).setVersion(PropertyResolver.resolvePropertiesUnchecked(this.sessionHandler, currentProject.getInheritedList(), ((Dependency)a.getValue()).getVersion()));
            });
            currentProject.getResolvedDependencies(this.sessionHandler).entrySet().stream().filter(a -> ((ArtifactRef)a.getKey()).asProjectRef().equals(target) && ((Dependency)a.getValue()).getVersion().contains("$")).forEach(a -> {
                this.logger.info("Found artifact {} (original dependency {})", a.getKey(), a.getValue());
                ((Dependency)a.getValue()).setVersion(PropertyResolver.resolvePropertiesUnchecked(this.sessionHandler, currentProject.getInheritedList(), ((Dependency)a.getValue()).getVersion()));
            });
        }
        catch (ManipulationUncheckedException e) {
            throw (ManipulationException)e.getCause();
        }
    }
}

