/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.model;

import java.util.HashMap;
import java.util.Map;
import org.commonjava.maven.galley.model.Location;

public class SimpleLocation
implements Location {
    private final boolean allowPublishing;
    private final boolean allowDownloading;
    private final boolean allowStoring;
    private final boolean allowSnapshots;
    private final boolean allowReleases;
    private final boolean allowDeletion;
    private final String uri;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final String name;

    public SimpleLocation(String name, String uri, boolean allowSnapshots, boolean allowReleases, boolean allowsStoring, boolean allowPublishing, boolean allowDownloading, boolean allowDeletion) {
        this.name = name;
        this.uri = uri;
        this.allowSnapshots = allowSnapshots;
        this.allowReleases = allowReleases;
        this.allowStoring = allowsStoring;
        this.allowPublishing = allowPublishing;
        this.allowDownloading = allowDownloading;
        this.allowDeletion = allowDeletion;
    }

    public SimpleLocation(String name, String uri, boolean allowSnapshots, boolean allowReleases, boolean allowsStoring, boolean allowPublishing, boolean allowDownloading) {
        this.name = name;
        this.uri = uri;
        this.allowSnapshots = allowSnapshots;
        this.allowReleases = allowReleases;
        this.allowStoring = allowsStoring;
        this.allowPublishing = allowPublishing;
        this.allowDownloading = allowDownloading;
        this.allowDeletion = true;
    }

    public SimpleLocation(String name, String uri) {
        this.uri = uri;
        this.name = name;
        this.allowReleases = true;
        this.allowSnapshots = false;
        this.allowStoring = true;
        this.allowDownloading = true;
        this.allowPublishing = false;
        this.allowDeletion = true;
    }

    public SimpleLocation(String uri) {
        this.uri = uri;
        this.name = uri;
        this.allowReleases = true;
        this.allowSnapshots = false;
        this.allowStoring = true;
        this.allowDownloading = true;
        this.allowPublishing = false;
        this.allowDeletion = true;
    }

    @Override
    public boolean allowsStoring() {
        return this.allowStoring;
    }

    @Override
    public boolean allowsDownloading() {
        return this.allowDownloading;
    }

    @Override
    public boolean allowsPublishing() {
        return this.allowPublishing;
    }

    @Override
    public boolean allowsSnapshots() {
        return this.allowSnapshots;
    }

    @Override
    public boolean allowsReleases() {
        return this.allowReleases;
    }

    @Override
    public boolean allowsDeletion() {
        return this.allowDeletion;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleLocation other = (SimpleLocation)obj;
        if (this.uri == null) {
            return other.uri == null;
        }
        return this.uri.equals(other.uri);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public <T> T getAttribute(String key, Class<T> type) {
        return this.getAttribute(key, type, null);
    }

    @Override
    public <T> T getAttribute(String key, Class<T> type, T defaultValue) {
        Object value = this.attributes.get(key);
        if (value != null) {
            return type.cast(value);
        }
        return defaultValue;
    }

    @Override
    public Object removeAttribute(String key) {
        return this.attributes.remove(key);
    }

    @Override
    public Object setAttribute(String key, Object value) {
        return this.attributes.put(key, value);
    }

    public String toString() {
        return String.format("SimpleLocation [uri=%s]", this.uri);
    }
}

