/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Providers;
import org.eclipse.microprofile.config.Config;
import org.jboss.resteasy.core.AcceptHeaderByFileSuffixFilter;
import org.jboss.resteasy.core.AcceptParameterHttpPreprocessor;
import org.jboss.resteasy.core.AsynchronousDispatcher;
import org.jboss.resteasy.core.InternalDispatcher;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.ThreadLocalResteasyProviderFactory;
import org.jboss.resteasy.core.providerfactory.ResteasyProviderFactoryImpl;
import org.jboss.resteasy.microprofile.config.ResteasyConfigProvider;
import org.jboss.resteasy.plugins.interceptors.RoleBasedSecurityFeature;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.plugins.providers.ServerFormUrlEncodedProvider;
import org.jboss.resteasy.plugins.server.resourcefactory.JndiComponentResourceFactory;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.Dispatcher;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyConfiguration;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.metadata.ResourceBuilder;
import org.jboss.resteasy.util.GetRestful;

public class ResteasyDeploymentImpl
implements ResteasyDeployment {
    protected boolean widerRequestMatching;
    protected boolean useContainerFormParams = false;
    protected boolean deploymentSensitiveFactoryEnabled = false;
    protected boolean asyncJobServiceEnabled = false;
    protected boolean addCharset = true;
    protected int asyncJobServiceMaxJobResults = 100;
    protected long asyncJobServiceMaxWait = 300000L;
    protected int asyncJobServiceThreadPoolSize = 100;
    protected String asyncJobServiceBasePath = "/asynch/jobs";
    protected String applicationClass;
    protected String injectorFactoryClass;
    protected InjectorFactory injectorFactory;
    protected Application application;
    protected boolean registerBuiltin = true;
    protected List<String> scannedResourceClasses;
    protected List<String> scannedProviderClasses;
    protected List<String> scannedJndiComponentResources;
    protected Map<String, List<String>> scannedResourceClassesWithBuilder;
    protected List<String> jndiComponentResources;
    protected List<String> providerClasses;
    protected List<Class> actualProviderClasses;
    protected List<Object> providers;
    protected boolean securityEnabled = false;
    protected List<String> jndiResources;
    protected List<String> resourceClasses;
    protected List<String> unwrappedExceptions;
    protected List<Class> actualResourceClasses;
    protected List<ResourceFactory> resourceFactories;
    protected List<Object> resources;
    protected Map<String, String> mediaTypeMappings;
    protected Map<String, String> languageExtensions;
    protected Map<Class, Object> defaultContextObjects;
    protected Map<String, String> constructedDefaultContextObjects;
    protected Registry registry;
    protected Dispatcher dispatcher;
    protected ResteasyProviderFactory providerFactory;
    protected ThreadLocalResteasyProviderFactory threadLocalProviderFactory;
    protected String paramMapping;
    protected Map<String, Object> properties;
    protected boolean statisticsEnabled;

    public ResteasyDeploymentImpl() {
        this.scannedResourceClasses = new ArrayList<String>();
        this.scannedProviderClasses = new ArrayList<String>();
        this.scannedJndiComponentResources = new ArrayList<String>();
        this.scannedResourceClassesWithBuilder = new HashMap<String, List<String>>();
        this.jndiComponentResources = new ArrayList<String>();
        this.providerClasses = new ArrayList<String>();
        this.actualProviderClasses = new ArrayList<Class>();
        this.providers = new ArrayList<Object>();
        this.jndiResources = new ArrayList<String>();
        this.resourceClasses = new ArrayList<String>();
        this.unwrappedExceptions = new ArrayList<String>();
        this.actualResourceClasses = new ArrayList<Class>();
        this.resourceFactories = new ArrayList<ResourceFactory>();
        this.resources = new ArrayList<Object>();
        this.mediaTypeMappings = new HashMap<String, String>();
        this.languageExtensions = new HashMap<String, String>();
        this.defaultContextObjects = new HashMap<Class, Object>();
        this.constructedDefaultContextObjects = new HashMap<String, String>();
        this.properties = new TreeMap<String, Object>();
    }

    public ResteasyDeploymentImpl(boolean quarkus) {
    }

    @Override
    public void start() {
        try {
            this.startInternal();
        }
        finally {
            ThreadLocalResteasyProviderFactory.pop();
        }
    }

    private void startInternal() {
        this.initializeFactory();
        this.initializeDispatcher();
        this.pushContext();
        try {
            this.initializeObjects();
            if (this.securityEnabled) {
                this.providerFactory.register(RoleBasedSecurityFeature.class);
            }
            if (this.registerBuiltin) {
                this.providerFactory.setRegisterBuiltins(true);
                RegisterBuiltin.register(this.providerFactory);
                this.providerFactory.registerProviderInstance(new ServerFormUrlEncodedProvider(this.useContainerFormParams), null, null, true);
            } else {
                this.providerFactory.setRegisterBuiltins(false);
            }
            this.registration();
            this.registerMappers();
            ((ResteasyProviderFactoryImpl)this.providerFactory).lockSnapshots();
        }
        finally {
            ResteasyContext.removeContextDataLevel();
        }
    }

    protected void registerMappers() {
        if (this.paramMapping != null) {
            this.providerFactory.getContainerRequestFilterRegistry().registerSingleton(new AcceptParameterHttpPreprocessor(this.paramMapping));
        }
        AcceptHeaderByFileSuffixFilter suffixNegotiationFilter = null;
        if (this.mediaTypeMappings != null) {
            HashMap<String, MediaType> extMap = new HashMap<String, MediaType>();
            for (Map.Entry<String, String> ext : this.mediaTypeMappings.entrySet()) {
                String value = ext.getValue();
                extMap.put(ext.getKey().trim(), MediaType.valueOf(value.trim()));
            }
            if (suffixNegotiationFilter == null) {
                suffixNegotiationFilter = new AcceptHeaderByFileSuffixFilter();
                this.providerFactory.getContainerRequestFilterRegistry().registerSingleton(suffixNegotiationFilter);
            }
            suffixNegotiationFilter.setMediaTypeMappings(extMap);
        }
        if (this.languageExtensions != null) {
            if (suffixNegotiationFilter == null) {
                suffixNegotiationFilter = new AcceptHeaderByFileSuffixFilter();
                this.providerFactory.getContainerRequestFilterRegistry().registerSingleton(suffixNegotiationFilter);
            }
            suffixNegotiationFilter.setLanguageMappings(this.languageExtensions);
        }
    }

    protected void pushContext() {
        Map<Class<?>, Object> contextDataMap = ResteasyContext.getContextDataMap();
        contextDataMap.putAll(this.dispatcher.getDefaultContextObjects());
    }

    protected void initializeObjects() {
        if (this.injectorFactory == null && this.injectorFactoryClass != null) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.injectorFactoryClass);
                this.injectorFactory = (InjectorFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException(Messages.MESSAGES.unableToFindInjectorFactory(), cnfe);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateInjectorFactory(), e);
            }
        }
        if (this.injectorFactory != null) {
            this.providerFactory.setInjectorFactory(this.injectorFactory);
        }
        if (this.constructedDefaultContextObjects != null && this.constructedDefaultContextObjects.size() > 0) {
            for (Map.Entry<String, String> entry : this.constructedDefaultContextObjects.entrySet()) {
                Class<?> key = null;
                try {
                    key = Thread.currentThread().getContextClassLoader().loadClass(entry.getKey());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(Messages.MESSAGES.unableToInstantiateContextObject(entry.getKey()), e);
                }
                Object obj = ResteasyDeploymentImpl.createFromInjectorFactory(entry.getValue(), this.providerFactory);
                LogMessages.LOGGER.creatingContextObject(entry.getKey(), entry.getValue());
                this.defaultContextObjects.put(key, obj);
                this.dispatcher.getDefaultContextObjects().put(key, obj);
                ResteasyContext.getContextDataMap().put(key, obj);
            }
        }
        if (this.applicationClass != null) {
            this.application = ResteasyDeploymentImpl.createApplication(this.applicationClass, this.dispatcher, this.providerFactory);
        }
    }

    protected void initializeDispatcher() {
        if (this.asyncJobServiceEnabled) {
            AsynchronousDispatcher asyncDispatcher;
            if (this.dispatcher == null) {
                asyncDispatcher = new AsynchronousDispatcher(this.providerFactory);
                this.dispatcher = asyncDispatcher;
            } else {
                asyncDispatcher = (AsynchronousDispatcher)this.dispatcher;
            }
            asyncDispatcher.setMaxCacheSize(this.asyncJobServiceMaxJobResults);
            asyncDispatcher.setMaxWaitMilliSeconds(this.asyncJobServiceMaxWait);
            asyncDispatcher.setThreadPoolSize(this.asyncJobServiceThreadPoolSize);
            asyncDispatcher.setBasePath(this.asyncJobServiceBasePath);
            if (this.unwrappedExceptions != null) {
                asyncDispatcher.getUnwrappedExceptions().addAll(this.unwrappedExceptions);
            }
            asyncDispatcher.start();
        } else {
            SynchronousDispatcher dis;
            if (this.dispatcher == null) {
                dis = new SynchronousDispatcher(this.providerFactory);
                this.dispatcher = dis;
            } else {
                dis = (SynchronousDispatcher)this.dispatcher;
            }
            if (this.unwrappedExceptions != null) {
                dis.getUnwrappedExceptions().addAll(this.unwrappedExceptions);
            }
        }
        this.registry = this.dispatcher.getRegistry();
        if (this.widerRequestMatching) {
            ((ResourceMethodRegistry)this.registry).setWiderMatching(this.widerRequestMatching);
        }
        if (this.defaultContextObjects != null) {
            this.dispatcher.getDefaultContextObjects().putAll(this.defaultContextObjects);
        }
        this.dispatcher.getDefaultContextObjects().put(Configurable.class, this.providerFactory);
        this.dispatcher.getDefaultContextObjects().put(Configuration.class, this.providerFactory);
        this.dispatcher.getDefaultContextObjects().put(Providers.class, this.providerFactory);
        this.dispatcher.getDefaultContextObjects().put(Registry.class, this.registry);
        this.dispatcher.getDefaultContextObjects().put(Dispatcher.class, this.dispatcher);
        this.dispatcher.getDefaultContextObjects().put(InternalDispatcher.class, InternalDispatcher.getInstance());
        this.dispatcher.getDefaultContextObjects().put(ResteasyDeployment.class, this);
    }

    protected void initializeFactory() {
        Object context;
        if (this.providerFactory == null) {
            this.providerFactory = new ResteasyProviderFactoryImpl();
        }
        this.providerFactory.setRegisterBuiltins(this.registerBuiltin);
        this.providerFactory.getStatisticsController().setEnabled(this.statisticsEnabled);
        Config config = ResteasyConfigProvider.getConfig();
        String tracingText = config.getOptionalValue("resteasy.server.tracing.type", String.class).orElse(null);
        String thresholdText = config.getOptionalValue("resteasy.server.tracing.threshold", String.class).orElse(null);
        Object object = context = this.getDefaultContextObjects() == null ? null : this.getDefaultContextObjects().get(ResteasyConfiguration.class);
        if (tracingText != null) {
            this.providerFactory.property("resteasy.server.tracing.type", tracingText);
        } else if (context != null && (tracingText = ((ResteasyConfiguration)context).getParameter("resteasy.server.tracing.type")) != null) {
            this.providerFactory.property("resteasy.server.tracing.type", tracingText);
        }
        if (thresholdText != null) {
            this.providerFactory.getMutableProperties().put("resteasy.server.tracing.threshold", thresholdText);
        } else if (context != null && (thresholdText = ((ResteasyConfiguration)context).getInitParameter("resteasy.server.tracing.threshold")) != null) {
            this.providerFactory.getMutableProperties().put("resteasy.server.tracing.threshold", thresholdText);
        }
        if (this.deploymentSensitiveFactoryEnabled) {
            if (!(this.providerFactory instanceof ThreadLocalResteasyProviderFactory)) {
                if (ResteasyProviderFactory.peekInstance() == null || !(ResteasyProviderFactory.peekInstance() instanceof ThreadLocalResteasyProviderFactory)) {
                    this.threadLocalProviderFactory = new ThreadLocalResteasyProviderFactory(this.providerFactory);
                    ResteasyProviderFactory.setInstance(this.threadLocalProviderFactory);
                } else {
                    ThreadLocalResteasyProviderFactory.push(this.providerFactory);
                }
            } else {
                ThreadLocalResteasyProviderFactory.push(this.providerFactory);
            }
        } else {
            ResteasyProviderFactory.setInstance(this.providerFactory);
        }
    }

    @Override
    public void merge(ResteasyDeployment other) {
        this.scannedResourceClasses.addAll(other.getScannedResourceClasses());
        this.scannedProviderClasses.addAll(other.getScannedProviderClasses());
        this.scannedJndiComponentResources.addAll(other.getScannedJndiComponentResources());
        this.scannedResourceClassesWithBuilder.putAll(other.getScannedResourceClassesWithBuilder());
        this.jndiComponentResources.addAll(other.getJndiComponentResources());
        this.providerClasses.addAll(other.getProviderClasses());
        this.actualProviderClasses.addAll(other.getActualProviderClasses());
        this.providers.addAll(other.getProviders());
        this.jndiResources.addAll(other.getJndiResources());
        this.resourceClasses.addAll(other.getResourceClasses());
        this.unwrappedExceptions.addAll(other.getUnwrappedExceptions());
        this.actualResourceClasses.addAll(other.getActualResourceClasses());
        this.resourceFactories.addAll(other.getResourceFactories());
        this.resources.addAll(other.getResources());
        this.mediaTypeMappings.putAll(other.getMediaTypeMappings());
        this.languageExtensions.putAll(other.getLanguageExtensions());
        this.defaultContextObjects.putAll(other.getDefaultContextObjects());
        this.constructedDefaultContextObjects.putAll(other.getConstructedDefaultContextObjects());
    }

    public static Application createApplication(String applicationClass, Dispatcher dispatcher, ResteasyProviderFactory providerFactory) {
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(applicationClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Application app = (Application)providerFactory.createProviderInstance(clazz);
        dispatcher.getDefaultContextObjects().put(Application.class, app);
        ResteasyContext.pushContext(Application.class, app);
        PropertyInjector propertyInjector = providerFactory.getInjectorFactory().createPropertyInjector(clazz, providerFactory);
        propertyInjector.inject(app, false);
        return app;
    }

    private static Object createFromInjectorFactory(String classname, ResteasyProviderFactory providerFactory) {
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Object obj = providerFactory.injectedInstance(clazz);
        return obj;
    }

    @Override
    public void registration() {
        boolean useScanning = this.registerApplication();
        if (useScanning && this.scannedProviderClasses != null) {
            for (String string : this.scannedProviderClasses) {
                this.registerProvider(string);
            }
        }
        if (this.providerClasses != null) {
            for (String string : this.providerClasses) {
                this.registerProvider(string);
            }
        }
        if (this.providers != null) {
            for (Object object : this.providers) {
                this.providerFactory.registerProviderInstance(object);
            }
        }
        if (this.actualProviderClasses != null) {
            for (Class clazz : this.actualProviderClasses) {
                this.providerFactory.registerProvider(clazz);
            }
        }
        this.registerResources(useScanning);
    }

    protected void registerResources(boolean useScanning) {
        Class<?> clazz;
        if (useScanning && this.scannedJndiComponentResources != null) {
            for (String string : this.scannedJndiComponentResources) {
                this.registerJndiComponentResource(string);
            }
        }
        if (this.jndiComponentResources != null) {
            for (String string : this.jndiComponentResources) {
                this.registerJndiComponentResource(string);
            }
        }
        if (this.jndiResources != null) {
            for (String string : this.jndiResources) {
                this.registry.addJndiResource(string.trim());
            }
        }
        if (useScanning && this.scannedResourceClasses != null) {
            for (String string : this.scannedResourceClasses) {
                clazz = null;
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(string.trim());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                this.registry.addPerRequestResource(clazz);
            }
        }
        if (useScanning && this.scannedResourceClassesWithBuilder != null) {
            for (Map.Entry entry : this.scannedResourceClassesWithBuilder.entrySet()) {
                ResourceBuilder resourceBuilder;
                Class<?> resourceBuilderClass;
                try {
                    resourceBuilderClass = Thread.currentThread().getContextClassLoader().loadClass(((String)entry.getKey()).trim());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (!ResourceBuilder.class.isAssignableFrom(resourceBuilderClass)) {
                    throw new IllegalArgumentException("Supplied class: " + resourceBuilderClass + "must be a subclass of " + ResourceBuilder.class.getName());
                }
                try {
                    resourceBuilder = (ResourceBuilder)resourceBuilderClass.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                for (String resource : (List)entry.getValue()) {
                    Class<?> resourceClass;
                    try {
                        resourceClass = Thread.currentThread().getContextClassLoader().loadClass(resource.trim());
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                    this.registry.addPerRequestResource(resourceClass, resourceBuilder);
                }
            }
        }
        if (this.resourceClasses != null) {
            for (String string : this.resourceClasses) {
                clazz = null;
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(string.trim());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                this.registry.addPerRequestResource(clazz);
            }
        }
        if (this.resources != null) {
            for (Object object : this.resources) {
                this.registry.addSingletonResource(object);
            }
        }
        if (this.actualResourceClasses != null) {
            for (Class clazz2 : this.actualResourceClasses) {
                this.registry.addPerRequestResource(clazz2);
            }
        }
        if (this.resourceFactories != null) {
            for (ResourceFactory resourceFactory : this.resourceFactories) {
                this.registry.addResourceFactory(resourceFactory);
            }
        }
        this.registry.checkAmbiguousUri();
    }

    protected boolean registerApplication() {
        boolean useScanning = true;
        if (this.application != null) {
            this.dispatcher.getDefaultContextObjects().put(Application.class, this.application);
            ResteasyContext.getContextDataMap().put(Application.class, this.application);
            if (this.processApplication(this.application)) {
                useScanning = false;
            }
        }
        return useScanning;
    }

    private void registerJndiComponentResource(String resource) {
        String[] config = resource.trim().split(";");
        if (config.length < 3) {
            throw new RuntimeException(Messages.MESSAGES.jndiComponentResourceNotSetCorrectly());
        }
        String jndiName = config[0];
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(config[1]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(Messages.MESSAGES.couldNotFindClassJndi(config[1]), e);
        }
        boolean cacheRefrence = Boolean.valueOf(config[2].trim());
        JndiComponentResourceFactory factory = new JndiComponentResourceFactory(jndiName, clazz, cacheRefrence);
        this.getResourceFactories().add(factory);
    }

    @Override
    public void stop() {
        if (this.asyncJobServiceEnabled) {
            ((AsynchronousDispatcher)this.dispatcher).stop();
        }
        ResteasyProviderFactory.clearInstanceIfEqual(this.threadLocalProviderFactory);
        ResteasyProviderFactory.clearInstanceIfEqual(this.providerFactory);
    }

    private boolean processApplication(Application config) {
        Map<String, Object> properties;
        Set<Object> singletons;
        LogMessages.LOGGER.deployingApplication(Application.class.getName(), config.getClass());
        boolean registered = false;
        Set<Class<?>> classes = config.getClasses();
        if (classes != null) {
            for (Class<?> clazz : classes) {
                if (GetRestful.isRootResource(clazz)) {
                    LogMessages.LOGGER.addingClassResource(clazz.getName(), config.getClass());
                    this.actualResourceClasses.add(clazz);
                    registered = true;
                    continue;
                }
                LogMessages.LOGGER.addingProviderClass(clazz.getName(), config.getClass());
                this.actualProviderClasses.add(clazz);
                registered = true;
            }
        }
        if ((singletons = config.getSingletons()) != null) {
            for (Object e : singletons) {
                if (GetRestful.isRootResource(e.getClass())) {
                    if (this.actualResourceClasses.contains(e.getClass())) {
                        LogMessages.LOGGER.singletonClassAlreadyDeployed("resource", e.getClass().getName());
                        continue;
                    }
                    LogMessages.LOGGER.addingSingletonResource(e.getClass().getName(), config.getClass());
                    this.resources.add(e);
                    registered = true;
                    continue;
                }
                if (this.actualProviderClasses.contains(e.getClass())) {
                    LogMessages.LOGGER.singletonClassAlreadyDeployed("provider", e.getClass().getName());
                    continue;
                }
                LogMessages.LOGGER.addingProviderSingleton(e.getClass().getName(), config.getClass());
                this.providers.add(e);
                registered = true;
            }
        }
        if ((properties = config.getProperties()) != null && !properties.isEmpty()) {
            Feature feature = new Feature(){

                @Override
                public boolean configure(FeatureContext featureContext) {
                    for (Map.Entry property : properties.entrySet()) {
                        featureContext = (FeatureContext)featureContext.property((String)property.getKey(), property.getValue());
                    }
                    return true;
                }
            };
            this.providers.add(0, feature);
        }
        return registered;
    }

    private void registerProvider(String clazz) {
        Class<?> provider = null;
        try {
            provider = Thread.currentThread().getContextClassLoader().loadClass(clazz.trim());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.providerFactory.registerProvider(provider);
    }

    @Override
    public boolean isUseContainerFormParams() {
        return this.useContainerFormParams;
    }

    @Override
    public void setUseContainerFormParams(boolean useContainerFormParams) {
        this.useContainerFormParams = useContainerFormParams;
    }

    @Override
    public List<String> getJndiComponentResources() {
        return this.jndiComponentResources;
    }

    @Override
    public void setJndiComponentResources(List<String> jndiComponentResources) {
        this.jndiComponentResources = jndiComponentResources;
    }

    @Override
    public String getApplicationClass() {
        return this.applicationClass;
    }

    @Override
    public void setApplicationClass(String applicationClass) {
        this.applicationClass = applicationClass;
    }

    @Override
    public String getInjectorFactoryClass() {
        return this.injectorFactoryClass;
    }

    @Override
    public void setInjectorFactoryClass(String injectorFactoryClass) {
        this.injectorFactoryClass = injectorFactoryClass;
    }

    @Override
    public boolean isDeploymentSensitiveFactoryEnabled() {
        return this.deploymentSensitiveFactoryEnabled;
    }

    @Override
    public void setDeploymentSensitiveFactoryEnabled(boolean deploymentSensitiveFactoryEnabled) {
        this.deploymentSensitiveFactoryEnabled = deploymentSensitiveFactoryEnabled;
    }

    @Override
    public boolean isAsyncJobServiceEnabled() {
        return this.asyncJobServiceEnabled;
    }

    @Override
    public void setAsyncJobServiceEnabled(boolean asyncJobServiceEnabled) {
        this.asyncJobServiceEnabled = asyncJobServiceEnabled;
    }

    @Override
    public int getAsyncJobServiceMaxJobResults() {
        return this.asyncJobServiceMaxJobResults;
    }

    @Override
    public void setAsyncJobServiceMaxJobResults(int asyncJobServiceMaxJobResults) {
        this.asyncJobServiceMaxJobResults = asyncJobServiceMaxJobResults;
    }

    @Override
    public long getAsyncJobServiceMaxWait() {
        return this.asyncJobServiceMaxWait;
    }

    @Override
    public void setAsyncJobServiceMaxWait(long asyncJobServiceMaxWait) {
        this.asyncJobServiceMaxWait = asyncJobServiceMaxWait;
    }

    @Override
    public int getAsyncJobServiceThreadPoolSize() {
        return this.asyncJobServiceThreadPoolSize;
    }

    @Override
    public void setAsyncJobServiceThreadPoolSize(int asyncJobServiceThreadPoolSize) {
        this.asyncJobServiceThreadPoolSize = asyncJobServiceThreadPoolSize;
    }

    @Override
    public String getAsyncJobServiceBasePath() {
        return this.asyncJobServiceBasePath;
    }

    @Override
    public void setAsyncJobServiceBasePath(String asyncJobServiceBasePath) {
        this.asyncJobServiceBasePath = asyncJobServiceBasePath;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    @Override
    public void setApplication(Application application) {
        this.application = application;
    }

    @Override
    public boolean isRegisterBuiltin() {
        return this.registerBuiltin;
    }

    @Override
    public void setRegisterBuiltin(boolean registerBuiltin) {
        this.registerBuiltin = registerBuiltin;
    }

    @Override
    public List<String> getProviderClasses() {
        return this.providerClasses;
    }

    @Override
    public void setProviderClasses(List<String> providerClasses) {
        this.providerClasses = providerClasses;
    }

    @Override
    public List<Object> getProviders() {
        return this.providers;
    }

    @Override
    public void setProviders(List<Object> providers) {
        this.providers = providers;
    }

    @Override
    public List<Class> getActualProviderClasses() {
        return this.actualProviderClasses;
    }

    @Override
    public void setActualProviderClasses(List<Class> actualProviderClasses) {
        this.actualProviderClasses = actualProviderClasses;
    }

    @Override
    public List<Class> getActualResourceClasses() {
        return this.actualResourceClasses;
    }

    @Override
    public void setActualResourceClasses(List<Class> actualResourceClasses) {
        this.actualResourceClasses = actualResourceClasses;
    }

    @Override
    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    @Override
    public void setSecurityEnabled(boolean securityEnabled) {
        this.securityEnabled = securityEnabled;
    }

    @Override
    public List<String> getJndiResources() {
        return this.jndiResources;
    }

    @Override
    public void setJndiResources(List<String> jndiResources) {
        this.jndiResources = jndiResources;
    }

    @Override
    public List<String> getResourceClasses() {
        return this.resourceClasses;
    }

    @Override
    public void setResourceClasses(List<String> resourceClasses) {
        this.resourceClasses = resourceClasses;
    }

    @Override
    public Map<String, String> getMediaTypeMappings() {
        return this.mediaTypeMappings;
    }

    @Override
    public void setMediaTypeMappings(Map<String, String> mediaTypeMappings) {
        this.mediaTypeMappings = mediaTypeMappings;
    }

    @Override
    public List<Object> getResources() {
        return this.resources;
    }

    @Override
    public void setResources(List<Object> resources) {
        this.resources = resources;
    }

    @Override
    public Map<String, String> getLanguageExtensions() {
        return this.languageExtensions;
    }

    @Override
    public void setLanguageExtensions(Map<String, String> languageExtensions) {
        this.languageExtensions = languageExtensions;
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    @Override
    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    @Override
    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public ResteasyProviderFactory getProviderFactory() {
        return this.providerFactory;
    }

    @Override
    public void setProviderFactory(ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    @Override
    public void setMediaTypeParamMapping(String paramMapping) {
        this.paramMapping = paramMapping;
    }

    @Override
    public List<ResourceFactory> getResourceFactories() {
        return this.resourceFactories;
    }

    @Override
    public void setResourceFactories(List<ResourceFactory> resourceFactories) {
        this.resourceFactories = resourceFactories;
    }

    @Override
    public List<String> getUnwrappedExceptions() {
        return this.unwrappedExceptions;
    }

    @Override
    public void setUnwrappedExceptions(List<String> unwrappedExceptions) {
        this.unwrappedExceptions = unwrappedExceptions;
    }

    @Override
    public Map<String, String> getConstructedDefaultContextObjects() {
        return this.constructedDefaultContextObjects;
    }

    @Override
    public void setConstructedDefaultContextObjects(Map<String, String> constructedDefaultContextObjects) {
        this.constructedDefaultContextObjects = constructedDefaultContextObjects;
    }

    @Override
    public Map<Class, Object> getDefaultContextObjects() {
        return this.defaultContextObjects;
    }

    @Override
    public void setDefaultContextObjects(Map<Class, Object> defaultContextObjects) {
        this.defaultContextObjects = defaultContextObjects;
    }

    @Override
    public List<String> getScannedResourceClasses() {
        return this.scannedResourceClasses;
    }

    @Override
    public void setScannedResourceClasses(List<String> scannedResourceClasses) {
        this.scannedResourceClasses = scannedResourceClasses;
    }

    @Override
    public List<String> getScannedProviderClasses() {
        return this.scannedProviderClasses;
    }

    @Override
    public void setScannedProviderClasses(List<String> scannedProviderClasses) {
        this.scannedProviderClasses = scannedProviderClasses;
    }

    @Override
    public List<String> getScannedJndiComponentResources() {
        return this.scannedJndiComponentResources;
    }

    @Override
    public void setScannedJndiComponentResources(List<String> scannedJndiComponentResources) {
        this.scannedJndiComponentResources = scannedJndiComponentResources;
    }

    @Override
    public Map<String, List<String>> getScannedResourceClassesWithBuilder() {
        return this.scannedResourceClassesWithBuilder;
    }

    @Override
    public void setScannedResourceClassesWithBuilder(Map<String, List<String>> scannedResourceClassesWithBuilder) {
        this.scannedResourceClassesWithBuilder = scannedResourceClassesWithBuilder;
    }

    @Override
    public boolean isWiderRequestMatching() {
        return this.widerRequestMatching;
    }

    @Override
    public void setWiderRequestMatching(boolean widerRequestMatching) {
        this.widerRequestMatching = widerRequestMatching;
    }

    @Override
    public boolean isAddCharset() {
        return this.addCharset;
    }

    @Override
    public void setAddCharset(boolean addCharset) {
        this.addCharset = addCharset;
    }

    @Override
    public InjectorFactory getInjectorFactory() {
        return this.injectorFactory;
    }

    @Override
    public void setInjectorFactory(InjectorFactory injectorFactory) {
        this.injectorFactory = injectorFactory;
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    @Override
    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }
}

