/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client.header;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;
import org.eclipse.microprofile.rest.client.annotation.RegisterClientHeaders;
import org.eclipse.microprofile.rest.client.ext.ClientHeadersFactory;
import org.eclipse.microprofile.rest.client.ext.DefaultClientHeadersFactoryImpl;
import org.jboss.resteasy.microprofile.client.RestClientExtension;
import org.jboss.resteasy.microprofile.client.header.ClientHeaderProvider;

public class ClientHeaderProviders {
    private static final ClientHeadersFactory defaultHeadersFactory = new DefaultClientHeadersFactoryImpl();
    private static Map<Method, ClientHeaderProvider> providersForMethod = new ConcurrentHashMap<Method, ClientHeaderProvider>();
    private static Map<Class<?>, ClientHeadersFactory> headerFactoriesForClass = new ConcurrentHashMap();

    public static Optional<ClientHeaderProvider> getProvider(Method method) {
        return Optional.ofNullable(providersForMethod.get(method));
    }

    public static Optional<ClientHeadersFactory> getFactory(Class<?> aClass) {
        return Optional.ofNullable(headerFactoriesForClass.get(aClass));
    }

    public static void registerForClass(Class<?> clientClass, Object clientProxy) {
        Stream.of(clientClass.getMethods()).forEach(m -> ClientHeaderProviders.registerForMethod(m, clientProxy));
        ClientHeaderProviders.registerHeaderFactory(clientClass);
    }

    private static void registerHeaderFactory(Class<?> aClass) {
        RegisterClientHeaders annotation = aClass.getAnnotation(RegisterClientHeaders.class);
        if (annotation != null) {
            Optional<ClientHeadersFactory> clientHeadersFactory = ClientHeaderProviders.getCustomHeadersFactory(annotation, aClass);
            headerFactoriesForClass.put(aClass, clientHeadersFactory.orElse(defaultHeadersFactory));
        }
    }

    private static Optional<ClientHeadersFactory> getCustomHeadersFactory(RegisterClientHeaders annotation, Class<?> source) {
        Class<? extends ClientHeadersFactory> factoryClass = annotation.value();
        if (factoryClass != null) {
            Object factory;
            if (RestClientExtension.isCDIActive() && (factory = RestClientExtension.construct(factoryClass)) != null) {
                return Optional.of(factoryClass.cast(factory));
            }
            try {
                return Optional.of(factoryClass.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RestClientDefinitionException("Failed to instantiate " + factoryClass.getCanonicalName() + ", the client header factory for " + source.getCanonicalName(), e);
            }
        }
        return Optional.empty();
    }

    private static void registerForMethod(Method method, Object clientProxy) {
        ClientHeaderProvider.forMethod(method, clientProxy).ifPresent(provider -> providersForMethod.put(method, (ClientHeaderProvider)provider));
    }

    private ClientHeaderProviders() {
    }
}

