/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.mavendependencyupdater.git;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public class GitRepository {
    private Repository repository;
    private Git git;
    private String accessToken;

    public GitRepository(File gitDir, String accessToken) throws IOException {
        this.repository = FileRepositoryBuilder.create(gitDir);
        this.git = new Git(this.repository);
        this.accessToken = accessToken;
    }

    public void checkout(String branch) throws GitAPIException {
        this.checkout(branch, false);
    }

    public void checkout(String branch, boolean createNew) throws GitAPIException {
        CheckoutCommand checkout = this.git.checkout();
        checkout.setName(branch);
        checkout.setCreateBranch(createNew);
        checkout.call();
    }

    public void push(String remote, String branch) throws GitAPIException {
        PushCommand push = this.git.push();
        push.setRemote(remote);
        push.setRefSpecs(new RefSpec(branch + ":" + branch));
        if (!StringUtils.isEmpty(this.accessToken)) {
            push.setCredentialsProvider(new UsernamePasswordCredentialsProvider(this.accessToken, ""));
        }
        push.call();
    }

    public void commit(String message) throws GitAPIException {
        this.git.commit().setMessage(message).call();
    }

    public void add(String filePattern) throws GitAPIException {
        this.git.add().addFilepattern(filePattern).call();
    }

    public List<String> getRemoteBranches() throws GitAPIException {
        Object list = this.git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call();
        return list.stream().map(Ref::getName).collect(Collectors.toList());
    }

    public List<String> getLocalBranches() throws GitAPIException {
        Object list = this.git.branchList().call();
        return list.stream().map(Ref::getName).collect(Collectors.toList());
    }

    public void resetLocalChanges() throws GitAPIException {
        this.git.reset().setMode(ResetCommand.ResetType.HARD).call();
    }

    Repository getRepository() {
        return this.repository;
    }

    public Git getGit() {
        return this.git;
    }
}

