/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.state;

import java.util.List;
import java.util.Properties;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.ext.core.state.State;
import org.commonjava.maven.ext.core.util.IdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryInjectionState
implements State {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String REPOSITORY_INJECTION_PROPERTY = "repositoryInjection";
    private static final String REPOSITORY_INJECTION_POMS = "repositoryInjectionPoms";
    private ProjectVersionRef repoMgmt;
    private List<ProjectRef> groupArtifact;

    public RepositoryInjectionState(Properties userProps) {
        this.initialise(userProps);
    }

    @Override
    public void initialise(Properties userProps) {
        String gav = userProps.getProperty(REPOSITORY_INJECTION_PROPERTY);
        this.groupArtifact = IdUtils.parseGAs(userProps.getProperty(REPOSITORY_INJECTION_POMS));
        this.repoMgmt = gav == null ? null : SimpleProjectVersionRef.parse(gav);
    }

    @Override
    public boolean isEnabled() {
        return this.repoMgmt != null;
    }

    public List<ProjectRef> getRemoteRepositoryInjectionTargets() {
        return this.groupArtifact;
    }

    public ProjectVersionRef getRemoteRepositoryInjectionMgmt() {
        return this.repoMgmt;
    }
}

