/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.util.jhttpc.INTERNAL.conn;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpClientConnection;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.protocol.HttpContext;
import org.commonjava.util.jhttpc.INTERNAL.conn.SiteConnectionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseBlockingConnectionManager
implements HttpClientConnectionManager,
Closeable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SiteConnectionConfig config;
    private final HttpClientConnectionManager connectionManager;

    public CloseBlockingConnectionManager(SiteConnectionConfig config, HttpClientConnectionManager connectionManager) {
        this.config = config;
        this.connectionManager = connectionManager;
    }

    @Override
    public ConnectionRequest requestConnection(HttpRoute route, Object state) {
        return this.connectionManager.requestConnection(route, state);
    }

    @Override
    public void releaseConnection(HttpClientConnection conn, Object newState, long validDuration, TimeUnit timeUnit) {
        this.connectionManager.releaseConnection(conn, newState, validDuration, timeUnit);
    }

    @Override
    public void connect(HttpClientConnection conn, HttpRoute route, int connectTimeout, HttpContext context) throws IOException {
        this.connectionManager.connect(conn, route, connectTimeout, context);
    }

    @Override
    public void upgrade(HttpClientConnection conn, HttpRoute route, HttpContext context) throws IOException {
        this.connectionManager.upgrade(conn, route, context);
    }

    @Override
    public void routeComplete(HttpClientConnection conn, HttpRoute route, HttpContext context) throws IOException {
        this.connectionManager.routeComplete(conn, route, context);
    }

    @Override
    public void closeIdleConnections(long idletime, TimeUnit tunit) {
        this.connectionManager.closeIdleConnections(idletime, tunit);
    }

    @Override
    public void closeExpiredConnections() {
        this.connectionManager.closeExpiredConnections();
    }

    @Override
    public void shutdown() {
        this.logger.trace("BLOCKED connection-manager shutdown. This is intentional, to make the connection pool reusable.");
    }

    public void reallyShutdown() {
        this.connectionManager.shutdown();
    }

    @Override
    public void close() throws IOException {
        this.reallyShutdown();
    }

    public String toString() {
        return "CloseBlockingConnectionManager{config=" + this.config + ", connectionManager=" + this.connectionManager + ", instance=" + super.hashCode() + '}';
    }
}

