/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.mavendependencyupdater.core.processingstrategies;

import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.io.File;
import java.io.PrintStream;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.set.mavendependencyupdater.DependencyEvaluator;
import org.jboss.set.mavendependencyupdater.configuration.Configuration;
import org.jboss.set.mavendependencyupdater.core.aggregation.ComponentUpgradeAggregator;
import org.jboss.set.mavendependencyupdater.core.processingstrategies.TextReportProcessingStrategy;

public class HtmlReportProcessingStrategy
extends TextReportProcessingStrategy {
    private static final String BASIC_STYLES = "font-family: Verdana,sans-serif;font-size: 10pt;";
    private static final String TABLE_STYLES = "margin: 2em 0;border-collapse: collapse;";
    private static final String CAPTION_STYLES = "text-align: left;font-weight: bold;";
    private static final String TH_TD_STYLES = "border-bottom: 1px solid #ddd;padding: 5px;text-align: left;";
    private static final String GAV_STYLES = "font-family: \"Courier New\";";
    private static final String UL_STYLES = "list-style-type: circle;";
    private static final String LI_STYLES = "margin: 7px 0;";
    private static final String REPO_LABEL_STYLES = "border-radius: 5px;padding: 3px;";
    private static final String FOOTER_STYLES = "color: #999;";
    private static final String BG_NEW = "background-color: #fffeec;";
    private static final String BG1 = "background-color: #a8df65;";
    private static final String BG2 = "background-color: #edf492;";
    private static final String BG3 = "background-color: #efb960;";
    private static final String BG4 = "background-color: #ee91bc;";
    private static final String[] BACKGROUNDS = new String[]{"background-color: #a8df65;", "background-color: #edf492;", "background-color: #efb960;", "background-color: #ee91bc;"};
    private List<String> repositoryKeys;

    public HtmlReportProcessingStrategy(Configuration configuration, File pomFile, PrintStream printStream) {
        super(configuration, pomFile, printStream);
        this.initRepositoryKeys();
    }

    public HtmlReportProcessingStrategy(Configuration configuration, File pomFile, String outputFileName) {
        super(configuration, pomFile, outputFileName);
        this.initRepositoryKeys();
    }

    @Override
    public boolean process(List<DependencyEvaluator.ComponentUpgrade> upgrades) {
        try {
            if (upgrades.size() == 0) {
                LOG.info("No components to upgrade.");
                boolean bl = true;
                return bl;
            }
            this.initOutputStream();
            List<DependencyEvaluator.ComponentUpgrade> sortedUpgrades = upgrades.stream().sorted(new TextReportProcessingStrategy.ComponentUpgradeComparator()).collect(Collectors.toList());
            List<DependencyEvaluator.ComponentUpgrade> aggregatedUpgrades = ComponentUpgradeAggregator.aggregateComponentUpgrades(this.pomFile, sortedUpgrades);
            String html = ((ContainerTag)TagCreator.div().withStyle(BASIC_STYLES)).with(TagCreator.h2("Component Upgrade Report"), TagCreator.p("Following repositories were searched:"), ((ContainerTag)TagCreator.ul().withStyle(UL_STYLES)).with(TagCreator.each(this.configuration.getRepositories().entrySet(), entry -> ((ContainerTag)TagCreator.li().withStyle(LI_STYLES)).with(new DomContent[]{TagCreator.span((String)entry.getKey()).withStyle(REPO_LABEL_STYLES + this.repositoryColor((String)entry.getKey())), TagCreator.text(" " + (String)entry.getValue())}))), ((ContainerTag)TagCreator.table().withStyle("font-family: Verdana,sans-serif;font-size: 10pt;margin: 2em 0;border-collapse: collapse;")).with(new DomContent[]{TagCreator.caption("Possible Component Upgrades").withStyle(CAPTION_STYLES), TagCreator.thead(TagCreator.tr().with(this.tableHeaders())), TagCreator.each(aggregatedUpgrades, upgrade -> TagCreator.tr().with(this.tableRowData((DependencyEvaluator.ComponentUpgrade)upgrade))), TagCreator.tr(new DomContent[]{((ContainerTag)TagCreator.td(aggregatedUpgrades.size() + " items").withStyle(TH_TD_STYLES)).attr("colspan", "4")})}), TagCreator.p("Generated on " + DATE_FORMATTER.format(ZonedDateTime.now())), ((ContainerTag)TagCreator.p().withStyle(FOOTER_STYLES)).with(new DomContent[]{TagCreator.text("Report generated by "), ((ContainerTag)TagCreator.a("Maven Dependency Updater").withHref("https://github.com/jboss-set/maven-dependency-updater")).withStyle(FOOTER_STYLES)})).render();
            this.outputStream.println(html);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new RuntimeException("Report generation failed", e);
        }
        finally {
            if (this.outputStream != null && this.outputStream != System.out) {
                this.outputStream.close();
            }
        }
    }

    private DomContent[] tableHeaders() {
        ArrayList headers = new ArrayList();
        headers.add(TagCreator.th("GAV").withStyle(TH_TD_STYLES));
        headers.add(TagCreator.th("New Version").withStyle(TH_TD_STYLES));
        headers.add(TagCreator.th("Repository").withStyle(TH_TD_STYLES));
        if (this.configuration.getLogger().isSet()) {
            headers.add(TagCreator.th("Since").withStyle(TH_TD_STYLES));
        }
        return headers.toArray(new DomContent[0]);
    }

    private DomContent[] tableRowData(DependencyEvaluator.ComponentUpgrade upgrade) {
        boolean isNew = upgrade.getFirstSeen() == null && this.configuration.getLogger().isSet();
        ArrayList cells = new ArrayList();
        cells.add(TagCreator.td(upgrade.getArtifact().getGroupId() + ":" + upgrade.getArtifact().getArtifactId() + ":" + upgrade.getArtifact().getVersionString()).withStyle("border-bottom: 1px solid #ddd;padding: 5px;text-align: left;font-family: \"Courier New\";" + (isNew ? BG_NEW : "")));
        cells.add(TagCreator.td(upgrade.getNewVersion()).withStyle(TH_TD_STYLES + (isNew ? BG_NEW : "")));
        cells.add(TagCreator.td(new DomContent[]{TagCreator.span(upgrade.getRepository()).withStyle(REPO_LABEL_STYLES + this.repositoryColor(upgrade.getRepository()))}).withStyle(TH_TD_STYLES + (isNew ? BG_NEW : "")));
        if (this.configuration.getLogger().isSet()) {
            cells.add(TagCreator.td(upgrade.getFirstSeen() == null ? "new" : upgrade.getFirstSeen().format(DATE_FORMATTER)).withStyle(TH_TD_STYLES + (isNew ? BG_NEW : "")));
        }
        return cells.toArray(new DomContent[0]);
    }

    private void initRepositoryKeys() {
        this.repositoryKeys = new ArrayList<String>(this.configuration.getRepositories().keySet());
    }

    private String repositoryColor(String key) {
        int idx = this.repositoryKeys.indexOf(key);
        return BACKGROUNDS[idx % BACKGROUNDS.length];
    }
}

