/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.inject;

import io.smallrye.config.ConfigMapping;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.inject.MetadataInjectionPoint;
import io.smallrye.config.inject.SecuritySupport;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperties;

public class ConfigMappingInjectionBean<T>
implements Bean<T> {
    private final BeanManager bm;
    private final Class<T> klass;
    private final String prefix;
    private final Set<Annotation> qualifiers = new HashSet<Annotation>();

    public ConfigMappingInjectionBean(BeanManager bm, AnnotatedType<T> type) {
        this.bm = bm;
        this.klass = type.getJavaClass();
        this.prefix = ConfigMappingInjectionBean.getPrefixFromType(type);
        this.qualifiers.add(Default.Literal.INSTANCE);
        if (type.isAnnotationPresent(ConfigProperties.class)) {
            this.qualifiers.add(ConfigProperties.Literal.of(this.prefix));
        }
    }

    @Override
    public Class<?> getBeanClass() {
        return this.klass;
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        InjectionPoint injectionPoint = (InjectionPoint)this.bm.getInjectableReference(new MetadataInjectionPoint(), creationalContext);
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig(SecuritySupport.getContextClassLoader());
        return config.getConfigMapping(this.klass, ConfigMappingInjectionBean.getPrefixFromInjectionPoint(injectionPoint).orElse(this.prefix));
    }

    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
    }

    @Override
    public Set<Type> getTypes() {
        return Collections.singleton(this.klass);
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    @Override
    public String getName() {
        return this.getClass() + "_" + this.klass.getName();
    }

    @Override
    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    @Override
    public boolean isAlternative() {
        return false;
    }

    public static String getPrefixFromType(Annotated annotated) {
        Optional<String> prefixFromConfigMappingClass = Optional.ofNullable(annotated.getBaseType()).map(type -> (Class)type).map(c -> c.getAnnotation(ConfigMapping.class)).map(ConfigMapping::prefix);
        Optional<String> prefixFromConfigPropertiesClass = Optional.ofNullable(annotated.getBaseType()).map(type -> (Class)type).map(c -> c.getAnnotation(ConfigProperties.class)).map(ConfigProperties::prefix).filter(prefix -> !prefix.equals("org.eclipse.microprofile.config.inject.configproperties.unconfiguredprefix"));
        return Stream.of(prefixFromConfigMappingClass, prefixFromConfigPropertiesClass).flatMap(s -> s.map(Stream::of).orElseGet(Stream::empty)).findFirst().orElse("");
    }

    public static Optional<String> getPrefixFromInjectionPoint(InjectionPoint injectionPoint) {
        Optional<String> prefixFromConfigMapping = Optional.ofNullable(injectionPoint.getAnnotated()).map(a -> a.getAnnotation(ConfigMapping.class)).map(ConfigMapping::prefix).filter(prefix -> !prefix.isEmpty());
        Optional<String> prefixFromConfigProperties = Optional.ofNullable(injectionPoint.getAnnotated()).map(a -> a.getAnnotation(ConfigProperties.class)).map(ConfigProperties::prefix).filter(prefix -> !prefix.equals("org.eclipse.microprofile.config.inject.configproperties.unconfiguredprefix"));
        Optional<String> prefixFromQualifier = injectionPoint.getQualifiers().stream().filter(ConfigProperties.class::isInstance).map(ConfigProperties.class::cast).map(ConfigProperties::prefix).filter(prefix -> !prefix.equals("org.eclipse.microprofile.config.inject.configproperties.unconfiguredprefix")).findFirst();
        return Stream.of(prefixFromConfigMapping, prefixFromConfigProperties, prefixFromQualifier).flatMap(s -> s.map(Stream::of).orElseGet(Stream::empty)).findFirst();
    }
}

