/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.io.util;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.maven.io.util.DocumentModifier;
import org.apache.maven.io.util.IndentationCounter;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.WriterFactory;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.DocType;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.JDOMFactory;
import org.jdom2.ProcessingInstruction;
import org.jdom2.Text;
import org.jdom2.UncheckedJDOMFactory;
import org.jdom2.Verifier;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.EscapeStrategy;
import org.jdom2.output.Format;
import org.jdom2.output.LineSeparator;
import org.jdom2.output.XMLOutputter;
import org.jdom2.output.support.AbstractXMLOutputProcessor;
import org.jdom2.output.support.FormatStack;
import org.jdom2.output.support.Walker;
import org.jdom2.util.NamespaceStack;

public abstract class AbstractJDOMWriter<T, TYPE extends AbstractJDOMWriter<T, TYPE>> {
    protected final Format format = Format.getRawFormat();
    protected final JDOMFactory factory = new UncheckedJDOMFactory();

    protected AbstractJDOMWriter() {
        this.setTextMode(Format.TextMode.PRESERVE);
        this.setLineSeparator(System.getProperty("line.separator"));
        this.setOmitDeclaration(false);
        this.setOmitEncoding(false);
        this.setExpandEmptyElements(true);
    }

    protected AbstractJDOMWriter(String encoding) {
        this();
        this.setEncoding(encoding);
    }

    public final void write(T source, Document document, Writer writer) throws IOException {
        this.write(source, document, writer, this.format, null);
    }

    public final void write(T source, Document document, Writer writer, DocumentModifier modifier) throws IOException {
        this.write(source, document, writer, this.format, modifier);
    }

    public final void write(T source, Document document, Writer writer, Format jdomFormat) throws IOException {
        this.write(source, document, writer, jdomFormat, null);
    }

    public final void write(T source, Document document, Writer writer, Format jdomFormat, DocumentModifier modifier) throws IOException {
        if (modifier != null) {
            modifier.preProcess(document);
        }
        this.update(source, new IndentationCounter(0), document.getRootElement());
        if (modifier != null) {
            modifier.postProcess(document);
        }
        XMLOutputter outputter = new XMLOutputter(new AbstractXMLOutputProcessor(){

            @Override
            protected void printDocument(Writer out, FormatStack fstack, NamespaceStack nstack, Document doc) throws IOException {
                ArrayList<Content> list;
                ArrayList<Content> arrayList = list = doc.hasRootElement() ? doc.getContent() : new ArrayList<Content>(doc.getContentSize());
                if (list.isEmpty()) {
                    int sz = doc.getContentSize();
                    for (int i = 0; i < sz; ++i) {
                        list.add(doc.getContent(i));
                    }
                }
                this.printDeclaration(out, fstack);
                Walker walker = this.buildWalker(fstack, list, true);
                if (walker.hasNext()) {
                    while (walker.hasNext()) {
                        String padding;
                        Content c = walker.next();
                        if (c == null) {
                            padding = walker.text();
                            if (padding == null || !Verifier.isAllXMLWhitespace(padding) || walker.isCDATA()) continue;
                            this.write(out, padding);
                            continue;
                        }
                        switch (c.getCType()) {
                            case Comment: {
                                this.printComment(out, fstack, (Comment)c);
                                this.write(out, fstack.getLineSeparator());
                                break;
                            }
                            case DocType: {
                                this.printDocType(out, fstack, (DocType)c);
                                break;
                            }
                            case Element: {
                                this.printElement(out, fstack, nstack, (Element)c);
                                if (!walker.hasNext()) break;
                                this.write(out, fstack.getLineSeparator());
                                break;
                            }
                            case ProcessingInstruction: {
                                this.printProcessingInstruction(out, fstack, (ProcessingInstruction)c);
                                break;
                            }
                            case Text: {
                                padding = ((Text)c).getText();
                                if (padding == null || !Verifier.isAllXMLWhitespace(padding)) break;
                                this.write(out, padding);
                            }
                        }
                    }
                    if (fstack.getLineSeparator() != null) {
                        this.write(out, fstack.getLineSeparator());
                    }
                }
            }
        });
        outputter.setFormat(jdomFormat);
        outputter.output(document, writer);
    }

    public final void write(T source, File target) throws IOException, JDOMException {
        this.write(source, target, this.format, null);
    }

    public final void write(T source, File target, DocumentModifier modifier) throws IOException, JDOMException {
        this.write(source, target, this.format, modifier);
    }

    public final void write(T source, File target, Format format) throws IOException, JDOMException {
        this.write(source, target, format, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(T source, File target, Format format, DocumentModifier modifier) throws IOException, JDOMException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(target);
        Writer pomWriter = null;
        try {
            pomWriter = WriterFactory.newWriter(target, this.getEncoding());
            this.write(source, doc, pomWriter, format, modifier);
            pomWriter.flush();
        }
        catch (Throwable throwable) {
            IOUtil.close(pomWriter);
            throw throwable;
        }
        IOUtil.close(pomWriter);
    }

    protected abstract void update(T var1, IndentationCounter var2, Element var3) throws IOException;

    public TYPE setEscapeStrategy(EscapeStrategy strategy) {
        this.format.setEscapeStrategy(strategy);
        return (TYPE)this;
    }

    public EscapeStrategy getEscapeStrategy() {
        return this.format.getEscapeStrategy();
    }

    public TYPE setLineSeparator(String separator) {
        this.format.setLineSeparator(separator);
        return (TYPE)this;
    }

    public TYPE setLineSeparator(LineSeparator separator) {
        this.format.setLineSeparator(separator);
        return (TYPE)this;
    }

    public String getLineSeparator() {
        return this.format.getLineSeparator();
    }

    public TYPE setOmitEncoding(boolean omitEncoding) {
        this.format.setOmitEncoding(omitEncoding);
        return (TYPE)this;
    }

    public boolean getOmitEncoding() {
        return this.format.getOmitEncoding();
    }

    public TYPE setOmitDeclaration(boolean omitDeclaration) {
        this.format.setOmitDeclaration(omitDeclaration);
        return (TYPE)this;
    }

    public boolean getOmitDeclaration() {
        return this.format.getOmitDeclaration();
    }

    public TYPE setExpandEmptyElements(boolean expandEmptyElements) {
        this.format.setExpandEmptyElements(expandEmptyElements);
        return (TYPE)this;
    }

    public boolean getExpandEmptyElements() {
        return this.format.getExpandEmptyElements();
    }

    public TYPE setIgnoreTrAXEscapingPIs(boolean ignoreTrAXEscapingPIs) {
        this.format.setIgnoreTrAXEscapingPIs(ignoreTrAXEscapingPIs);
        return (TYPE)this;
    }

    public boolean getIgnoreTrAXEscapingPIs() {
        return this.format.getIgnoreTrAXEscapingPIs();
    }

    public TYPE setTextMode(Format.TextMode mode) {
        this.format.setTextMode(mode);
        return (TYPE)this;
    }

    public Format.TextMode getTextMode() {
        return this.format.getTextMode();
    }

    public TYPE setIndent(String indent) {
        this.format.setIndent(indent);
        return (TYPE)this;
    }

    public String getIndent() {
        return this.format.getIndent();
    }

    public TYPE setEncoding(String encoding) {
        this.format.setEncoding(encoding);
        return (TYPE)this;
    }

    public String getEncoding() {
        return this.format.getEncoding();
    }

    public boolean isSpecifiedAttributesOnly() {
        return this.format.isSpecifiedAttributesOnly();
    }

    public TYPE setSpecifiedAttributesOnly(boolean specifiedAttributesOnly) {
        this.format.setSpecifiedAttributesOnly(specifiedAttributesOnly);
        return (TYPE)this;
    }
}

