/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.ident.version;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.commonjava.maven.atlas.ident.version.MultiVersionSpec;
import org.commonjava.maven.atlas.ident.version.RangeVersionSpec;
import org.commonjava.maven.atlas.ident.version.SingleVersion;
import org.commonjava.maven.atlas.ident.version.VersionSpec;
import org.commonjava.maven.atlas.ident.version.VersionSpecComparisons;

public class CompoundVersionSpec
implements VersionSpec,
Iterable<VersionSpec>,
Serializable,
MultiVersionSpec {
    private static final long serialVersionUID = 1L;
    private final List<VersionSpec> specs;
    private final String rawExpression;

    public CompoundVersionSpec(String rawExpression, VersionSpec ... specs) {
        this.rawExpression = rawExpression;
        ArrayList<VersionSpec> s = new ArrayList<VersionSpec>();
        for (VersionSpec spec : specs) {
            if (spec instanceof SingleVersion) {
                throw new IllegalArgumentException("Currently concrete versions are NOT supported in compound version specifications.");
            }
            s.add(spec);
        }
        Collections.sort(s, VersionSpecComparisons.comparator());
        this.specs = Collections.unmodifiableList(s);
    }

    public CompoundVersionSpec(String rawExpression, List<VersionSpec> specs) {
        this.rawExpression = rawExpression;
        ArrayList<VersionSpec> s = new ArrayList<VersionSpec>();
        for (VersionSpec spec : specs) {
            if (spec.isSingle()) {
                SingleVersion sv = (SingleVersion)spec;
                s.add(new RangeVersionSpec("[" + spec.renderStandard() + "]", sv, sv, true, true));
                continue;
            }
            s.add(spec);
        }
        Collections.sort(s, VersionSpecComparisons.comparator());
        this.specs = Collections.unmodifiableList(s);
    }

    @Override
    public String renderStandard() {
        if (this.rawExpression == null) {
            StringBuilder sb = new StringBuilder();
            for (VersionSpec spec : this.specs) {
                sb.append(spec.renderStandard());
            }
            return sb.toString();
        }
        return this.rawExpression;
    }

    @Override
    public boolean contains(VersionSpec version) {
        for (VersionSpec spec : this.specs) {
            if (!spec.contains(version)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(VersionSpec other) {
        return VersionSpecComparisons.compareTo(this, other);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CompoundVersion: [");
        for (VersionSpec spec : this.specs) {
            sb.append("\n  ").append(spec);
        }
        sb.append("\n]\n(").append(this.renderStandard()).append(")");
        return sb.toString();
    }

    @Override
    public boolean isConcrete() {
        return this.specs.size() == 1 && this.specs.get(0).isConcrete();
    }

    @Override
    public Iterator<VersionSpec> iterator() {
        return this.specs.iterator();
    }

    public VersionSpec getFirstComponent() {
        return this.specs.get(0);
    }

    public VersionSpec getLastComponent() {
        return this.specs.get(this.specs.size() - 1);
    }

    @Override
    public boolean isSnapshot() {
        for (VersionSpec spec : this.specs) {
            if (!spec.isSnapshot()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRelease() {
        return !this.isSnapshot();
    }

    @Override
    public boolean isSingle() {
        return this.specs.size() == 1 && this.specs.get(0).isSingle();
    }

    @Override
    public SingleVersion getConcreteVersion() {
        return this.specs.size() != 1 ? null : this.specs.get(0).getConcreteVersion();
    }

    @Override
    public SingleVersion getSingleVersion() {
        return this.specs.size() != 1 ? null : this.specs.get(0).getSingleVersion();
    }

    public int getComponentCount() {
        return this.specs.size();
    }

    @Override
    public boolean isPinned() {
        if (this.specs.size() != 1) {
            return false;
        }
        VersionSpec spec = this.specs.get(0);
        if (spec.isSingle()) {
            return true;
        }
        MultiVersionSpec mvs = (MultiVersionSpec)((Object)spec);
        return mvs.isPinned();
    }

    @Override
    public SingleVersion getPinnedVersion() {
        if (this.specs.size() != 1) {
            return null;
        }
        VersionSpec spec = this.specs.get(0);
        if (spec instanceof SingleVersion) {
            return (SingleVersion)spec;
        }
        MultiVersionSpec mvs = (MultiVersionSpec)((Object)spec);
        if (mvs.isPinned()) {
            return mvs.getPinnedVersion();
        }
        return null;
    }
}

