/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.state;

import java.util.Properties;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.state.State;
import org.commonjava.maven.ext.core.state.VersioningState;
import org.commonjava.maven.ext.io.rest.DefaultTranslator;
import org.commonjava.maven.ext.io.rest.Translator;

public class RESTState
implements State {
    private final ManipulationSession session;
    private String restURL;
    private Translator restEndpoint;
    private boolean restSuffixAlign;

    public RESTState(ManipulationSession session) throws ManipulationException {
        this.session = session;
        this.initialise(session.getUserProperties());
    }

    @Override
    public void initialise(Properties userProps) throws ManipulationException {
        VersioningState vState = this.session.getState(VersioningState.class);
        this.restURL = userProps.getProperty("restURL");
        String repositoryGroup = userProps.getProperty("restRepositoryGroup", "");
        int restMaxSize = Integer.parseInt(userProps.getProperty("restMaxSize", "-1"));
        int restMinSize = Integer.parseInt(userProps.getProperty("restMinSize", String.valueOf(4)));
        this.restSuffixAlign = Boolean.parseBoolean(userProps.getProperty("restSuffixAlign", "true"));
        Translator.RestProtocol protocol = Translator.RestProtocol.parse(userProps.getProperty("restProtocol", Translator.RestProtocol.CURRENT.toString()));
        long connectionTimeout = Long.parseLong(userProps.getProperty("restConnectionTimeout", String.valueOf(30L)));
        long socketTimeout = Long.parseLong(userProps.getProperty("restSocketTimeout", String.valueOf(600L)));
        int retryTimeout = Integer.parseInt(userProps.getProperty("restRetryDuration", String.valueOf(30)));
        this.restEndpoint = new DefaultTranslator(this.restURL, protocol, restMaxSize, restMinSize, repositoryGroup, vState.getIncrementalSerialSuffix(), connectionTimeout, socketTimeout, retryTimeout);
    }

    @Override
    public boolean isEnabled() {
        return this.restURL != null && !this.restURL.isEmpty();
    }

    public Translator getVersionTranslator() {
        return this.restEndpoint;
    }

    public boolean isRestSuffixAlign() {
        return this.restSuffixAlign;
    }
}

