/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.filearc;

import java.io.InputStream;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.event.EventMetadata;
import org.commonjava.maven.galley.filearc.internal.ZipDownload;
import org.commonjava.maven.galley.filearc.internal.ZipExistence;
import org.commonjava.maven.galley.filearc.internal.ZipListing;
import org.commonjava.maven.galley.filearc.internal.ZipPublish;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.spi.transport.DownloadJob;
import org.commonjava.maven.galley.spi.transport.ExistenceJob;
import org.commonjava.maven.galley.spi.transport.ListingJob;
import org.commonjava.maven.galley.spi.transport.PublishJob;
import org.commonjava.maven.galley.spi.transport.Transport;

@ApplicationScoped
@Named(value="zip-jar-galley-transport")
public class ZipJarTransport
implements Transport {
    @Override
    public DownloadJob createDownloadJob(ConcreteResource resource, Transfer target, Map<Transfer, Long> transferSizes, int timeoutSeconds, EventMetadata eventMetadata) throws TransferException {
        return new ZipDownload(target, eventMetadata);
    }

    @Override
    public PublishJob createPublishJob(ConcreteResource resource, InputStream stream, long length, int timeoutSeconds) throws TransferException {
        return this.createPublishJob(resource, stream, length, null, timeoutSeconds);
    }

    @Override
    public PublishJob createPublishJob(ConcreteResource resource, InputStream stream, long length, String contentType, int timeoutSeconds) throws TransferException {
        return new ZipPublish(resource, stream);
    }

    @Override
    public boolean handles(Location location) {
        String uri = location.getUri();
        return uri != null && (uri.startsWith("zip:") || uri.startsWith("jar:"));
    }

    @Override
    public ListingJob createListingJob(ConcreteResource resource, Transfer target, int timeoutSeconds) throws TransferException {
        return new ZipListing(resource, target);
    }

    @Override
    public ExistenceJob createExistenceJob(ConcreteResource resource, Transfer target, int timeoutSeconds) throws TransferException {
        return new ZipExistence(resource);
    }

    @Override
    public boolean allowsCaching() {
        return true;
    }
}

