/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.state;

public enum EnforcingMode {
    on{

        @Override
        public Boolean defaultModificationValue() {
            return true;
        }
    }
    ,
    off{

        @Override
        public Boolean defaultModificationValue() {
            return false;
        }
    }
    ,
    detect{

        @Override
        public Boolean defaultModificationValue() {
            return null;
        }
    }
    ,
    none{

        @Override
        public Boolean defaultModificationValue() {
            return null;
        }
    };


    public static EnforcingMode getMode(String value) {
        EnforcingMode[] values;
        if (value == null || value.trim().length() < 1) {
            return none;
        }
        if (Boolean.parseBoolean(value)) {
            return on;
        }
        if (value.equalsIgnoreCase("false")) {
            return off;
        }
        EnforcingMode m = none;
        for (EnforcingMode mode : values = EnforcingMode.values()) {
            if (!value.equalsIgnoreCase(mode.name())) continue;
            m = mode;
            break;
        }
        return m;
    }

    public abstract Boolean defaultModificationValue();
}

