/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.asyncutil.locks;

import com.ibm.asyncutil.locks.AbstractSimpleEpoch;
import com.ibm.asyncutil.locks.AsyncReadWriteLock;
import com.ibm.asyncutil.locks.AsyncStampedLock;
import com.ibm.asyncutil.locks.PlatformDependent;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class FairAsyncReadWriteLock
implements AsyncReadWriteLock {
    volatile Node head;

    public FairAsyncReadWriteLock() {
        Node h = new Node(0);
        h.readFuture.complete(h);
        this.head = h;
    }

    @Override
    public final CompletionStage<AsyncReadWriteLock.ReadLockToken> acquireReadLock() {
        Node h;
        while ((h = this.head).internalEnter() != AbstractSimpleEpoch.Status.NORMAL) {
        }
        return h.readFuture;
    }

    @Override
    public final Optional<AsyncReadWriteLock.ReadLockToken> tryReadLock() {
        Node h = this.head;
        return h.tryReadLock() ? Optional.of(h) : Optional.empty();
    }

    @Override
    public final CompletionStage<AsyncReadWriteLock.WriteLockToken> acquireWriteLock() {
        Node h;
        while ((h = this.head).internalTerminate() != AbstractSimpleEpoch.Status.NORMAL) {
        }
        this.head = h.next = new Node(1, h);
        return h.writeLockToken;
    }

    @Override
    public final Optional<AsyncReadWriteLock.WriteLockToken> tryWriteLock() {
        Node h = this.head;
        if (h.tryWriteLock()) {
            this.head = h.next = new Node(1, h);
            return Optional.of(h.writeLockToken);
        }
        return Optional.empty();
    }

    static class Node
    extends AbstractSimpleEpoch
    implements AsyncReadWriteLock.ReadLockToken,
    AsyncStampedLock.Stamp {
        final CompletableFuture<AsyncReadWriteLock.ReadLockToken> readFuture;
        final WriteLockFutureToken writeLockToken;
        Node next;
        Node prev;
        private Thread releaseThread;

        private Node() {
            this.readFuture = null;
            this.writeLockToken = null;
        }

        Node(int initialEntrants) {
            this(initialEntrants, new Node());
            this.prev.next = this;
        }

        Node(int initialEntrants, Node predecessor) {
            this.lazySet(initialEntrants);
            this.prev = predecessor;
            this.readFuture = new CompletableFuture();
            this.writeLockToken = new WriteLockFutureToken();
        }

        @Override
        public final void releaseLock() {
            this.close();
        }

        @Override
        final void onCleared() {
            this.releaseThread = Thread.currentThread();
            if (this.releaseThread.equals(this.prev.releaseThread)) {
                Node unlink = this.prev;
                this.prev = unlink.prev;
                unlink.prev.next = this;
                unlink.next = null;
                unlink.prev = null;
                unlink.releaseThread = null;
            } else {
                Node sentinel = this.prev;
                do {
                    Node toComplete = sentinel.next;
                    sentinel.next = null;
                    toComplete.writeLockToken.complete();
                } while (sentinel.next != null);
                toComplete.releaseThread = null;
                toComplete.prev = null;
            }
        }

        final boolean tryReadLock() {
            return this.readFuture.isDone() && this.internalEnter() == AbstractSimpleEpoch.Status.NORMAL;
        }

        final boolean tryWriteLock() {
            return this.compareAndSet(0, Integer.MIN_VALUE);
        }

        @Override
        public final boolean validate() {
            if (!PlatformDependent.loadFence()) {
                return false;
            }
            return !this.isCleared();
        }

        class WriteLockFutureToken
        extends CompletableFuture<AsyncReadWriteLock.WriteLockToken>
        implements AsyncReadWriteLock.WriteLockToken {
            WriteLockFutureToken() {
            }

            @Override
            public void releaseLock() {
                this.downgradeLock().releaseLock();
            }

            @Override
            public AsyncReadWriteLock.ReadLockToken downgradeLock() {
                Node n = Node.this.next;
                if (!n.readFuture.complete(n)) {
                    throw new IllegalStateException("released or downgraded write lock not in locked state");
                }
                return n;
            }

            private void complete() {
                if (!this.complete(this)) {
                    throw new AssertionError();
                }
            }
        }
    }
}

