/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.groovy;

import java.util.List;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.commonjava.maven.ext.core.groovy.BaseScript;
import org.commonjava.maven.ext.core.groovy.GMEBaseScript;
import org.commonjava.maven.ext.core.groovy.GradleBaseScript;
import org.commonjava.maven.ext.core.groovy.InvocationPoint;
import org.commonjava.maven.ext.core.groovy.PMEBaseScript;
import org.commonjava.maven.ext.core.groovy.PMEInvocationPoint;

@GroovyASTTransformation(phase=CompilePhase.SEMANTIC_ANALYSIS)
public class ASTTransformer
extends AbstractASTTransformation {
    private static final ClassNode MAVEN_TYPE = ClassHelper.make(PMEBaseScript.class);
    private static final ClassNode GRADLE_TYPE = ClassHelper.make(GMEBaseScript.class);
    private static final ClassNode DEPRECATED_COMMAND_TYPE = ClassHelper.make(PMEInvocationPoint.class);
    private static final ClassNode COMMAND_TYPE = ClassHelper.make(InvocationPoint.class);
    private static final ClassNode MAVEN_BASE_SCRIPT_TYPE = ClassHelper.make(BaseScript.class);
    private static final String MAVEN_TYPE_NAME = "@" + MAVEN_TYPE.getNameWithoutPackage();
    private static final ClassNode GRADLE_BASE_SCRIPT_TYPE = ClassHelper.make(GradleBaseScript.class);
    private static final String GRADLE_TYPE_NAME = "@" + GRADLE_TYPE.getNameWithoutPackage();
    private Type type;
    private static final Parameter[] CONTEXT_CTOR_PARAMETERS = new Parameter[]{new Parameter(ClassHelper.BINDING_TYPE, "context")};

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.init(nodes, source);
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode node = (AnnotationNode)nodes[0];
        if (MAVEN_TYPE.equals(node.getClassNode()) || GRADLE_TYPE.equals(node.getClassNode())) {
            Type type = this.type = MAVEN_TYPE.equals(node.getClassNode()) ? Type.MAVEN : Type.GRADLE;
            if (parent instanceof DeclarationExpression) {
                this.changeBaseScriptTypeFromDeclaration((DeclarationExpression)parent, node);
            } else if (parent instanceof ImportNode || parent instanceof PackageNode) {
                this.changeBaseScriptTypeFromPackageOrImport(source, parent, node);
            } else if (parent instanceof ClassNode) {
                this.changeBaseScriptTypeFromClass((ClassNode)parent, node);
            }
        }
    }

    private String getType() {
        if (this.type == Type.MAVEN) {
            return MAVEN_TYPE_NAME;
        }
        return GRADLE_TYPE_NAME;
    }

    private void changeBaseScriptTypeFromPackageOrImport(SourceUnit source, AnnotatedNode parent, AnnotationNode node) {
        Expression value = node.getMember("value");
        if (!(value instanceof ClassExpression)) {
            this.addError("Annotation " + this.getType() + " member 'value' should be a class literal.", value);
            return;
        }
        List<ClassNode> classes = source.getAST().getClasses();
        for (ClassNode classNode : classes) {
            if (!classNode.isScriptBody()) continue;
            this.changeBaseScriptType(parent, classNode, value.getType());
        }
    }

    private void changeBaseScriptTypeFromClass(ClassNode parent, AnnotationNode node) {
        this.changeBaseScriptType(parent, parent, parent.getSuperClass());
    }

    private void changeBaseScriptTypeFromDeclaration(DeclarationExpression de, AnnotationNode node) {
        if (de.isMultipleAssignmentDeclaration()) {
            this.addError("Annotation " + this.getType() + " not supported with multiple assignment notation.", de);
            return;
        }
        if (!(de.getRightExpression() instanceof EmptyExpression)) {
            this.addError("Annotation " + this.getType() + " not supported with variable assignment.", de);
            return;
        }
        Expression value = node.getMember("value");
        if (value != null) {
            this.addError("Annotation " + this.getType() + " cannot have member 'value' if used on a declaration.", value);
            return;
        }
        ClassNode cNode = de.getDeclaringClass();
        ClassNode baseScriptType = de.getVariableExpression().getType().getPlainNodeReference();
        if (baseScriptType.isScript()) {
            if (!(de.getRightExpression() instanceof EmptyExpression)) {
                this.addError("Annotation " + this.getType() + " not supported with variable assignment.", de);
                return;
            }
            de.setRightExpression(new VariableExpression("this"));
        } else {
            baseScriptType = this.type == Type.MAVEN ? MAVEN_BASE_SCRIPT_TYPE : GRADLE_BASE_SCRIPT_TYPE;
        }
        this.changeBaseScriptType(de, cNode, baseScriptType);
    }

    private void changeBaseScriptType(AnnotatedNode parent, ClassNode cNode, ClassNode baseScriptType) {
        MethodNode defaultMethod;
        if (!cNode.isScriptBody()) {
            this.addError("Annotation " + this.getType() + " can only be used within a Script.", parent);
            return;
        }
        if (!baseScriptType.isScript()) {
            this.addError("Declared type " + baseScriptType + " does not extend groovy.lang.Script class!", parent);
            return;
        }
        List<AnnotationNode> annotations = parent.getAnnotations(DEPRECATED_COMMAND_TYPE);
        if (cNode.getAnnotations(DEPRECATED_COMMAND_TYPE).isEmpty()) {
            cNode.addAnnotations(annotations);
        }
        annotations = parent.getAnnotations(COMMAND_TYPE);
        if (cNode.getAnnotations(COMMAND_TYPE).isEmpty()) {
            cNode.addAnnotations(annotations);
        }
        cNode.setSuperClass(baseScriptType);
        MethodNode runScriptMethod = ClassHelper.findSAM(baseScriptType);
        if (ASTTransformer.isCustomScriptBodyMethod(runScriptMethod) && (defaultMethod = cNode.getDeclaredMethod("run", Parameter.EMPTY_ARRAY)) != null) {
            cNode.removeMethod(defaultMethod);
            MethodNode methodNode = new MethodNode(runScriptMethod.getName(), runScriptMethod.getModifiers() & 0xFFFFFBFF, runScriptMethod.getReturnType(), runScriptMethod.getParameters(), runScriptMethod.getExceptions(), defaultMethod.getCode());
            methodNode.copyNodeMetaData(defaultMethod);
            ClassNodeUtils.addGeneratedMethod(cNode, methodNode);
        }
        if (cNode.getSuperClass().getDeclaredConstructor(CONTEXT_CTOR_PARAMETERS) == null) {
            ConstructorNode orphanedConstructor = cNode.getDeclaredConstructor(CONTEXT_CTOR_PARAMETERS);
            cNode.removeConstructor(orphanedConstructor);
        }
    }

    private static boolean isCustomScriptBodyMethod(MethodNode node) {
        return node != null && (!node.getDeclaringClass().equals(ClassHelper.SCRIPT_TYPE) || !"run".equals(node.getName()) || node.getParameters().length != 0);
    }

    static enum Type {
        GRADLE,
        MAVEN;

    }
}

