/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.parse;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.maven.model.view.DocRef;
import org.commonjava.maven.galley.maven.parse.XMLInfrastructure;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.spi.transport.LocationExpander;

public abstract class AbstractMavenXmlReader<T> {
    private final Map<DocCacheKey<T>, WeakReference<DocRef<T>>> cache = new ConcurrentHashMap<DocCacheKey<T>, WeakReference<DocRef<T>>>();
    @Inject
    protected XMLInfrastructure xml;
    @Inject
    protected LocationExpander locationExpander;

    protected AbstractMavenXmlReader() {
    }

    protected AbstractMavenXmlReader(XMLInfrastructure xml, LocationExpander locationExpander) {
        this.xml = xml;
        this.locationExpander = locationExpander;
    }

    protected synchronized void cache(DocRef<T> dr) {
        this.cache.put(new DocCacheKey<T>(dr), new WeakReference<DocRef<T>>(dr));
    }

    protected synchronized DocRef<T> getFirstCached(T ref, Collection<? extends Location> locations) throws TransferException {
        for (Location location : this.locationExpander.expand(locations)) {
            DocCacheKey key = new DocCacheKey(ref, location);
            WeakReference<DocRef<T>> reference = this.cache.get(key);
            if (reference == null) continue;
            DocRef dr = (DocRef)reference.get();
            if (dr == null) {
                this.cache.remove(key);
                continue;
            }
            return dr;
        }
        return null;
    }

    protected synchronized Map<Location, DocRef<T>> getAllCached(T ref, List<? extends Location> locations) {
        HashMap<Location, DocRef<T>> result = new HashMap<Location, DocRef<T>>();
        for (Location location : locations) {
            DocCacheKey key = new DocCacheKey(ref, location);
            WeakReference<DocRef<T>> reference = this.cache.get(key);
            if (reference == null) continue;
            DocRef dr = (DocRef)reference.get();
            if (dr == null) {
                this.cache.remove(key);
                continue;
            }
            result.put(location, dr);
        }
        return result;
    }

    private static final class DocCacheKey<T> {
        private final T ref;
        private final Object source;

        private DocCacheKey(T ref, Location location) {
            this.ref = ref;
            this.source = location;
        }

        public DocCacheKey(DocRef<T> dr) {
            this.ref = dr.getRef();
            this.source = dr.getSource();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            result = 31 * result + (this.ref == null ? 0 : this.ref.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DocCacheKey other = (DocCacheKey)obj;
            if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
                return false;
            }
            if (this.ref == null) {
                return other.ref == null;
            }
            return this.ref.equals(other.ref);
        }
    }
}

