/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.kohsuke.github.GHGistFile;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.github.Requester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHGist
extends GHObject {
    GHUser owner;
    GitHub root;
    private String forks_url;
    private String commits_url;
    private String id;
    private String git_pull_url;
    private String git_push_url;
    private String html_url;
    @JsonProperty(value="public")
    private boolean _public;
    private String description;
    private int comments;
    private String comments_url;
    private Map<String, GHGistFile> files = new HashMap<String, GHGistFile>();

    public GHUser getOwner() throws IOException {
        return this.root.intern(this.owner);
    }

    public String getForksUrl() {
        return this.forks_url;
    }

    public String getCommitsUrl() {
        return this.commits_url;
    }

    public String getGitPullUrl() {
        return this.git_pull_url;
    }

    public String getGitPushUrl() {
        return this.git_push_url;
    }

    @Override
    public URL getHtmlUrl() {
        return GitHub.parseURL(this.html_url);
    }

    public boolean isPublic() {
        return this._public;
    }

    public String getDescription() {
        return this.description;
    }

    public int getCommentCount() {
        return this.comments;
    }

    public String getCommentsUrl() {
        return this.comments_url;
    }

    public GHGistFile getFile(String name) {
        return this.files.get(name);
    }

    public Map<String, GHGistFile> getFiles() {
        return Collections.unmodifiableMap(this.files);
    }

    GHGist wrapUp(GHUser owner) {
        this.owner = owner;
        this.root = owner.root;
        this.wrapUp();
        return this;
    }

    GHGist wrapUp(GitHub root) {
        this.owner = root.getUser(this.owner);
        this.root = root;
        this.wrapUp();
        return this;
    }

    private void wrapUp() {
        for (Map.Entry<String, GHGistFile> e : this.files.entrySet()) {
            e.getValue().fileName = e.getKey();
        }
    }

    String getApiTailUrl(String tail) {
        return "/gists/" + this.id + '/' + tail;
    }

    public void star() throws IOException {
        new Requester(this.root).method("PUT").to(this.getApiTailUrl("star"));
    }

    public void unstar() throws IOException {
        new Requester(this.root).method("DELETE").to(this.getApiTailUrl("star"));
    }

    public boolean isStarred() throws IOException {
        return this.root.retrieve().asHttpStatusCode(this.getApiTailUrl("star")) / 100 == 2;
    }

    public GHGist fork() throws IOException {
        return ((GHGist)((Object)new Requester(this.root).to(this.getApiTailUrl("forks"), GHGist.class))).wrapUp(this.root);
    }

    public PagedIterable<GHGist> listForks() {
        return new PagedIterable<GHGist>(){

            @Override
            public PagedIterator<GHGist> _iterator(int pageSize) {
                return new PagedIterator<GHGist>(GHGist.this.root.retrieve().asIterator(GHGist.this.getApiTailUrl("forks"), GHGist[].class, pageSize)){

                    protected void wrapUp(GHGist[] page) {
                        for (GHGist c : page) {
                            c.wrapUp(GHGist.this.root);
                        }
                    }
                };
            }
        };
    }

    public void delete() throws IOException {
        new Requester(this.root).method("DELETE").to("/gists/" + this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GHGist ghGist = (GHGist)o;
        return this.id.equals(ghGist.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

