/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.state;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.model.Plugin;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.core.state.DependencyState;
import org.commonjava.maven.ext.core.state.State;
import org.commonjava.maven.ext.core.util.IdUtils;

public class PluginState
implements State {
    private static final String PLUGIN_SOURCE = "pluginSource";
    private static final String PLUGIN_MANAGEMENT_POM_PROPERTY = "pluginManagement";
    private List<ProjectVersionRef> pluginMgmt;
    private Precedence configPrecedence;
    private boolean injectRemotePlugins;
    private Set<Plugin> remoteRESTplugins = new HashSet<Plugin>();
    private PluginPrecedence precedence;

    public PluginState(Properties userProps) throws ManipulationException {
        this.initialise(userProps);
    }

    @Override
    public void initialise(Properties userProps) throws ManipulationException {
        this.pluginMgmt = IdUtils.parseGAVs(userProps.getProperty(PLUGIN_MANAGEMENT_POM_PROPERTY));
        this.injectRemotePlugins = Boolean.parseBoolean(userProps.getProperty("injectRemotePlugins", "false"));
        switch (Precedence.valueOf(userProps.getProperty("pluginManagementPrecedence", Precedence.REMOTE.toString()).toUpperCase())) {
            case LOCAL: {
                this.configPrecedence = Precedence.LOCAL;
                break;
            }
            default: {
                this.configPrecedence = Precedence.REMOTE;
            }
        }
        switch (PluginPrecedence.valueOf(userProps.getProperty(PLUGIN_SOURCE, userProps.getProperty("dependencySource", DependencyState.DependencyPrecedence.BOM.toString())).toUpperCase())) {
            case REST: {
                this.precedence = PluginPrecedence.REST;
                break;
            }
            case BOM: {
                this.precedence = PluginPrecedence.BOM;
                break;
            }
            case RESTBOM: {
                this.precedence = PluginPrecedence.RESTBOM;
                break;
            }
            case BOMREST: {
                this.precedence = PluginPrecedence.BOMREST;
                break;
            }
            case NONE: {
                this.precedence = PluginPrecedence.NONE;
                break;
            }
            default: {
                throw new ManipulationException("Unknown value {} for {}", userProps.getProperty(PLUGIN_SOURCE), PLUGIN_SOURCE);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.precedence != PluginPrecedence.NONE && this.pluginMgmt != null && !this.pluginMgmt.isEmpty() || this.remoteRESTplugins != null && !this.remoteRESTplugins.isEmpty();
    }

    public List<ProjectVersionRef> getRemotePluginMgmt() {
        return this.pluginMgmt;
    }

    public Precedence getConfigPrecedence() {
        return this.configPrecedence;
    }

    public boolean getInjectRemotePlugins() {
        return this.injectRemotePlugins;
    }

    public void setRemoteRESTOverrides(Map<ArtifactRef, String> overrides) {
        for (ArtifactRef a : overrides.keySet()) {
            Plugin p = new Plugin();
            p.setGroupId(a.getGroupId());
            p.setArtifactId(a.getArtifactId());
            p.setVersion(overrides.get(a));
            this.remoteRESTplugins.add(p);
        }
    }

    public Set<Plugin> getRemoteRESTOverrides() {
        return this.remoteRESTplugins;
    }

    public PluginPrecedence getPrecedence() {
        return this.precedence;
    }

    public static enum Precedence {
        REMOTE,
        LOCAL;

    }

    public static enum PluginPrecedence {
        REST,
        BOM,
        RESTBOM,
        BOMREST,
        NONE;

    }
}

