/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.cache;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.enterprise.context.ApplicationScoped;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class SimpleLockingSupport {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<ConcreteResource, WeakReference<Thread>> lock = new HashMap<ConcreteResource, WeakReference<Thread>>();
    private ReportingTask reporter;
    private final Timer timer = new Timer(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForUnlock(ConcreteResource resource) {
        Map<ConcreteResource, WeakReference<Thread>> map = this.lock;
        synchronized (map) {
            while (this.isLocked(resource)) {
                this.logger.debug("{} waiting for unlock of {}", (Object)Thread.currentThread().getName(), (Object)resource);
                try {
                    this.lock.wait(500L);
                }
                catch (InterruptedException e) {
                    this.logger.debug("{} interrupted while waiting for unlock of: {}", (Object)Thread.currentThread().getName(), (Object)resource);
                    break;
                }
            }
        }
    }

    public synchronized boolean isLocked(ConcreteResource resource) {
        WeakReference<Thread> ref = this.lock.get(resource);
        if (ref != null) {
            Thread t = (Thread)ref.get();
            if (t != null) {
                if (t == Thread.currentThread()) {
                    return false;
                }
                this.logger.debug("{} locked by: {}", (Object)resource, (Object)t.getName());
                return true;
            }
            this.lock.remove(resource);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(ConcreteResource resource) {
        Map<ConcreteResource, WeakReference<Thread>> map = this.lock;
        synchronized (map) {
            Thread me = Thread.currentThread();
            WeakReference<Thread> reference = this.lock.get(resource);
            if (reference == null || reference.get() == me) {
                this.logger.debug("Removing locked: {} by: {}. Returning.", (Object)resource, (Object)me.getName());
                this.lock.remove(resource);
                this.lock.notifyAll();
            } else {
                Thread thread = (Thread)reference.get();
                this.logger.debug("{} locked by: {}. Returning.", (Object)resource, (Object)(thread == null ? null : thread.getName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(ConcreteResource resource) {
        Map<ConcreteResource, WeakReference<Thread>> map = this.lock;
        synchronized (map) {
            Thread me = Thread.currentThread();
            WeakReference<Thread> reference = this.lock.get(resource);
            if (reference != null) {
                if (reference.get() == me) {
                    this.logger.debug("{} already locked by: {}. Returning.", (Object)resource, (Object)me.getName());
                    return;
                }
                Thread thread = (Thread)reference.get();
                this.logger.debug("{} already locked by: {}. Waiting.", (Object)resource, (Object)(thread == null ? null : thread.getName()));
                this.waitForUnlock(resource);
            }
            this.logger.debug("Locking: {} in: {}.", (Object)resource, (Object)me.getName());
            this.lock.put(resource, new WeakReference<Thread>(Thread.currentThread()));
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cleanupCurrentThread() {
        long id = Thread.currentThread().getId();
        for (ConcreteResource res : new HashSet<ConcreteResource>(this.lock.keySet())) {
            WeakReference<Thread> ref = this.lock.get(res);
            if (ref == null) continue;
            boolean rm = false;
            Thread thread = (Thread)ref.get();
            if (thread == null) {
                this.logger.debug("Cleaning up lock: {} for thread: {}", (Object)res, (Object)Thread.currentThread().getName());
                rm = true;
            } else if (thread.getId() == id) {
                this.logger.debug("Cleaning up lock: {} for thread: {}", (Object)res, (Object)Thread.currentThread().getName());
                rm = true;
            }
            if (!rm) continue;
            Map<ConcreteResource, WeakReference<Thread>> map = this.lock;
            synchronized (map) {
                this.lock.remove(res);
                this.lock.notifyAll();
            }
        }
    }

    public Map<ConcreteResource, CharSequence> getActiveLocks() {
        HashMap<ConcreteResource, CharSequence> active = new HashMap<ConcreteResource, CharSequence>();
        for (ConcreteResource f : this.lock.keySet()) {
            StringBuilder owner = new StringBuilder();
            WeakReference<Thread> ref = this.lock.get(f);
            if (ref == null) {
                owner.append("UNKNOWN OWNER; REF IS NULL.");
            } else {
                Thread t = (Thread)ref.get();
                if (t == null) {
                    owner.append("UNKNOWN OWNER; REF IS EMPTY.");
                } else {
                    owner.append(t.getName());
                    if (!t.isAlive()) {
                        owner.append(" (DEAD)");
                    }
                }
            }
            active.put(f, owner);
        }
        return active;
    }

    public synchronized void startReporting() {
        this.startReporting(0L, 10000L);
    }

    public synchronized void startReporting(long delay, long period) {
        if (this.reporter == null) {
            this.logger.info("Starting file-lock statistics reporting with initial delay: {}ms and period: {}ms", (Object)delay, (Object)period);
            this.reporter = new ReportingTask();
            this.timer.schedule((TimerTask)this.reporter, delay, period);
        }
    }

    public synchronized void stopReporting() {
        if (this.reporter != null) {
            this.logger.info("Stopping file-lock statistics reporting.");
            this.reporter.cancel();
        }
    }

    private final class ReportingTask
    extends TimerTask {
        private ReportingTask() {
        }

        @Override
        public void run() {
            Map<ConcreteResource, CharSequence> activeLocks = SimpleLockingSupport.this.getActiveLocks();
            if (activeLocks.isEmpty()) {
                SimpleLockingSupport.this.logger.debug("No file locks to report.");
                return;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("\n\nThe following file locks are still active:");
            for (ConcreteResource file : activeLocks.keySet()) {
                sb.append("\n").append(file).append(" is owned by ").append(activeLocks.get(file));
            }
            sb.append("\n\n");
            SimpleLockingSupport.this.logger.info(sb.toString());
        }
    }
}

