/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.mavendependencyupdater;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;
import org.jboss.logging.Logger;
import org.jboss.set.mavendependencyupdater.ArtifactResult;
import org.jboss.set.mavendependencyupdater.AvailableVersionsResolver;
import org.jboss.set.mavendependencyupdater.ComponentUpgrade;
import org.jboss.set.mavendependencyupdater.VersionStream;
import org.jboss.set.mavendependencyupdater.common.ident.ScopedArtifactRef;
import org.jboss.set.mavendependencyupdater.configuration.Configuration;
import org.jboss.set.mavendependencyupdater.loggerclient.ComponentUpgradeDTO;
import org.jboss.set.mavendependencyupdater.loggerclient.LoggerClient;
import org.jboss.set.mavendependencyupdater.loggerclient.UpgradeNotFoundException;
import org.jboss.set.mavendependencyupdater.rules.NeverRestriction;
import org.jboss.set.mavendependencyupdater.rules.Restriction;
import org.jboss.set.mavendependencyupdater.rules.TokenizedVersion;
import org.jboss.set.mavendependencyupdater.rules.VersionPrefixRestriction;
import org.jboss.set.mavendependencyupdater.rules.VersionStreamRestriction;

public class DependencyEvaluator {
    private static final Logger LOG = Logger.getLogger(DependencyEvaluator.class);
    private static final VersionStreamRestriction DEFAULT_STREAM_RESTRICTION = new VersionStreamRestriction(VersionStream.MICRO);
    private static final Comparator<Version> VERSION_COMPARATOR = Comparator.comparing(v -> TokenizedVersion.parse(v.toString()));
    private final Configuration configuration;
    private final AvailableVersionsResolver availableVersionsResolver;
    private final LoggerClient loggerClient;
    private boolean configUpToDate;

    public DependencyEvaluator(Configuration configuration, AvailableVersionsResolver availableVersionsResolver, LoggerClient loggerClient) {
        this.configuration = configuration;
        this.availableVersionsResolver = availableVersionsResolver;
        this.loggerClient = loggerClient;
    }

    public List<ArtifactResult<ComponentUpgrade>> getVersionsToUpgrade(Collection<ScopedArtifactRef> dependencies) {
        ArrayList<ArtifactResult<ComponentUpgrade>> versionsToUpgrade = new ArrayList<ArtifactResult<ComponentUpgrade>>();
        this.configUpToDate = true;
        for (ScopedArtifactRef dep : dependencies) {
            Artifact rangeArtifact = DependencyEvaluator.toVersionRangeArtifact(dep);
            if (dep.getVersionString().startsWith("$")) {
                LOG.warnf("Skipping dependency '%s', should this be resolved?", (Object)dep);
                continue;
            }
            if (this.configuration.getIgnoreScopes().contains(dep.getScope())) {
                LOG.debugf("Skipping dependency '%s', scope '%s' is ignored", (Object)dep, (Object)dep.getScope());
                continue;
            }
            try {
                List<Restriction> restrictions = this.configuration.getRestrictionsFor(dep.getGroupId(), dep.getArtifactId());
                VersionRangeResult versionRangeResult = this.availableVersionsResolver.resolveVersionRange(rangeArtifact);
                ArtifactResult<Version> scopedVersions = this.findLatest(dep, restrictions, versionRangeResult.getVersions());
                LOG.debugf("Available versions for '%s': %s", (Object)dep, (Object)versionRangeResult);
                if (scopedVersions.anyPresent()) {
                    ComponentUpgrade latestConfigured = null;
                    ComponentUpgrade latestMinor = null;
                    ComponentUpgrade veryLatest = null;
                    if (DependencyEvaluator.versionDiffersFromCurrent(dep.getVersionString(), scopedVersions.getLatestConfigured())) {
                        latestConfigured = this.upgradeInfo(scopedVersions.getLatestConfigured(), versionRangeResult, dep);
                    }
                    if (DependencyEvaluator.versionDiffersFromCurrent(dep.getVersionString(), scopedVersions.getLatestMinor())) {
                        latestMinor = this.upgradeInfo(scopedVersions.getLatestMinor(), versionRangeResult, dep);
                    }
                    if (DependencyEvaluator.versionDiffersFromCurrent(dep.getVersionString(), scopedVersions.getVeryLatest())) {
                        veryLatest = this.upgradeInfo(scopedVersions.getVeryLatest(), versionRangeResult, dep);
                    }
                    versionsToUpgrade.add(new ArtifactResult<ComponentUpgrade>((ArtifactRef)dep, latestConfigured, latestMinor, veryLatest));
                    continue;
                }
                LOG.debugf("  => no change", new Object[0]);
            }
            catch (RepositoryException e) {
                LOG.errorf("Could not resolve '%s'", (Object)rangeArtifact.toString());
            }
        }
        if (!this.configUpToDate) {
            LOG.warn("Configuration not up to date. Check the warnings above.");
        }
        this.sendDetectedUpgradesToExternalService(versionsToUpgrade);
        return versionsToUpgrade;
    }

    private ComponentUpgrade upgradeInfo(Optional<Version> version, VersionRangeResult versionRangeResult, ScopedArtifactRef artifactRef) {
        if (version.isPresent()) {
            String repoId = versionRangeResult.getRepository(version.get()).getId();
            LOG.infof("Found possible upgrade of '%s' to '%s' in repo '%s'", (Object)artifactRef, (Object)version.get(), (Object)repoId);
            LocalDateTime firstSeen = this.findComponentUpgradeDate(artifactRef, version.get().toString());
            return new ComponentUpgrade(artifactRef, version.get().toString(), repoId, firstSeen);
        }
        return null;
    }

    private static Artifact toVersionRangeArtifact(ArtifactRef ref) {
        return new DefaultArtifact(ref.getGroupId(), ref.getArtifactId(), null, "[" + ref.getVersionString() + ",)");
    }

    ArtifactResult<Version> findLatest(ScopedArtifactRef dependency, List<Restriction> restrictions, List<Version> availableVersions) {
        VersionPrefixRestriction prefixRestriction;
        if (restrictions.stream().anyMatch(r -> r instanceof NeverRestriction)) {
            return ArtifactResult.empty(dependency);
        }
        Optional<Restriction> prefixRestrictionOptional = restrictions.stream().filter(r -> r instanceof VersionPrefixRestriction).findFirst();
        boolean restrictedPrefix = prefixRestrictionOptional.isPresent();
        boolean restrictedStream = restrictions.stream().anyMatch(r -> r instanceof VersionStreamRestriction);
        String originalVersion = dependency.getVersionString();
        if (restrictedPrefix && !(prefixRestriction = (VersionPrefixRestriction)prefixRestrictionOptional.get()).applies(originalVersion, originalVersion)) {
            LOG.warnf("Existing dependency '%s' doesn't match configured prefix '%s'. Configuration probably needs to be updated.", (Object)dependency, (Object)prefixRestriction.getPrefixString());
            this.configUpToDate = false;
            return ArtifactResult.empty(dependency);
        }
        Stream<Object> latestConfiguredStream = availableVersions.stream();
        if (!restrictedPrefix && !restrictedStream) {
            latestConfiguredStream = latestConfiguredStream.filter(version -> DEFAULT_STREAM_RESTRICTION.applies(version.toString(), originalVersion));
        }
        for (Restriction restriction : restrictions) {
            latestConfiguredStream = latestConfiguredStream.filter(version -> restriction.applies(version.toString(), originalVersion));
        }
        Optional<Version> latestConfigured = latestConfiguredStream.max(VERSION_COMPARATOR).filter(version -> !version.toString().equals(dependency.getVersionString()));
        List restrictionSubset = restrictions.stream().filter(r -> !(r instanceof VersionPrefixRestriction) && !(r instanceof VersionStreamRestriction)).collect(Collectors.toList());
        Stream<Object> latestMinorStream = availableVersions.stream();
        for (Restriction restriction : restrictionSubset) {
            latestMinorStream = latestMinorStream.filter(version -> restriction.applies(version.toString(), originalVersion));
        }
        Optional<Version> latestMinor = latestMinorStream.filter(version -> new VersionStreamRestriction(VersionStream.MINOR).applies(version.toString(), originalVersion)).max(VERSION_COMPARATOR).filter(version -> !version.toString().equals(dependency.getVersionString())).filter(version -> !latestConfigured.isPresent() || !version.equals(latestConfigured.get()));
        Stream<Object> veryLatestStream = availableVersions.stream();
        for (Restriction restriction : restrictionSubset) {
            veryLatestStream = veryLatestStream.filter(version -> restriction.applies(version.toString(), originalVersion));
        }
        Optional<Version> veryLatest = veryLatestStream.max(VERSION_COMPARATOR).filter(version -> !version.toString().equals(dependency.getVersionString())).filter(version -> !(latestConfigured.isPresent() && version.equals(latestConfigured.get()) || latestMinor.isPresent() && version.equals(latestMinor.get())));
        return new ArtifactResult<Optional<Version>>((ArtifactRef)dependency, latestConfigured, latestMinor, veryLatest);
    }

    LocalDateTime findComponentUpgradeDate(ScopedArtifactRef dep, String newVersion) {
        if (this.loggerClient != null) {
            try {
                ComponentUpgradeDTO componentUpgrade = this.loggerClient.getFirst(this.configuration.getLogger().getProjectCode(), dep.getGroupId(), dep.getArtifactId(), newVersion);
                if (componentUpgrade != null) {
                    LOG.infof("Component upgrade to %s:%s:%s already seen at %s", dep.getGroupId(), dep.getArtifactId(), newVersion, componentUpgrade.created);
                    return componentUpgrade.created;
                }
            }
            catch (UpgradeNotFoundException e) {
                LOG.infof("Component upgrade to %s:%s:%s was not previously recorded", (Object)dep.getGroupId(), (Object)dep.getArtifactId(), (Object)newVersion);
            }
        }
        return null;
    }

    void sendDetectedUpgradesToExternalService(List<ArtifactResult<ComponentUpgrade>> componentUpgrades) {
        if (this.loggerClient == null) {
            LOG.info("Logger not configured. Discovered component upgrades will not be recorded.");
            return;
        }
        String projectCode = this.configuration.getLogger().getProjectCode();
        LOG.infof("Recording %d component upgrades under project '%s'", (Object)componentUpgrades.size(), (Object)projectCode);
        int batchSize = 30;
        int fromIndex = 0;
        do {
            int toIndex = Math.min(componentUpgrades.size(), fromIndex + 30);
            ArrayList<ComponentUpgradeDTO> dtos = new ArrayList<ComponentUpgradeDTO>();
            for (ArtifactResult<ComponentUpgrade> upgrades : componentUpgrades.subList(fromIndex, toIndex)) {
                upgrades.getLatestConfigured().ifPresent(u -> dtos.add(DependencyEvaluator.convertToDTO(projectCode, u)));
                upgrades.getLatestMinor().ifPresent(u -> dtos.add(DependencyEvaluator.convertToDTO(projectCode, u)));
                upgrades.getVeryLatest().ifPresent(u -> dtos.add(DependencyEvaluator.convertToDTO(projectCode, u)));
            }
            if (LOG.isEnabled(Logger.Level.DEBUG)) {
                try {
                    ObjectMapper objectMapper = new ObjectMapper();
                    String json = objectMapper.writeValueAsString(dtos);
                    LOG.debugf("Sending detected upgrades to %s (json length: %d):\n%s", (Object)this.configuration.getLogger().getUri(), (Object)json.length(), (Object)json);
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                }
            }
            this.loggerClient.create(dtos);
        } while ((fromIndex += 30) < componentUpgrades.size());
    }

    static ComponentUpgradeDTO convertToDTO(String projectCode, ComponentUpgrade componentUpgrade) {
        return new ComponentUpgradeDTO(projectCode, componentUpgrade.getArtifact().getGroupId(), componentUpgrade.getArtifact().getArtifactId(), componentUpgrade.getArtifact().getVersionString(), componentUpgrade.getNewVersion(), null);
    }

    static boolean versionDiffersFromCurrent(String current, Optional<Version> candidate) {
        return candidate.isPresent() && !current.equals(candidate.get().toString());
    }
}

