/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.model.Dependency;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.codehaus.mojo.versions.Property;
import org.codehaus.mojo.versions.api.ArtifactAssociation;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.UpdateScope;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractVersionsReportRenderer
extends AbstractMavenReportRenderer {
    protected final I18N i18n;
    protected final Locale locale;
    protected final String bundleName;

    public AbstractVersionsReportRenderer(Sink sink, String bundleName, I18N i18n, Locale locale) {
        super(sink);
        this.bundleName = bundleName;
        this.i18n = i18n;
        this.locale = locale;
    }

    public String getTitle() {
        return this.getText("report.title");
    }

    public String getText(String key) {
        return this.i18n.getString(this.bundleName, this.locale, key);
    }

    protected void renderWarningIcon() {
        this.sink.figure();
        this.sink.figureGraphics("images/icon_warning_sml.gif");
        this.sink.figure_();
    }

    protected void renderSuccessIcon() {
        this.sink.figure();
        this.sink.figureGraphics("images/icon_success_sml.gif");
        this.sink.figure_();
    }

    protected boolean equals(ArtifactVersion v1, ArtifactVersion v2) {
        return v1 == v2 || v1 != null && v1.equals(v2) || v1 != null && v2 != null && v1.toString().equals(v2.toString());
    }

    protected void renderDependencySummaryTableRow(Dependency dependency, ArtifactVersions details) {
        this.renderDependencySummaryTableRow(dependency, details, true, true, true);
    }

    protected void renderDependencySummaryTableRow(Dependency dependency, ArtifactVersions details, boolean includeScope, boolean includeClassifier, boolean includeType) {
        this.sink.tableRow();
        this.sink.tableCell();
        ArtifactVersion[] allUpdates = details.getAllUpdates(UpdateScope.ANY);
        if (allUpdates == null || allUpdates.length == 0) {
            this.renderSuccessIcon();
        } else {
            this.renderWarningIcon();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(dependency.getGroupId());
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(dependency.getArtifactId());
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(dependency.getVersion());
        this.sink.tableCell_();
        if (includeScope) {
            this.sink.tableCell();
            this.sink.text(dependency.getScope());
            this.sink.tableCell_();
        }
        if (includeClassifier) {
            this.sink.tableCell();
            this.sink.text(dependency.getClassifier());
            this.sink.tableCell_();
        }
        if (includeType) {
            this.sink.tableCell();
            this.sink.text(dependency.getType());
            this.sink.tableCell_();
        }
        this.sink.tableCell();
        if (details.getOldestUpdate(UpdateScope.SUBINCREMENTAL) != null) {
            this.safeBold();
            this.sink.text(details.getOldestUpdate(UpdateScope.SUBINCREMENTAL).toString());
            this.safeBold_();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        if (details.getOldestUpdate(UpdateScope.INCREMENTAL) != null) {
            this.safeBold();
            this.sink.text(details.getOldestUpdate(UpdateScope.INCREMENTAL).toString());
            this.safeBold_();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        if (details.getOldestUpdate(UpdateScope.MINOR) != null) {
            this.safeBold();
            this.sink.text(details.getOldestUpdate(UpdateScope.MINOR).toString());
            this.safeBold_();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        if (details.getOldestUpdate(UpdateScope.MAJOR) != null) {
            this.safeBold();
            this.sink.text(details.getOldestUpdate(UpdateScope.MAJOR).toString());
            this.safeBold_();
        }
        this.sink.tableCell_();
        this.sink.tableRow_();
    }

    protected void safeBold() {
        try {
            this.sink.bold();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    protected void safeBold_() {
        try {
            this.sink.bold_();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    protected void safeItalic() {
        try {
            this.sink.italic();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    protected void safeItalic_() {
        try {
            this.sink.italic_();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    protected void renderDependencySummaryTableHeader() {
        this.renderDependencySummaryTableHeader(true, true, true);
    }

    protected void renderDependencySummaryTableHeader(boolean includeScope, boolean includeClassifier, boolean includeType) {
        this.sink.tableRow();
        this.sink.tableHeaderCell();
        this.sink.text(this.getText("report.status"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.getText("report.groupId"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.getText("report.artifactId"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.getText("report.currentVersion"));
        this.sink.tableHeaderCell_();
        if (includeScope) {
            this.sink.tableHeaderCell();
            this.sink.text(this.getText("report.scope"));
            this.sink.tableHeaderCell_();
        }
        if (includeClassifier) {
            this.sink.tableHeaderCell();
            this.sink.text(this.getText("report.classifier"));
            this.sink.tableHeaderCell_();
        }
        if (includeType) {
            this.sink.tableHeaderCell();
            this.sink.text(this.getText("report.type"));
            this.sink.tableHeaderCell_();
        }
        this.sink.tableHeaderCell();
        this.sink.text(this.getText("report.nextVersion"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.getText("report.nextIncremental"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.getText("report.nextMinor"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.getText("report.nextMajor"));
        this.sink.tableHeaderCell_();
        this.sink.tableRow_();
    }

    protected void renderDependencyDetailTable(Dependency dependency, ArtifactVersions details) {
        this.renderDependencyDetailTable(dependency, details, true, true, true);
    }

    protected void renderDependencyDetailTable(Dependency dependency, ArtifactVersions details, boolean includeScope, boolean includeClassifier, boolean includeType) {
        SinkEventAttributeSet headerAttributes = new SinkEventAttributeSet();
        headerAttributes.addAttribute((Object)"width", (Object)"20%");
        SinkEventAttributeSet cellAttributes = new SinkEventAttributeSet();
        headerAttributes.addAttribute((Object)"width", (Object)"80%");
        this.sink.table();
        this.sink.tableRows(new int[]{2, 1}, false);
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.status"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        ArtifactVersion[] versions = details.getAllUpdates(UpdateScope.ANY);
        if (details.getOldestUpdate(UpdateScope.SUBINCREMENTAL) != null) {
            this.renderWarningIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.otherUpdatesAvailable"));
        } else if (details.getOldestUpdate(UpdateScope.INCREMENTAL) != null) {
            this.renderWarningIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.incrementalUpdatesAvailable"));
        } else if (details.getOldestUpdate(UpdateScope.MINOR) != null) {
            this.renderWarningIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.minorUpdatesAvailable"));
        } else if (details.getOldestUpdate(UpdateScope.MAJOR) != null) {
            this.renderWarningIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.majorUpdatesAvailable"));
        } else {
            this.renderSuccessIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.noUpdatesAvailable"));
        }
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.groupId"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        this.sink.text(dependency.getGroupId());
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.artifactId"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        this.sink.text(dependency.getArtifactId());
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.currentVersion"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        this.sink.text(dependency.getVersion());
        this.sink.tableCell_();
        this.sink.tableRow_();
        if (includeScope) {
            this.sink.tableRow();
            this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
            this.sink.text(this.getText("report.scope"));
            this.sink.tableHeaderCell_();
            this.sink.tableCell((SinkEventAttributes)cellAttributes);
            this.sink.text(dependency.getScope());
            this.sink.tableCell_();
            this.sink.tableRow_();
        }
        if (includeClassifier) {
            this.sink.tableRow();
            this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
            this.sink.text(this.getText("report.classifier"));
            this.sink.tableHeaderCell_();
            this.sink.tableCell((SinkEventAttributes)cellAttributes);
            this.sink.text(dependency.getClassifier());
            this.sink.tableCell_();
            this.sink.tableRow_();
        }
        if (includeType) {
            this.sink.tableRow();
            this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
            this.sink.text(this.getText("report.type"));
            this.sink.tableHeaderCell_();
            this.sink.tableCell((SinkEventAttributes)cellAttributes);
            this.sink.text(dependency.getType());
            this.sink.tableCell_();
            this.sink.tableRow_();
        }
        if (versions != null && versions.length > 0) {
            this.sink.tableRow();
            this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
            this.sink.text(this.getText("report.updateVersions"));
            this.sink.tableHeaderCell_();
            this.sink.tableCell((SinkEventAttributes)cellAttributes);
            for (int i = 0; i < versions.length; ++i) {
                boolean bold;
                if (i > 0) {
                    this.sink.lineBreak();
                }
                boolean bl = bold = this.equals(versions[i], details.getOldestUpdate(UpdateScope.SUBINCREMENTAL)) || this.equals(versions[i], details.getOldestUpdate(UpdateScope.INCREMENTAL)) || this.equals(versions[i], details.getNewestUpdate(UpdateScope.INCREMENTAL)) || this.equals(versions[i], details.getOldestUpdate(UpdateScope.MINOR)) || this.equals(versions[i], details.getNewestUpdate(UpdateScope.MINOR)) || this.equals(versions[i], details.getOldestUpdate(UpdateScope.MAJOR)) || this.equals(versions[i], details.getNewestUpdate(UpdateScope.MAJOR));
                if (bold) {
                    this.safeBold();
                }
                this.sink.text(versions[i].toString());
                if (!bold) continue;
                this.safeBold_();
                this.sink.nonBreakingSpace();
                this.safeItalic();
                if (this.equals(versions[i], details.getOldestUpdate(UpdateScope.SUBINCREMENTAL))) {
                    this.sink.text(this.getText("report.nextVersion"));
                } else if (this.equals(versions[i], details.getOldestUpdate(UpdateScope.INCREMENTAL))) {
                    this.sink.text(this.getText("report.nextIncremental"));
                } else if (this.equals(versions[i], details.getNewestUpdate(UpdateScope.INCREMENTAL))) {
                    this.sink.text(this.getText("report.latestIncremental"));
                } else if (this.equals(versions[i], details.getOldestUpdate(UpdateScope.MINOR))) {
                    this.sink.text(this.getText("report.nextMinor"));
                } else if (this.equals(versions[i], details.getNewestUpdate(UpdateScope.MINOR))) {
                    this.sink.text(this.getText("report.latestMinor"));
                } else if (this.equals(versions[i], details.getOldestUpdate(UpdateScope.MAJOR))) {
                    this.sink.text(this.getText("report.nextMajor"));
                } else if (this.equals(versions[i], details.getNewestUpdate(UpdateScope.MAJOR))) {
                    this.sink.text(this.getText("report.latestMajor"));
                }
                this.safeItalic_();
            }
            this.sink.tableCell_();
            this.sink.tableRow_();
        }
        this.sink.tableRows_();
        this.sink.table_();
    }

    protected void renderDependencySummaryTable(Map<Dependency, ArtifactVersions> map) {
        this.renderDependencySummaryTable(map, true, true, true);
    }

    protected void renderDependencySummaryTable(Map<Dependency, ArtifactVersions> map, boolean includeScope, boolean includeClassifier, boolean includeType) {
        this.sink.table();
        this.renderDependencySummaryTableHeader(includeScope, includeClassifier, includeType);
        for (Map.Entry<Dependency, ArtifactVersions> entry : map.entrySet()) {
            this.renderDependencySummaryTableRow(entry.getKey(), entry.getValue(), includeScope, includeClassifier, includeType);
        }
        this.renderDependencySummaryTableHeader(includeScope, includeClassifier, includeType);
        this.sink.table_();
    }

    protected void renderPropertySummaryTable(Map<Property, PropertyVersions> map) {
        this.sink.table();
        this.renderPropertySummaryTableHeader();
        for (Map.Entry<Property, PropertyVersions> entry : map.entrySet()) {
            this.renderPropertySummaryTableRow(entry.getKey(), entry.getValue());
        }
        this.renderPropertySummaryTableHeader();
        this.sink.table_();
    }

    protected void renderPropertySummaryTableRow(Property property, PropertyVersions versions) {
        this.sink.tableRow();
        this.sink.tableCell();
        if (versions.getAllUpdates(UpdateScope.ANY).length == 0) {
            this.renderSuccessIcon();
        } else {
            this.renderWarningIcon();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text("${" + property.getName() + "}");
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(versions.getCurrentVersion().toString());
        this.sink.tableCell_();
        this.sink.tableCell();
        if (versions.getOldestUpdate(UpdateScope.SUBINCREMENTAL) != null) {
            this.safeBold();
            this.sink.text(versions.getOldestUpdate(UpdateScope.SUBINCREMENTAL).toString());
            this.safeBold_();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        if (versions.getOldestUpdate(UpdateScope.INCREMENTAL) != null) {
            this.safeBold();
            this.sink.text(versions.getOldestUpdate(UpdateScope.INCREMENTAL).toString());
            this.safeBold_();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        if (versions.getOldestUpdate(UpdateScope.MINOR) != null) {
            this.safeBold();
            this.sink.text(versions.getOldestUpdate(UpdateScope.MINOR).toString());
            this.safeBold_();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        if (versions.getOldestUpdate(UpdateScope.MAJOR) != null) {
            this.safeBold();
            this.sink.text(versions.getOldestUpdate(UpdateScope.MAJOR).toString());
            this.safeBold_();
        }
        this.sink.tableCell_();
        this.sink.tableRow_();
    }

    protected void renderPropertySummaryTableHeader() {
        this.sink.tableRow();
        this.sink.tableHeaderCell();
        this.sink.text(this.getText("report.status"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.getText("report.property"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.getText("report.currentVersion"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.getText("report.nextVersion"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.getText("report.nextIncremental"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.getText("report.nextMinor"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.getText("report.nextMajor"));
        this.sink.tableHeaderCell_();
        this.sink.tableRow_();
    }

    protected void renderPropertyDetailTable(Property property, PropertyVersions versions) {
        SinkEventAttributeSet headerAttributes = new SinkEventAttributeSet();
        headerAttributes.addAttribute((Object)"width", (Object)"20%");
        SinkEventAttributeSet cellAttributes = new SinkEventAttributeSet();
        headerAttributes.addAttribute((Object)"width", (Object)"80%");
        this.sink.table();
        this.sink.tableRows(new int[]{2, 1}, false);
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.status"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        ArtifactVersion[] artifactVersions = versions.getAllUpdates(UpdateScope.ANY);
        Set<String> rangeVersions = this.getVersionsInRange(property, versions, artifactVersions);
        if (versions.getOldestUpdate(UpdateScope.SUBINCREMENTAL) != null) {
            this.renderWarningIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.otherUpdatesAvailable"));
        } else if (versions.getOldestUpdate(UpdateScope.INCREMENTAL) != null) {
            this.renderWarningIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.incrementalUpdatesAvailable"));
        } else if (versions.getOldestUpdate(UpdateScope.MINOR) != null) {
            this.renderWarningIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.minorUpdatesAvailable"));
        } else if (versions.getOldestUpdate(UpdateScope.MAJOR) != null) {
            this.renderWarningIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.majorUpdatesAvailable"));
        } else {
            this.renderSuccessIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.noUpdatesAvailable"));
        }
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.property"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        this.sink.text("${" + property.getName() + "}");
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.associations"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        ArtifactAssociation[] associations = versions.getAssociations();
        for (int i = 0; i < associations.length; ++i) {
            if (i > 0) {
                this.sink.lineBreak();
            }
            this.sink.text(ArtifactUtils.versionlessKey(associations[i].getArtifact()));
        }
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.currentVersion"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        this.sink.text(versions.getCurrentVersion().toString());
        this.sink.tableCell_();
        this.sink.tableRow_();
        if (artifactVersions.length > 0) {
            this.sink.tableRow();
            this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
            this.sink.text(this.getText("report.updateVersions"));
            this.sink.tableHeaderCell_();
            this.sink.tableCell((SinkEventAttributes)cellAttributes);
            boolean someNotAllowed = false;
            for (int i = 0; i < artifactVersions.length; ++i) {
                boolean bold;
                if (i > 0) {
                    this.sink.lineBreak();
                }
                boolean allowed = rangeVersions.contains(artifactVersions[i].toString());
                boolean bl = bold = this.equals(artifactVersions[i], versions.getOldestUpdate(UpdateScope.SUBINCREMENTAL)) || this.equals(artifactVersions[i], versions.getOldestUpdate(UpdateScope.INCREMENTAL)) || this.equals(artifactVersions[i], versions.getNewestUpdate(UpdateScope.INCREMENTAL)) || this.equals(artifactVersions[i], versions.getOldestUpdate(UpdateScope.MINOR)) || this.equals(artifactVersions[i], versions.getNewestUpdate(UpdateScope.MINOR)) || this.equals(artifactVersions[i], versions.getOldestUpdate(UpdateScope.MAJOR)) || this.equals(artifactVersions[i], versions.getNewestUpdate(UpdateScope.MAJOR));
                if (!allowed) {
                    this.sink.text("* ");
                    someNotAllowed = true;
                }
                if (allowed && bold) {
                    this.safeBold();
                }
                this.sink.text(artifactVersions[i].toString());
                if (!bold) continue;
                if (allowed) {
                    this.safeBold_();
                }
                this.sink.nonBreakingSpace();
                this.safeItalic();
                if (this.equals(artifactVersions[i], versions.getOldestUpdate(UpdateScope.SUBINCREMENTAL))) {
                    this.sink.text(this.getText("report.nextVersion"));
                } else if (this.equals(artifactVersions[i], versions.getOldestUpdate(UpdateScope.INCREMENTAL))) {
                    this.sink.text(this.getText("report.nextIncremental"));
                } else if (this.equals(artifactVersions[i], versions.getNewestUpdate(UpdateScope.INCREMENTAL))) {
                    this.sink.text(this.getText("report.latestIncremental"));
                } else if (this.equals(artifactVersions[i], versions.getOldestUpdate(UpdateScope.MINOR))) {
                    this.sink.text(this.getText("report.nextMinor"));
                } else if (this.equals(artifactVersions[i], versions.getNewestUpdate(UpdateScope.MINOR))) {
                    this.sink.text(this.getText("report.latestMinor"));
                } else if (this.equals(artifactVersions[i], versions.getOldestUpdate(UpdateScope.MAJOR))) {
                    this.sink.text(this.getText("report.nextMajor"));
                } else if (this.equals(artifactVersions[i], versions.getNewestUpdate(UpdateScope.MAJOR))) {
                    this.sink.text(this.getText("report.latestMajor"));
                }
                this.safeItalic_();
            }
            if (someNotAllowed) {
                this.sink.lineBreak();
                this.sink.lineBreak();
                this.sink.text("* ");
                this.safeItalic();
                this.sink.text(this.getText("report.excludedVersion"));
                this.safeItalic_();
            }
            this.sink.tableCell_();
            this.sink.tableRow_();
        }
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.versionRange"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        this.sink.text(StringUtils.isEmpty(property.getVersion()) ? "[,)" : property.getVersion());
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.autoLinkDependencies"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        this.sink.text(property.isAutoLinkDependencies() ? this.getText("report.yes") : this.getText("report.no"));
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.banSnapshots"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        this.sink.text(property.isBanSnapshots() ? this.getText("report.yes") : this.getText("report.no"));
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.searchReactor"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        this.sink.text(property.isSearchReactor() ? this.getText("report.yes") : this.getText("report.no"));
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.preferReactor"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        this.sink.text(property.isPreferReactor() ? this.getText("report.yes") : this.getText("report.no"));
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRows_();
        this.sink.table_();
    }

    private Set<String> getVersionsInRange(Property property, PropertyVersions versions, ArtifactVersion[] artifactVersions) {
        ArtifactVersion[] tmp;
        HashSet<String> rangeVersions = new HashSet<String>();
        if (property.getVersion() != null) {
            try {
                VersionRange range = VersionRange.createFromVersionSpec(property.getVersion());
                tmp = versions.getAllUpdates(range);
            }
            catch (InvalidVersionSpecificationException e) {
                tmp = artifactVersions;
            }
        } else {
            tmp = artifactVersions;
        }
        for (int i = 0; i < tmp.length; ++i) {
            rangeVersions.add(tmp[i].toString());
        }
        return rangeVersions;
    }
}

