/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Collection;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

@Mojo(name="use-dep-version", requiresProject=true, requiresDirectInvocation=true, threadSafe=true)
public class UseDepVersionMojo
extends AbstractVersionsDependencyUpdaterMojo {
    @Parameter(property="depVersion", required=true)
    protected String depVersion;
    @Parameter(property="forceVersion", defaultValue="false")
    protected boolean forceVersion;

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException, ArtifactMetadataRetrievalException {
        if (this.depVersion == null || this.depVersion.equals("")) {
            throw new IllegalArgumentException("depVersion must be supplied with use-specific-version, and cannot be blank.");
        }
        if (!this.forceVersion && !this.hasIncludes()) {
            throw new IllegalArgumentException("The use-specific-version goal is intended to be used with a single artifact. Please specify a value for the 'includes' parameter, or use -DforceVersion=true to override this check.");
        }
        try {
            if (this.getProject().getDependencyManagement() != null && this.isProcessingDependencyManagement()) {
                this.useDepVersion(pom, this.getProject().getDependencyManagement().getDependencies());
            }
            if (this.getProject().getDependencies() != null && this.isProcessingDependencies()) {
                this.useDepVersion(pom, this.getProject().getDependencies());
            }
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void useDepVersion(ModifiedPomXMLEventReader pom, Collection<Dependency> dependencies) throws MojoExecutionException, XMLStreamException, ArtifactMetadataRetrievalException {
        for (Dependency dep : dependencies) {
            ArtifactVersions versions;
            if (this.isExcludeReactor() && this.isProducedByReactor(dep)) {
                this.getLog().info("Ignoring reactor dependency: " + this.toString(dep));
                continue;
            }
            Artifact artifact = this.toArtifact(dep);
            if (!this.isIncluded(artifact)) continue;
            if (!this.forceVersion && !(versions = this.getHelper().lookupArtifactVersions(artifact, false)).containsVersion(this.depVersion)) {
                throw new MojoExecutionException(String.format("Version %s is not available for artifact %s:%s", this.depVersion, artifact.getGroupId(), artifact.getArtifactId()));
            }
            String version = dep.getVersion();
            if (!PomHelper.setDependencyVersion(pom, dep.getGroupId(), dep.getArtifactId(), version, this.depVersion, this.getProject().getModel())) continue;
            this.getLog().info("Updated " + this.toString(dep) + " to version " + this.depVersion);
        }
    }
}

