/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.utils;

import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.versions.utils.ContextualLog;
import org.codehaus.plexus.util.StringUtils;

public class DelegatingContextualLog
implements ContextualLog {
    private final Log delegate;
    private String currentContext = null;
    private boolean currentContextReportedDebug = false;
    private boolean currentContextReportedInfo = false;
    private boolean currentContextReportedWarn = false;
    private boolean currentContextReportedError = false;

    public DelegatingContextualLog(Log delegate) {
        this.delegate = delegate;
    }

    @Override
    public synchronized void setContext(String context) {
        if (StringUtils.equals(this.currentContext, context)) {
            return;
        }
        if (this.currentContext != null) {
            this.clearContext();
        }
        this.currentContext = context;
        this.currentContextReportedDebug = false;
        this.currentContextReportedInfo = false;
        this.currentContextReportedWarn = false;
        this.currentContextReportedError = false;
    }

    @Override
    public synchronized void clearContext() {
        if (this.currentContextReportedError) {
            this.delegate.error("");
        } else if (this.currentContextReportedWarn) {
            this.delegate.warn("");
        } else if (this.currentContextReportedInfo) {
            this.delegate.info("");
        } else if (this.currentContextReportedDebug) {
            this.delegate.debug("");
        }
        this.currentContextReportedDebug = false;
        this.currentContextReportedInfo = false;
        this.currentContextReportedWarn = false;
        this.currentContextReportedError = false;
    }

    private void enterContextDebug() {
        if (!(this.currentContextReportedDebug || this.currentContextReportedInfo || this.currentContextReportedWarn || this.currentContextReportedError)) {
            this.delegate.debug(this.currentContext);
            this.currentContextReportedDebug = true;
        }
    }

    private void enterContextInfo() {
        if (!(this.currentContextReportedInfo || this.currentContextReportedWarn || this.currentContextReportedError)) {
            this.delegate.info(this.currentContext);
            this.currentContextReportedInfo = true;
        }
    }

    private void enterContextWarn() {
        if (!this.currentContextReportedWarn && !this.currentContextReportedError) {
            this.delegate.warn(this.currentContext);
            this.currentContextReportedWarn = true;
        }
    }

    private void enterContextError() {
        if (!this.currentContextReportedError) {
            this.delegate.error(this.currentContext);
            this.currentContextReportedError = true;
        }
    }

    @Override
    public void debug(CharSequence charSequence) {
        this.enterContextDebug();
        this.delegate.debug(charSequence);
    }

    @Override
    public void debug(CharSequence charSequence, Throwable throwable) {
        this.enterContextDebug();
        this.delegate.debug(charSequence, throwable);
    }

    @Override
    public void debug(Throwable throwable) {
        this.enterContextDebug();
        this.delegate.debug(throwable);
    }

    @Override
    public void info(CharSequence charSequence) {
        this.enterContextInfo();
        this.delegate.info(charSequence);
    }

    @Override
    public void info(CharSequence charSequence, Throwable throwable) {
        this.enterContextInfo();
        this.delegate.info(charSequence, throwable);
    }

    @Override
    public void info(Throwable throwable) {
        this.enterContextInfo();
        this.delegate.info(throwable);
    }

    @Override
    public void warn(CharSequence charSequence) {
        this.enterContextWarn();
        this.delegate.warn(charSequence);
    }

    @Override
    public void warn(CharSequence charSequence, Throwable throwable) {
        this.enterContextWarn();
        this.delegate.warn(charSequence, throwable);
    }

    @Override
    public void warn(Throwable throwable) {
        this.enterContextWarn();
        this.delegate.warn(throwable);
    }

    @Override
    public void error(CharSequence charSequence) {
        this.enterContextError();
        this.delegate.error(charSequence);
    }

    @Override
    public void error(CharSequence charSequence, Throwable throwable) {
        this.enterContextError();
        this.delegate.error(charSequence, throwable);
    }

    @Override
    public void error(Throwable throwable) {
        this.enterContextError();
        this.delegate.error(throwable);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.delegate.isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.delegate.isErrorEnabled();
    }
}

