/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.ident.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleArtifactRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.atlas.ident.util.SnapshotUtils;
import org.commonjava.maven.atlas.ident.version.part.SnapshotPart;

public class ArtifactPathInfo {
    private static final String ARTIFACT_PATH_REGEX = "\\/?(([^\\/]+\\/)*[^\\/]+)\\/([^\\/]+)\\/(([^\\/]+)(-SNAPSHOT)?)\\/(\\3-((\\4)|(\\5-([0-9]{8}.[0-9]{6})-([0-9]+)))(-([^.]+))?(\\.(.+)))";
    private static final int GROUP_ID_GROUP = 1;
    private static final int ARTIFACT_ID_GROUP = 3;
    private static final int FILE_GROUP = 7;
    private static final int VERSION_GROUP = 8;
    private static final int NON_REMOTE_SNAP_CLASSIFIER_GROUP = 12;
    private static final int REMOTE_SNAP_CLASSIFIER_GROUP = 14;
    private static final int NON_REMOTE_SNAP_TYPE_GROUP = 14;
    private static final int REMOTE_SNAP_TYPE_GROUP = 16;
    private static final int REMOTE_SNAPSHOT_GROUP_COUNT = 16;
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String classifier;
    private final String type;
    private final String file;
    private final String fullPath;
    private final boolean isSnapshot;
    private SnapshotPart snapshotInfo;

    public static ArtifactPathInfo parse(String path) {
        String t;
        String c;
        if (path == null || path.length() < 1) {
            return null;
        }
        Matcher matcher = Pattern.compile(ARTIFACT_PATH_REGEX).matcher(path.replace('\\', '/'));
        if (!matcher.matches()) {
            return null;
        }
        int groupCount = matcher.groupCount();
        String g = matcher.group(1).replace('/', '.');
        String a = matcher.group(3);
        String v = matcher.group(8);
        if (groupCount == 16) {
            c = matcher.group(14);
            t = matcher.group(16);
        } else {
            c = matcher.group(12);
            t = matcher.group(14);
        }
        String f = matcher.group(7);
        return new ArtifactPathInfo(g, a, v, c, t, f, path);
    }

    public ArtifactPathInfo(String groupId, String artifactId, String version, String file, String fullPath) {
        this(groupId, artifactId, version, null, "jar", file, fullPath);
    }

    public ArtifactPathInfo(String groupId, String artifactId, String version, String classifier, String type, String file, String fullPath) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
        this.type = type;
        this.file = file;
        this.fullPath = fullPath;
        this.isSnapshot = SnapshotUtils.isSnapshotVersion(version);
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    public synchronized SnapshotPart getSnapshotInfo() {
        this.snapshotInfo = SnapshotUtils.extractSnapshotVersionPart(this.version);
        return this.snapshotInfo;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getType() {
        return this.type;
    }

    public String getFile() {
        return this.file;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public String toString() {
        return String.format("ArtifactPathInfo [groupId=%s, artifactId=%s, version=%s, file=%s]", this.groupId, this.artifactId, this.version, this.file);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactPathInfo other = (ArtifactPathInfo)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public ProjectVersionRef getProjectId() {
        return new SimpleProjectVersionRef(this.getGroupId(), this.getArtifactId(), this.getVersion());
    }

    public ArtifactRef getArtifact() {
        return new SimpleArtifactRef(this.getGroupId(), this.getArtifactId(), this.getVersion(), this.getType(), this.getClassifier());
    }
}

