/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.ident.version.part;

import java.io.Serializable;
import java.math.BigInteger;
import org.commonjava.maven.atlas.ident.version.part.SnapshotPart;
import org.commonjava.maven.atlas.ident.version.part.StringPart;
import org.commonjava.maven.atlas.ident.version.part.VersionPart;

public class NumericPart
extends VersionPart
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final NumericPart ZERO = new NumericPart(0L);
    private final BigInteger value;

    public NumericPart(String value) {
        this.value = BigInteger.valueOf(Long.parseLong(value));
    }

    public NumericPart(long value) {
        this.value = BigInteger.valueOf(value);
    }

    @Override
    public String renderStandard() {
        return this.value.toString();
    }

    public BigInteger getValue() {
        return this.value;
    }

    public String toString() {
        return String.format("NUM[%s]", this.value);
    }

    @Override
    public int compareTo(VersionPart part) {
        if (part instanceof StringPart) {
            return -1 * ((StringPart)part).compareTo(this);
        }
        if (part instanceof SnapshotPart) {
            return 1;
        }
        if (part instanceof NumericPart) {
            BigInteger other = ((NumericPart)part).getValue();
            return this.value.compareTo(other);
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumericPart other = (NumericPart)obj;
        return this.value.equals(other.value);
    }
}

