/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.common.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Profile;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.ManipulationUncheckedException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.session.MavenSessionHandler;
import org.commonjava.maven.ext.common.util.ProfileUtils;
import org.commonjava.maven.ext.common.util.WildcardMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class ProjectComparator {
    private static final Logger logger = LoggerFactory.getLogger(ProjectComparator.class);
    public static final String REPORT_NON_ALIGNED = "reportNonAligned";
    public static final String REPORT_OUTPUT_FILE = "reportOutputFile";
    private static final AtomicBoolean spacerLine = new AtomicBoolean();

    public static void compareProjects(MavenSessionHandler session, WildcardMap<ProjectVersionRef> dependencyRelocations, List<Project> originalProjects, List<Project> newProjects) throws ManipulationException {
        boolean reportNonAligned = Boolean.parseBoolean(session.getUserProperties().getProperty(REPORT_NON_ALIGNED, "false"));
        String reportOutputFile = session.getUserProperties().getProperty(REPORT_OUTPUT_FILE, "");
        StringBuilder builder = new StringBuilder(500);
        try {
            newProjects.forEach(newProject -> originalProjects.stream().filter(originalProject -> newProject.getArtifactId().equals(originalProject.getArtifactId()) && newProject.getGroupId().equals(originalProject.getGroupId())).forEach(originalProject -> {
                ProjectComparator.append(builder, "------------------- project {}", newProject.getKey().asProjectRef());
                if (!originalProject.getVersion().equals(newProject.getVersion())) {
                    ProjectComparator.append(builder, "\tProject version : {} ---> {}", originalProject.getVersion(), newProject.getVersion());
                    spacerLine.set(true);
                }
                ProjectComparator.injectSpacerLine(builder);
                newProject.getModel().getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(nKey, nValue) -> originalProject.getModel().getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(oKey, oValue) -> {
                    if (oKey != null && oKey.equals(nKey) && oValue != null && !oValue.equals(nValue)) {
                        ProjectComparator.append(builder, "\tProperty : key {} ; value {} ---> {}", oKey, oValue, nValue);
                        spacerLine.set(true);
                    }
                }))));
                ProjectComparator.injectSpacerLine(builder);
                ProjectComparator.compareDependencies(Type.DEPENDENCIES, builder, dependencyRelocations, reportNonAligned, ProjectComparator.handleDependencies(session, originalProject, null, Type.DEPENDENCIES), ProjectComparator.handleDependencies(session, newProject, null, Type.DEPENDENCIES));
                ProjectComparator.injectSpacerLine(builder);
                ProjectComparator.compareDependencies(Type.MANAGED_DEPENDENCIES, builder, dependencyRelocations, reportNonAligned, ProjectComparator.handleDependencies(session, originalProject, null, Type.MANAGED_DEPENDENCIES), ProjectComparator.handleDependencies(session, newProject, null, Type.MANAGED_DEPENDENCIES));
                ProjectComparator.injectSpacerLine(builder);
                ProjectComparator.compareDependencies(Type.DEPENDENCIES_UNVERSIONED, builder, dependencyRelocations, reportNonAligned, ProjectComparator.handleDependencies(session, originalProject, null, Type.DEPENDENCIES_UNVERSIONED), ProjectComparator.handleDependencies(session, newProject, null, Type.DEPENDENCIES_UNVERSIONED));
                ProjectComparator.injectSpacerLine(builder);
                ProjectComparator.comparePlugins(Type.PLUGINS, builder, reportNonAligned, ProjectComparator.handlePlugins(session, originalProject, null, Type.PLUGINS), ProjectComparator.handlePlugins(session, newProject, null, Type.PLUGINS));
                ProjectComparator.comparePlugins(Type.MANAGED_PLUGINS, builder, reportNonAligned, ProjectComparator.handlePlugins(session, originalProject, null, Type.MANAGED_PLUGINS), ProjectComparator.handlePlugins(session, newProject, null, Type.MANAGED_PLUGINS));
                List<Profile> oldProfiles = ProfileUtils.getProfiles(session, originalProject.getModel());
                List<Profile> newProfiles = ProfileUtils.getProfiles(session, newProject.getModel());
                newProfiles.forEach(newProfile -> oldProfiles.stream().filter(oldProfile -> newProfile.getId().equals(oldProfile.getId())).forEach(oldProfile -> {
                    newProfile.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(nKey, nValue) -> oldProfile.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(oKey, oValue) -> {
                        if (oKey != null && oKey.equals(nKey) && oValue != null && !oValue.equals(nValue)) {
                            ProjectComparator.append(builder, "\tProfile property : key {} ; value {} ---> {}", oKey, oValue, nValue);
                            spacerLine.set(true);
                        }
                    }))));
                    ProjectComparator.injectSpacerLine(builder);
                    ProjectComparator.compareDependencies(Type.PROFILE_DEPENDENCIES, builder, dependencyRelocations, reportNonAligned, ProjectComparator.handleDependencies(session, originalProject, oldProfile, Type.PROFILE_DEPENDENCIES), ProjectComparator.handleDependencies(session, newProject, newProfile, Type.PROFILE_DEPENDENCIES));
                    ProjectComparator.injectSpacerLine(builder);
                    ProjectComparator.compareDependencies(Type.PROFILE_MANAGED_DEPENDENCIES, builder, dependencyRelocations, reportNonAligned, ProjectComparator.handleDependencies(session, originalProject, oldProfile, Type.PROFILE_MANAGED_DEPENDENCIES), ProjectComparator.handleDependencies(session, newProject, newProfile, Type.PROFILE_MANAGED_DEPENDENCIES));
                    ProjectComparator.injectSpacerLine(builder);
                    ProjectComparator.compareDependencies(Type.PROFILE_DEPENDENCIES_UNVERSIONED, builder, dependencyRelocations, reportNonAligned, ProjectComparator.handleDependencies(session, originalProject, oldProfile, Type.PROFILE_DEPENDENCIES_UNVERSIONED), ProjectComparator.handleDependencies(session, newProject, newProfile, Type.PROFILE_DEPENDENCIES_UNVERSIONED));
                    ProjectComparator.injectSpacerLine(builder);
                    ProjectComparator.comparePlugins(Type.PROFILE_PLUGINS, builder, reportNonAligned, ProjectComparator.handlePlugins(session, originalProject, oldProfile, Type.PROFILE_PLUGINS), ProjectComparator.handlePlugins(session, newProject, newProfile, Type.PROFILE_PLUGINS));
                    ProjectComparator.injectSpacerLine(builder);
                    ProjectComparator.comparePlugins(Type.PROFILE_MANAGED_PLUGINS, builder, reportNonAligned, ProjectComparator.handlePlugins(session, originalProject, oldProfile, Type.PROFILE_MANAGED_PLUGINS), ProjectComparator.handlePlugins(session, newProject, newProfile, Type.PROFILE_MANAGED_PLUGINS));
                }));
            }));
            if (StringUtils.isNotEmpty(reportOutputFile)) {
                File report = new File(reportOutputFile);
                FileUtils.writeStringToFile(report, builder.toString(), Charset.defaultCharset());
            }
            logger.info(builder.toString());
        }
        catch (IOException | ManipulationUncheckedException e) {
            throw (ManipulationException)e.getCause();
        }
    }

    private static void compareDependencies(Type type, StringBuilder builder, WildcardMap<ProjectVersionRef> dependencyRelocations, boolean reportNonAligned, Set<ArtifactRef> originalDeps, Set<ArtifactRef> newDeps) {
        HashSet nonAligned = new HashSet();
        if (dependencyRelocations.size() > 0 && type == Type.PROFILE_DEPENDENCIES_UNVERSIONED || type == Type.DEPENDENCIES_UNVERSIONED) {
            originalDeps.forEach(originalDep -> {
                ProjectRef orig = originalDep.asProjectRef();
                if (dependencyRelocations.containsKey(orig)) {
                    ProjectVersionRef p = (ProjectVersionRef)dependencyRelocations.get(orig);
                    ProjectComparator.append(builder, "\tUnversioned relocation : {} ---> {}:{}:{}", originalDep, p.getGroupId(), p.getArtifactId().equals("*") ? orig.getArtifactId() : p.getArtifactId(), p.getVersionString());
                    spacerLine.set(true);
                }
            });
            ProjectComparator.injectSpacerLine(builder);
        } else {
            originalDeps.forEach(originalArtifact -> newDeps.stream().filter(newArtifact -> newArtifact.getGroupId().equals(originalArtifact.getGroupId()) && newArtifact.getArtifactId().equals(originalArtifact.getArtifactId()) && newArtifact.getType().equals(originalArtifact.getType()) && StringUtils.equals(newArtifact.getClassifier(), originalArtifact.getClassifier())).forEach(newArtifact -> {
                if (!newArtifact.getVersionString().equals(originalArtifact.getVersionString())) {
                    ProjectComparator.append(builder, "\t{} : {} --> {}", new Object[]{type, originalArtifact, newArtifact});
                    spacerLine.set(true);
                } else if (reportNonAligned) {
                    nonAligned.add(originalArtifact);
                }
            }));
            if (dependencyRelocations.size() > 0) {
                ProjectComparator.injectSpacerLine(builder);
                originalDeps.forEach(originalDep -> {
                    ProjectRef orig = originalDep.asProjectRef();
                    if (dependencyRelocations.containsKey(orig)) {
                        ProjectVersionRef p = (ProjectVersionRef)dependencyRelocations.get(orig);
                        ProjectComparator.append(builder, "\tRelocation : {} ---> {}:{}:{}", originalDep, p.getGroupId(), p.getArtifactId().equals("*") ? orig.getArtifactId() : p.getArtifactId(), p.getVersionString());
                        spacerLine.set(true);
                    }
                });
            }
        }
        if (nonAligned.size() > 0) {
            nonAligned.forEach(na -> ProjectComparator.append(builder, "\tNon-Aligned {} : {}", new Object[]{type, na}));
            builder.append(System.lineSeparator());
        }
    }

    private static void comparePlugins(Type type, StringBuilder builder, boolean reportNonAligned, Set<ProjectVersionRef> originalPlugins, Set<ProjectVersionRef> newPlugins) {
        HashSet nonAligned = new HashSet();
        AtomicBoolean spacerLine = new AtomicBoolean();
        originalPlugins.forEach(originalPVR -> newPlugins.stream().filter(newPVR -> newPVR.getGroupId().equals(originalPVR.getGroupId()) && newPVR.getArtifactId().equals(originalPVR.getArtifactId())).forEach(newArtifact -> {
            if (!newArtifact.getVersionString().equals(originalPVR.getVersionString())) {
                ProjectComparator.append(builder, "\t{} : {} --> {}", new Object[]{type, originalPVR, newArtifact});
                spacerLine.set(true);
            } else if (reportNonAligned) {
                nonAligned.add(originalPVR);
            }
        }));
        if (nonAligned.size() > 0) {
            nonAligned.forEach(pv -> ProjectComparator.append(builder, "\tNon-Aligned {} : {}", new Object[]{type, pv}));
            builder.append(System.lineSeparator());
        }
    }

    private static void injectSpacerLine(StringBuilder builder) {
        if (spacerLine.get()) {
            builder.append(System.lineSeparator());
            spacerLine.set(false);
        }
    }

    private static void append(StringBuilder builder, String message, Object ... args) {
        builder.append(MessageFormatter.arrayFormat(message, args).getMessage());
        builder.append(System.lineSeparator());
    }

    private static Set<ArtifactRef> handleDependencies(MavenSessionHandler session, Project project, Profile profile, Type type) throws ManipulationUncheckedException {
        try {
            switch (type) {
                case DEPENDENCIES: {
                    return project.getResolvedDependencies(session).keySet();
                }
                case MANAGED_DEPENDENCIES: {
                    return project.getResolvedManagedDependencies(session).keySet();
                }
                case PROFILE_DEPENDENCIES: {
                    return project.getResolvedProfileDependencies(session).getOrDefault(profile, Collections.emptyMap()).keySet();
                }
                case PROFILE_MANAGED_DEPENDENCIES: {
                    return project.getResolvedProfileManagedDependencies(session).getOrDefault(profile, Collections.emptyMap()).keySet();
                }
                case DEPENDENCIES_UNVERSIONED: {
                    return project.getAllResolvedDependencies(session).keySet().stream().filter(a -> a.getVersionString().equals("*")).collect(Collectors.toSet());
                }
                case PROFILE_DEPENDENCIES_UNVERSIONED: {
                    return project.getAllResolvedProfileDependencies(session).getOrDefault(profile, Collections.emptyMap()).keySet().stream().filter(a -> a.getVersionString().equals("*")).collect(Collectors.toSet());
                }
            }
            throw new ManipulationException("Invalid type " + type.toString(), new String[0]);
        }
        catch (ManipulationException e) {
            throw new ManipulationUncheckedException(e);
        }
    }

    private static Set<ProjectVersionRef> handlePlugins(MavenSessionHandler session, Project project, Profile profile, Type type) throws ManipulationUncheckedException {
        try {
            switch (type) {
                case PLUGINS: {
                    return project.getResolvedPlugins(session).keySet();
                }
                case MANAGED_PLUGINS: {
                    return project.getResolvedManagedPlugins(session).keySet();
                }
                case PROFILE_PLUGINS: {
                    return project.getResolvedProfilePlugins(session).getOrDefault(profile, Collections.emptyMap()).keySet();
                }
                case PROFILE_MANAGED_PLUGINS: {
                    return project.getResolvedProfileManagedPlugins(session).getOrDefault(profile, Collections.emptyMap()).keySet();
                }
            }
            throw new ManipulationException("Invalid type " + type.toString(), new String[0]);
        }
        catch (ManipulationException e) {
            throw new ManipulationUncheckedException(e);
        }
    }

    static enum Type {
        DEPENDENCIES,
        DEPENDENCIES_UNVERSIONED,
        MANAGED_DEPENDENCIES,
        PROFILE_DEPENDENCIES,
        PROFILE_DEPENDENCIES_UNVERSIONED,
        PROFILE_MANAGED_DEPENDENCIES,
        PLUGINS,
        MANAGED_PLUGINS,
        PROFILE_PLUGINS,
        PROFILE_MANAGED_PLUGINS;


        public String toString() {
            switch (this) {
                case DEPENDENCIES: {
                    return "Dependencies";
                }
                case DEPENDENCIES_UNVERSIONED: {
                    return "Non-versioned dependencies";
                }
                case MANAGED_DEPENDENCIES: {
                    return "Managed dependencies";
                }
                case PROFILE_DEPENDENCIES: {
                    return "Profile dependencies";
                }
                case PROFILE_DEPENDENCIES_UNVERSIONED: {
                    return "Profile non-versioned dependencies";
                }
                case PROFILE_MANAGED_DEPENDENCIES: {
                    return "Profile managed dependencies";
                }
                case PLUGINS: {
                    return "Plugins";
                }
                case MANAGED_PLUGINS: {
                    return "Managed plugins";
                }
                case PROFILE_PLUGINS: {
                    return "Profile plugins";
                }
                case PROFILE_MANAGED_PLUGINS: {
                    return "Profile managed plugins";
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

