/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomUtils;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.impl.Manipulator;
import org.commonjava.maven.ext.core.state.CommonState;
import org.commonjava.maven.ext.core.state.PluginState;
import org.commonjava.maven.ext.core.state.RESTState;
import org.commonjava.maven.ext.core.util.IdUtils;
import org.commonjava.maven.ext.core.util.PropertiesUtils;
import org.commonjava.maven.ext.core.util.PropertyMapper;
import org.commonjava.maven.ext.io.ModelIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="plugin-manipulator")
@Singleton
public class PluginManipulator
implements Manipulator {
    private ManipulationSession session;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ModelIO effectiveModelBuilder;
    private final Map<Project, Map<String, PropertyMapper>> versionPropertyUpdateMap = new LinkedHashMap<Project, Map<String, PropertyMapper>>();

    @Inject
    public PluginManipulator(ModelIO effectiveModelBuilder) {
        this.effectiveModelBuilder = effectiveModelBuilder;
    }

    @Override
    public void init(ManipulationSession session) throws ManipulationException {
        this.session = session;
        session.setState(new PluginState(session.getUserProperties()));
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects) throws ManipulationException {
        PluginState state = this.session.getState(PluginState.class);
        CommonState cState = this.session.getState(CommonState.class);
        if (!this.session.isEnabled() || !state.isEnabled()) {
            this.logger.debug(this.getClass().getSimpleName() + ": Nothing to do!");
            return Collections.emptySet();
        }
        HashSet<Project> changed = new HashSet<Project>();
        Set<Plugin> mgmtOverrides = this.loadRemoteBOM(PluginType.RemotePM);
        Set<Plugin> pluginOverrides = this.loadRemoteBOM(PluginType.RemoteP);
        for (Project project : projects) {
            Model model = project.getModel();
            if (!mgmtOverrides.isEmpty()) {
                this.apply(project, model, PluginType.RemotePM, mgmtOverrides);
                changed.add(project);
            }
            if (pluginOverrides.isEmpty()) continue;
            this.apply(project, model, PluginType.RemoteP, pluginOverrides);
            changed.add(project);
        }
        if (!changed.isEmpty()) {
            if (cState.getStrictDependencyPluginPropertyValidation() > 0) {
                this.logger.info("Iterating to validate plugin updates...");
                for (Project p : this.versionPropertyUpdateMap.keySet()) {
                    this.validatePluginsUpdatedProperty(cState, p, p.getResolvedManagedPlugins(this.session));
                    this.validatePluginsUpdatedProperty(cState, p, p.getResolvedPlugins(this.session));
                    for (Profile profile : p.getResolvedProfilePlugins(this.session).keySet()) {
                        this.validatePluginsUpdatedProperty(cState, p, p.getResolvedProfilePlugins(this.session).get(profile));
                    }
                    for (Profile profile : p.getResolvedProfileManagedPlugins(this.session).keySet()) {
                        this.validatePluginsUpdatedProperty(cState, p, p.getResolvedProfileManagedPlugins(this.session).get(profile));
                    }
                }
            }
            this.logger.info("Iterating for standard overrides...");
            for (Project project : this.versionPropertyUpdateMap.keySet()) {
                for (Map.Entry<String, PropertyMapper> entry : this.versionPropertyUpdateMap.get(project).entrySet()) {
                    PropertiesUtils.PropertyUpdate found = PropertiesUtils.updateProperties(this.session, project, true, entry.getKey(), entry.getValue().getNewVersion());
                    if (found != PropertiesUtils.PropertyUpdate.NOTFOUND) continue;
                    this.logger.info("Unable to find a property for {} to update", (Object)entry.getKey());
                    for (Project p : changed) {
                        if (!p.isInheritanceRoot()) continue;
                        this.logger.info("Adding property {} with {} ", (Object)entry.getKey(), (Object)entry.getValue().getNewVersion());
                        p.getModel().getProperties().setProperty(entry.getKey(), entry.getValue().getNewVersion());
                    }
                }
            }
        }
        return changed;
    }

    private Set<Plugin> loadRemoteBOM(PluginType type) throws ManipulationException {
        RESTState rState = this.session.getState(RESTState.class);
        PluginState pState = this.session.getState(PluginState.class);
        Set<Plugin> restOverrides = pState.getRemoteRESTOverrides();
        LinkedHashSet<Plugin> bomOverrides = new LinkedHashSet<Plugin>();
        List<ProjectVersionRef> gavs = pState.getRemotePluginMgmt();
        Set<Object> mergedOverrides = new LinkedHashSet();
        if (gavs != null) {
            Iterator<ProjectVersionRef> iter = gavs.iterator();
            Properties exclusions = (Properties)this.session.getUserProperties().clone();
            exclusions.putAll((Map<?, ?>)System.getProperties());
            while (iter.hasNext()) {
                ProjectVersionRef ref = iter.next();
                if (type == PluginType.RemotePM) {
                    bomOverrides.addAll(this.effectiveModelBuilder.getRemotePluginManagementVersionOverrides(ref, exclusions));
                    continue;
                }
                bomOverrides.addAll(this.effectiveModelBuilder.getRemotePluginVersionOverrides(ref, exclusions));
            }
        }
        if (type == PluginType.RemoteP) {
            if (pState.getPrecedence() != PluginState.PluginPrecedence.BOM) {
                this.logger.warn("Remote plugin alignment is only supported with precedence type of BOM");
            }
            mergedOverrides = bomOverrides;
        } else {
            if (pState.getPrecedence() == PluginState.PluginPrecedence.BOM && (mergedOverrides = bomOverrides).isEmpty()) {
                String msg = rState.isEnabled() ? "pluginSource for restURL" : "pluginManagement";
                this.logger.warn("No dependencies found for pluginSource {}. Has {} been configured? ", (Object)pState.getPrecedence(), (Object)msg);
            }
            if (pState.getPrecedence() == PluginState.PluginPrecedence.REST) {
                mergedOverrides = restOverrides;
                if (mergedOverrides.isEmpty()) {
                    this.logger.warn("No dependencies found for pluginSource {}. Has restURL been configured? ", (Object)pState.getPrecedence());
                }
            } else if (pState.getPrecedence() == PluginState.PluginPrecedence.RESTBOM) {
                mergedOverrides = restOverrides;
                mergedOverrides.addAll(bomOverrides);
            } else if (pState.getPrecedence() == PluginState.PluginPrecedence.BOMREST) {
                mergedOverrides = bomOverrides;
                mergedOverrides.addAll(restOverrides);
            }
        }
        this.logger.debug("Final remote override list for type {} with precedence {} is {}", new Object[]{type.toString(), pState.getPrecedence(), mergedOverrides});
        return mergedOverrides;
    }

    private void apply(Project project, Model model, PluginType type, Set<Plugin> override) throws ManipulationException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Applying plugin changes for {} to: {} ", (Object)type, (Object)IdUtils.ga(project));
        }
        if (project.isInheritanceRoot()) {
            PluginManagement pluginManagement;
            Build build = model.getBuild();
            if (build == null) {
                build = new Build();
                model.setBuild(build);
                this.logger.debug("Created new Build for model {}", (Object)model.getId());
            }
            if ((pluginManagement = model.getBuild().getPluginManagement()) == null) {
                pluginManagement = new PluginManagement();
                model.getBuild().setPluginManagement(pluginManagement);
                this.logger.debug("Created new Plugin Management for model {}", (Object)model.getId());
            }
            this.applyOverrides(project, type, PluginType.LocalPM, project.getResolvedManagedPlugins(this.session), override);
        }
        this.applyOverrides(project, type, PluginType.LocalP, project.getResolvedPlugins(this.session), override);
        Map<Profile, Map<ProjectVersionRef, Plugin>> pd = project.getResolvedProfilePlugins(this.session);
        Map<Profile, Map<ProjectVersionRef, Plugin>> pmd = project.getResolvedProfileManagedPlugins(this.session);
        this.logger.debug("Processing profiles with plugin management");
        for (Profile p : pmd.keySet()) {
            this.applyOverrides(project, type, PluginType.LocalPM, pmd.get(p), override);
        }
        this.logger.debug("Processing profiles with plugins");
        for (Profile p : pd.keySet()) {
            this.applyOverrides(project, type, PluginType.LocalP, pd.get(p), override);
        }
    }

    private void applyOverrides(Project project, PluginType remotePluginType, PluginType localPluginType, Map<ProjectVersionRef, Plugin> plugins, Set<Plugin> pluginVersionOverrides) throws ManipulationException {
        if (plugins == null) {
            throw new ManipulationException("Original plugins should not be null", new String[0]);
        }
        PluginState pluginState = this.session.getState(PluginState.class);
        CommonState commonState = this.session.getState(CommonState.class);
        LinkedHashMap<String, ProjectVersionRef> pluginsByGA = new LinkedHashMap<String, ProjectVersionRef>();
        for (ProjectVersionRef pvr : plugins.keySet()) {
            pluginsByGA.put(pvr.asProjectRef().toString(), pvr);
        }
        for (Plugin override : pluginVersionOverrides) {
            Plugin plugin = null;
            String newValue = override.getVersion();
            if (pluginsByGA.containsKey(override.getKey())) {
                String oldValue = ((ProjectVersionRef)((HashMap)pluginsByGA).get(override.getKey())).getVersionString();
                plugin = plugins.get(((HashMap)pluginsByGA).get(override.getKey()));
                if (plugin.getVersion().equals("${project.version}") || plugin.getVersion().contains("$") && project.getVersion().equals(oldValue)) {
                    this.logger.warn("Plugin {} for {} references ${project.version} so skipping.", (Object)plugin, (Object)project.getPom());
                } else if (commonState.isStrict() && !PropertiesUtils.checkStrictValue(this.session, oldValue, newValue)) {
                    if (commonState.isFailOnStrictViolation()) {
                        throw new ManipulationException("Plugin reference {} replacement: {} of original version: {} violates the strict version-alignment rule!", plugin.getId(), newValue, oldValue);
                    }
                    this.logger.warn("Plugin reference {} replacement: {} of original version: {} violates the strict version-alignment rule!", plugin.getId(), newValue, oldValue);
                    continue;
                }
            }
            this.logger.debug("Plugin override {} and local plugin {} with remotePluginType {} / localPluginType {}", new Object[]{override.getId(), plugin, remotePluginType, localPluginType});
            if (plugin != null) {
                String oldVersion;
                if (localPluginType == PluginType.LocalPM) {
                    if (override.getConfiguration() != null) {
                        this.logger.debug("Injecting plugin configuration {}", override.getConfiguration());
                        if (plugin.getConfiguration() == null) {
                            plugin.setConfiguration(override.getConfiguration());
                            this.logger.debug("Altered plugin configuration: {}={}", (Object)plugin.getKey(), plugin.getConfiguration());
                        } else if (plugin.getConfiguration() != null) {
                            this.logger.debug("Existing plugin configuration: {}", plugin.getConfiguration());
                            if (!(plugin.getConfiguration() instanceof Xpp3Dom) || !(override.getConfiguration() instanceof Xpp3Dom)) {
                                throw new ManipulationException("Incorrect DOM type " + plugin.getConfiguration().getClass().getName() + " and" + override.getConfiguration().getClass().getName(), new String[0]);
                            }
                            if (pluginState.getConfigPrecedence() == PluginState.Precedence.REMOTE) {
                                plugin.setConfiguration(Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)override.getConfiguration(), (Xpp3Dom)plugin.getConfiguration()));
                            } else if (pluginState.getConfigPrecedence() == PluginState.Precedence.LOCAL) {
                                plugin.setConfiguration(Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)plugin.getConfiguration(), (Xpp3Dom)override.getConfiguration()));
                            }
                            this.logger.debug("Altered plugin configuration: {}={}", (Object)plugin.getKey(), plugin.getConfiguration());
                        }
                    } else {
                        this.logger.debug("No remote configuration to inject from {}", (Object)override.toString());
                    }
                    if (override.getExecutions() != null) {
                        Map<String, PluginExecution> newExecutions = override.getExecutionsAsMap();
                        Map<String, PluginExecution> originalExecutions = plugin.getExecutionsAsMap();
                        for (PluginExecution pe : newExecutions.values()) {
                            if (originalExecutions.containsKey(pe.getId())) {
                                this.logger.warn("Unable to inject execution {} as it clashes with an existing execution", (Object)pe.getId());
                                continue;
                            }
                            this.logger.debug("Injecting execution {} ", (Object)pe);
                            plugin.getExecutions().add(pe);
                        }
                    } else {
                        this.logger.debug("No remote executions to inject from {}", (Object)override.toString());
                    }
                    if (!override.getDependencies().isEmpty()) {
                        this.logger.debug("Checking original plugin dependencies versus override");
                        Iterator<Dependency> originalIt = plugin.getDependencies().iterator();
                        block3: while (originalIt.hasNext()) {
                            Dependency originalD = originalIt.next();
                            for (Dependency newD : override.getDependencies()) {
                                if (!originalD.getGroupId().equals(newD.getGroupId()) || !originalD.getArtifactId().equals(newD.getArtifactId())) continue;
                                this.logger.debug("Removing original dependency {} in favour of {} ", (Object)originalD, (Object)newD);
                                originalIt.remove();
                                continue block3;
                            }
                        }
                        this.logger.debug("Adding in plugin dependencies {}", (Object)override.getDependencies());
                        plugin.getDependencies().addAll(override.getDependencies());
                    }
                }
                if (PropertiesUtils.cacheProperty(project, commonState, this.versionPropertyUpdateMap, oldVersion = plugin.getVersion(), newValue, plugin, false)) continue;
                if (oldVersion != null && oldVersion.equals("${project.version}")) {
                    this.logger.debug("For plugin {} ; version is built in {} so skipping inlining {}", plugin, oldVersion, newValue);
                    continue;
                }
                if (oldVersion != null && oldVersion.contains("${")) {
                    throw new ManipulationException("NYI : Multiple embedded properties for plugins.", new String[0]);
                }
                plugin.setVersion(newValue);
                this.logger.info("Altered plugin version: {}={}", (Object)override.getKey(), (Object)newValue);
                continue;
            }
            if (remotePluginType == PluginType.RemotePM && localPluginType == PluginType.LocalPM && commonState.isOverrideTransitive() && (override.getConfiguration() != null || override.getExecutions().size() > 0)) {
                project.getModel().getBuild().getPluginManagement().getPlugins().add(override);
                this.logger.info("Added plugin version: {}={}", (Object)override.getKey(), (Object)newValue);
                continue;
            }
            if (remotePluginType != PluginType.RemoteP || localPluginType != PluginType.LocalP || !pluginState.getInjectRemotePlugins() || override.getConfiguration() == null && override.getExecutions().size() <= 0) continue;
            project.getModel().getBuild().getPlugins().add(override);
            this.logger.info("For non-pluginMgmt, added plugin version : {}={}", (Object)override.getKey(), (Object)newValue);
        }
    }

    private void validatePluginsUpdatedProperty(CommonState cState, Project p, Map<ProjectVersionRef, Plugin> dependencies) throws ManipulationException {
        for (ProjectVersionRef d : dependencies.keySet()) {
            String versionProperty = dependencies.get(d).getVersion();
            if (!versionProperty.startsWith("${")) continue;
            versionProperty = PropertiesUtils.extractPropertyName(versionProperty);
            PropertiesUtils.verifyPropertyMapping(cState, p, this.versionPropertyUpdateMap, d, versionProperty);
        }
    }

    @Override
    public int getExecutionIndex() {
        return 35;
    }

    private static enum PluginType {
        RemotePM,
        RemoteP,
        LocalPM,
        LocalP;


        public String toString() {
            switch (this) {
                case RemotePM: {
                    return "RemotePluginManagement";
                }
                case RemoteP: {
                    return "Plugins";
                }
                case LocalPM: {
                    return "LocalPluginManagement";
                }
                case LocalP: {
                    return "LocalPlugins";
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

