/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.internal.xfer;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.TransferManager;
import org.commonjava.maven.galley.event.EventMetadata;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.Resource;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.model.VirtualResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BatchRetriever
implements Callable<BatchRetriever> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final TransferManager xfer;
    private final List<ConcreteResource> resources;
    private int tries = 0;
    private Transfer transfer;
    private TransferException error;
    private ConcreteResource lastTry;
    private final boolean suppressFailures;
    private final Resource rootResource;
    private final EventMetadata eventMetadata;

    public BatchRetriever(TransferManager xfer, Resource resource, boolean suppressFailures, EventMetadata eventMetadata) {
        this.xfer = xfer;
        this.suppressFailures = suppressFailures;
        this.rootResource = resource;
        this.eventMetadata = eventMetadata;
        this.resources = resource instanceof ConcreteResource ? Collections.singletonList((ConcreteResource)resource) : ((VirtualResource)resource).toConcreteResources();
    }

    @Override
    public BatchRetriever call() {
        String oldThreadName;
        block5: {
            oldThreadName = Thread.currentThread().getName();
            Thread.currentThread().setName("BATCH-TRY#" + this.tries + "@" + this.rootResource);
            if (this.hasMoreTries()) break block5;
            this.logger.debug("Out of tries for: {}. Last try was: {}. Returning.", (Object)this.rootResource, (Object)this.lastTry);
            BatchRetriever batchRetriever = this;
            this.logger.debug("Try #{} finishing up for: {}. Last try was: {}", this.tries, this.rootResource, this.lastTry);
            ++this.tries;
            Thread.currentThread().setName(oldThreadName);
            return batchRetriever;
        }
        try {
            this.lastTry = this.resources.get(this.tries);
            this.logger.debug("Try #{} in {}: {}", this.tries, this.rootResource, this.lastTry);
            this.transfer = this.xfer.retrieve(this.lastTry, this.suppressFailures, this.eventMetadata);
        }
        catch (TransferException e) {
            try {
                this.error = e;
            }
            catch (Throwable throwable) {
                this.logger.debug("Try #{} finishing up for: {}. Last try was: {}", this.tries, this.rootResource, this.lastTry);
                ++this.tries;
                Thread.currentThread().setName(oldThreadName);
                throw throwable;
            }
            this.logger.debug("Try #{} finishing up for: {}. Last try was: {}", this.tries, this.rootResource, this.lastTry);
            ++this.tries;
            Thread.currentThread().setName(oldThreadName);
        }
        this.logger.debug("Try #{} finishing up for: {}. Last try was: {}", this.tries, this.rootResource, this.lastTry);
        ++this.tries;
        Thread.currentThread().setName(oldThreadName);
        return this;
    }

    public boolean hasMoreTries() {
        return this.resources.size() > this.tries;
    }

    public ConcreteResource getLastTry() {
        return this.lastTry;
    }

    public TransferException getError() {
        return this.error;
    }

    public Transfer getTransfer() {
        return this.transfer;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rootResource == null ? 0 : this.rootResource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BatchRetriever other = (BatchRetriever)obj;
        if (this.rootResource == null) {
            return other.rootResource == null;
        }
        return this.rootResource.equals(other.rootResource);
    }

    public String toString() {
        return String.format("BatchRetriever [executed tries=%s, lastTry=%s, rootResource=%s]", this.tries, this.lastTry, this.rootResource);
    }
}

