/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.model;

import java.util.Arrays;
import java.util.TreeSet;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.Location;

public class ListingResult {
    private final ConcreteResource resource;
    private final String[] listing;

    public ListingResult(ConcreteResource resource, String[] listing) {
        this.resource = resource;
        this.listing = listing;
    }

    public Location getLocation() {
        return this.resource.getLocation();
    }

    public String getPath() {
        return this.resource.getPath();
    }

    public ConcreteResource getResource() {
        return this.resource;
    }

    public String[] getListing() {
        return this.listing;
    }

    public boolean isEmpty() {
        return this.listing == null || this.listing.length == 0;
    }

    public ListingResult mergeWith(ListingResult remoteResult) {
        TreeSet<String> merged = new TreeSet<String>();
        if (!this.isEmpty()) {
            merged.addAll(Arrays.asList(this.listing));
        }
        if (!remoteResult.isEmpty()) {
            merged.addAll(Arrays.asList(remoteResult.getListing()));
        }
        return new ListingResult(this.resource, merged.toArray(new String[merged.size()]));
    }
}

