/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.time.MonotonicClock;
import org.eclipse.jgit.util.time.MonotonicSystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SystemReader {
    private static final Logger LOG = LoggerFactory.getLogger(SystemReader.class);
    private static final SystemReader DEFAULT;
    private static Boolean isMacOS;
    private static Boolean isWindows;
    private static volatile SystemReader INSTANCE;
    private ObjectChecker platformChecker;
    private AtomicReference<FileBasedConfig> systemConfig = new AtomicReference();
    private AtomicReference<FileBasedConfig> userConfig = new AtomicReference();

    static {
        Default r = new Default();
        super.init();
        INSTANCE = DEFAULT = r;
    }

    public static SystemReader getInstance() {
        return INSTANCE;
    }

    public static void setInstance(SystemReader newReader) {
        isMacOS = null;
        isWindows = null;
        if (newReader == null) {
            INSTANCE = DEFAULT;
        } else {
            newReader.init();
            INSTANCE = newReader;
        }
    }

    private void init() {
        if (this.platformChecker == null) {
            this.setPlatformChecker();
        }
    }

    protected final void setPlatformChecker() {
        this.platformChecker = new ObjectChecker().setSafeForWindows(this.isWindows()).setSafeForMacOS(this.isMacOS());
    }

    public abstract String getHostname();

    public abstract String getenv(String var1);

    public abstract String getProperty(String var1);

    public abstract FileBasedConfig openUserConfig(Config var1, FS var2);

    public abstract FileBasedConfig openSystemConfig(Config var1, FS var2);

    public StoredConfig getUserConfig() throws IOException, ConfigInvalidException {
        FileBasedConfig c = this.userConfig.get();
        if (c == null) {
            this.userConfig.compareAndSet(null, this.openUserConfig(this.getSystemConfig(), FS.DETECTED));
            c = this.userConfig.get();
        } else {
            this.getSystemConfig();
        }
        if (c.isOutdated()) {
            LOG.debug("loading user config {}", (Object)this.userConfig);
            c.load();
        }
        return c;
    }

    public StoredConfig getSystemConfig() throws IOException, ConfigInvalidException {
        FileBasedConfig c = this.systemConfig.get();
        if (c == null) {
            this.systemConfig.compareAndSet(null, this.openSystemConfig(null, FS.DETECTED));
            c = this.systemConfig.get();
        }
        if (c.isOutdated()) {
            LOG.debug("loading system config {}", (Object)this.systemConfig);
            c.load();
        }
        return c;
    }

    public abstract long getCurrentTime();

    public MonotonicClock getClock() {
        return new MonotonicSystemClock();
    }

    public abstract int getTimezone(long var1);

    public TimeZone getTimeZone() {
        return TimeZone.getDefault();
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public SimpleDateFormat getSimpleDateFormat(String pattern) {
        return new SimpleDateFormat(pattern);
    }

    public SimpleDateFormat getSimpleDateFormat(String pattern, Locale locale) {
        return new SimpleDateFormat(pattern, locale);
    }

    public DateFormat getDateTimeInstance(int dateStyle, int timeStyle) {
        return DateFormat.getDateTimeInstance(dateStyle, timeStyle);
    }

    public boolean isWindows() {
        if (isWindows == null) {
            String osDotName = this.getOsName();
            isWindows = osDotName.startsWith("Windows");
        }
        return isWindows;
    }

    public boolean isMacOS() {
        if (isMacOS == null) {
            String osDotName = this.getOsName();
            isMacOS = "Mac OS X".equals(osDotName) || "Darwin".equals(osDotName);
        }
        return isMacOS;
    }

    private String getOsName() {
        return AccessController.doPrivileged(() -> this.getProperty("os.name"));
    }

    public void checkPath(String path) throws CorruptObjectException {
        this.platformChecker.checkPath(path);
    }

    public void checkPath(byte[] path) throws CorruptObjectException {
        this.platformChecker.checkPath(path, 0, path.length);
    }

    private static class Default
    extends SystemReader {
        private volatile String hostname;

        private Default() {
        }

        @Override
        public String getenv(String variable) {
            return System.getenv(variable);
        }

        @Override
        public String getProperty(String key) {
            return System.getProperty(key);
        }

        @Override
        public FileBasedConfig openSystemConfig(Config parent, FS fs) {
            File configFile;
            if (StringUtils.isEmptyOrNull(this.getenv("GIT_CONFIG_NOSYSTEM")) && (configFile = fs.getGitSystemConfig()) != null) {
                return new FileBasedConfig(parent, configFile, fs);
            }
            return new FileBasedConfig(parent, null, fs){

                @Override
                public void load() {
                }

                @Override
                public boolean isOutdated() {
                    return false;
                }
            };
        }

        @Override
        public FileBasedConfig openUserConfig(Config parent, FS fs) {
            return new FileBasedConfig(parent, new File(fs.userHome(), ".gitconfig"), fs);
        }

        @Override
        public String getHostname() {
            if (this.hostname == null) {
                try {
                    InetAddress localMachine = InetAddress.getLocalHost();
                    this.hostname = localMachine.getCanonicalHostName();
                }
                catch (UnknownHostException e) {
                    this.hostname = "localhost";
                }
                assert (this.hostname != null);
            }
            return this.hostname;
        }

        @Override
        public long getCurrentTime() {
            return System.currentTimeMillis();
        }

        @Override
        public int getTimezone(long when) {
            return this.getTimeZone().getOffset(when) / 60000;
        }
    }
}

