/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;

public class PartialResponse
extends Response
implements Serializable {
    private InputStream entityStream;
    private final transient ClientResponseContext responseContext;

    PartialResponse(ClientResponseContext responseContext) {
        this.responseContext = responseContext;
        this.entityStream = responseContext.getEntityStream();
    }

    @Override
    public int getStatus() {
        return this.responseContext.getStatus();
    }

    @Override
    public Response.StatusType getStatusInfo() {
        return this.responseContext.getStatusInfo();
    }

    @Override
    public Object getEntity() {
        throw this.notSupported();
    }

    private RuntimeException notSupported() {
        RuntimeException ex = new RuntimeException("method call not supported");
        return ex;
    }

    @Override
    public synchronized <T> T readEntity(Class<T> entityType) {
        if (entityType.isAssignableFrom(String.class)) {
            return (T)PartialResponse.readStringEntity(this.entityStream);
        }
        throw this.notSupported();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readStringEntity(InputStream input) {
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            String string = buffer.lines().collect(Collectors.joining("\n"));
            return string;
        }
        catch (IOException e) {
            throw new WebApplicationException("Failed to read entity", e);
        }
    }

    @Override
    public <T> T readEntity(GenericType<T> entityType) {
        throw this.notSupported();
    }

    @Override
    public <T> T readEntity(Class<T> entityType, Annotation[] annotations) {
        throw this.notSupported();
    }

    @Override
    public <T> T readEntity(GenericType<T> entityType, Annotation[] annotations) {
        throw this.notSupported();
    }

    @Override
    public boolean hasEntity() {
        return this.responseContext.hasEntity();
    }

    @Override
    public synchronized boolean bufferEntity() {
        try {
            byte[] buffer = new byte[4096];
            int read = 0;
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            while ((read = this.entityStream.read(buffer)) >= 0) {
                outStream.write(buffer, 0, read);
            }
            this.entityStream = new ByteArrayInputStream(outStream.toByteArray());
            return true;
        }
        catch (Exception any) {
            return false;
        }
    }

    @Override
    public synchronized void close() {
        try {
            this.responseContext.getEntityStream().close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public MediaType getMediaType() {
        return this.responseContext.getMediaType();
    }

    @Override
    public Locale getLanguage() {
        return this.responseContext.getLanguage();
    }

    @Override
    public int getLength() {
        return this.responseContext.getLength();
    }

    @Override
    public Set<String> getAllowedMethods() {
        return this.responseContext.getAllowedMethods();
    }

    @Override
    public Map<String, NewCookie> getCookies() {
        return this.responseContext.getCookies();
    }

    @Override
    public EntityTag getEntityTag() {
        return this.responseContext.getEntityTag();
    }

    @Override
    public Date getDate() {
        return this.responseContext.getDate();
    }

    @Override
    public Date getLastModified() {
        return this.responseContext.getLastModified();
    }

    @Override
    public URI getLocation() {
        return this.responseContext.getLocation();
    }

    @Override
    public Set<Link> getLinks() {
        return this.responseContext.getLinks();
    }

    @Override
    public boolean hasLink(String relation) {
        return this.responseContext.hasLink(relation);
    }

    @Override
    public Link getLink(String relation) {
        return this.responseContext.getLink(relation);
    }

    @Override
    public Link.Builder getLinkBuilder(String relation) {
        throw new RuntimeException("method call not supported");
    }

    @Override
    public MultivaluedMap<String, Object> getMetadata() {
        return this.responseContext.getHeaders();
    }

    @Override
    public MultivaluedMap<String, String> getStringHeaders() {
        return this.responseContext.getHeaders();
    }

    @Override
    public String getHeaderString(String name) {
        return this.responseContext.getHeaderString(name);
    }
}

