/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.mavendependencyupdater;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.repository.internal.DefaultArtifactDescriptorReader;
import org.apache.maven.repository.internal.DefaultVersionRangeResolver;
import org.apache.maven.repository.internal.DefaultVersionResolver;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.repository.internal.SnapshotMetadataGeneratorFactory;
import org.apache.maven.repository.internal.VersionsMetadataGeneratorFactory;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.impl.MetadataGeneratorFactory;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.jboss.logging.Logger;
import org.jboss.set.mavendependencyupdater.AvailableVersionsResolver;
import org.jboss.set.mavendependencyupdater.configuration.Configuration;

public class DefaultAvailableVersionsResolver
implements AvailableVersionsResolver {
    private static final Logger LOG = Logger.getLogger(DefaultAvailableVersionsResolver.class);
    private RepositorySystem system = DefaultAvailableVersionsResolver.newRepositorySystem();
    private DefaultRepositorySystemSession session = DefaultAvailableVersionsResolver.newRepositorySystemSession(this.system);
    private List<RemoteRepository> repositories;

    public DefaultAvailableVersionsResolver(Configuration configuration) {
        this.repositories = DefaultAvailableVersionsResolver.newRemoteRepositoryList(configuration.getRepositories());
    }

    @Override
    public VersionRangeResult resolveVersionRange(Artifact artifact) throws RepositoryException {
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact(artifact);
        rangeRequest.setRepositories(this.repositories);
        VersionRangeResult rangeResult = this.system.resolveVersionRange(this.session, rangeRequest);
        if (LOG.isDebugEnabled()) {
            for (Exception e : rangeResult.getExceptions()) {
                LOG.debugf("Version resolution exception: %s", (Object)e.getMessage());
            }
        }
        return rangeResult;
    }

    private static DefaultServiceLocator newServiceLocator() {
        DefaultServiceLocator locator = new DefaultServiceLocator();
        locator.addService(ArtifactDescriptorReader.class, DefaultArtifactDescriptorReader.class);
        locator.addService(VersionResolver.class, DefaultVersionResolver.class);
        locator.addService(VersionRangeResolver.class, DefaultVersionRangeResolver.class);
        locator.addService(MetadataGeneratorFactory.class, SnapshotMetadataGeneratorFactory.class);
        locator.addService(MetadataGeneratorFactory.class, VersionsMetadataGeneratorFactory.class);
        return locator;
    }

    private static RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = DefaultAvailableVersionsResolver.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            @Override
            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                LOG.errorf("Service creation failed for %s implementation %s: %s", type, impl, exception.getMessage(), exception);
            }
        });
        return locator.getService(RepositorySystem.class);
    }

    private static DefaultRepositorySystemSession newRepositorySystemSession(RepositorySystem system) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository("target/local-repo");
        session.setLocalRepositoryManager(system.newLocalRepositoryManager(session, localRepo));
        return session;
    }

    private static List<RemoteRepository> newRemoteRepositoryList(Map<String, String> repositories) {
        if (!repositories.isEmpty()) {
            ArrayList<RemoteRepository> repos = new ArrayList<RemoteRepository>();
            for (Map.Entry<String, String> entry : repositories.entrySet()) {
                repos.add(new RemoteRepository.Builder(entry.getKey(), "default", entry.getValue()).build());
            }
            LOG.infof("Using repositories: %s", (Object)repositories.values());
            return repos;
        }
        LOG.infof("Using Maven Central repository", new Object[0]);
        return Collections.singletonList(new RemoteRepository.Builder("central", "default", "https://repo1.maven.org/maven2/").build());
    }
}

