/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.mavendependencyupdater;

import java.util.List;
import java.util.Optional;
import org.apache.maven.model.Dependency;

public class MavenUtils {
    public static boolean isProperty(String value) {
        return value.startsWith("${") && value.endsWith("}");
    }

    public static String extractPropertyName(String value) {
        if (!MavenUtils.isProperty(value)) {
            throw new IllegalArgumentException("Not a property: " + value);
        }
        return value.substring(2, value.length() - 1);
    }

    public static Optional<Dependency> findDependency(List<Dependency> dependencies, String artifactId) {
        return dependencies.stream().filter(d -> artifactId.equals(d.getArtifactId())).findFirst();
    }

    public static Optional<Dependency> findDependency(List<Dependency> dependencies, String groupId, String artifactId) {
        return dependencies.stream().filter(d -> artifactId.equals(d.getArtifactId()) && groupId.equals(d.getGroupId())).findFirst();
    }
}

