/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.mavendependencyupdater.core.processingstrategies;

import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jboss.set.mavendependencyupdater.ArtifactResult;
import org.jboss.set.mavendependencyupdater.ComponentUpgrade;
import org.jboss.set.mavendependencyupdater.PomDependencyUpdater;
import org.jboss.set.mavendependencyupdater.core.processingstrategies.UpgradeProcessingStrategy;

public class ModifyLocallyProcessingStrategy
implements UpgradeProcessingStrategy {
    private File pomFile;

    public ModifyLocallyProcessingStrategy(File pomFile) {
        this.pomFile = pomFile;
    }

    @Override
    public boolean process(List<ArtifactResult<ComponentUpgrade>> scopedUpdates) {
        try {
            List<ComponentUpgrade> updates = scopedUpdates.stream().map(ArtifactResult::getLatestConfigured).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            PomDependencyUpdater.upgradeDependencies(this.pomFile, updates);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to upgrade dependencies in pom.xml", e);
        }
    }
}

