/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.mavendependencyupdater.rules;

import java.util.regex.Pattern;
import org.jboss.set.mavendependencyupdater.rules.Restriction;
import org.jboss.set.mavendependencyupdater.rules.TokenizedVersion;

public class VersionPrefixRestriction
implements Restriction {
    private String prefixString;
    private TokenizedVersion prefixVersion;
    private Pattern remainderRegex;

    public VersionPrefixRestriction(String prefixString) {
        this(prefixString, null);
    }

    public VersionPrefixRestriction(String prefix, String remainderRegex) {
        this.prefixString = prefix;
        this.prefixVersion = TokenizedVersion.parse(prefix);
        if (remainderRegex != null) {
            this.remainderRegex = Pattern.compile(remainderRegex);
        }
    }

    @Override
    public boolean applies(String versionString, String originalVersion) {
        TokenizedVersion version = TokenizedVersion.parse(versionString);
        if (!this.prefixVersion.isPrefixOf(version)) {
            return false;
        }
        if (this.remainderRegex != null) {
            String suffix = versionString.length() > this.prefixString.length() ? versionString.substring(this.prefixString.length() + 1) : "";
            return this.remainderRegex.matcher(suffix).matches();
        }
        return true;
    }

    public String getPrefixString() {
        return this.prefixString;
    }
}

